/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Util;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.InvGUIStorage;
import net.kyori.adventure.key.Key;
import org.apache.commons.text.WordUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryUtil {
    private final HashMap<Enchantment, InvGUIStorage> itemList = new HashMap();

    public void addEnchantment(AbstractCustomEnchantment enchantment, ItemStack tool, Material type, String toolType, String enchantmentName, int page, int index, boolean custom) {
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + enchantment.getKey())));
        this.addEnchantment(yourEnchantment, tool, type, toolType, enchantmentName, page, index, custom);
    }

    public void addEnchantment(Enchantment enchantment, ItemStack tool, Material type, String toolType, String enchantmentName, int page, int index, boolean custom) {
        ItemStack stack = new ItemStack(type);
        stack = custom ? this.handleCustomEnchantSection(stack, tool, enchantment, toolType, enchantmentName) : this.addEnchantment(tool, toolType, enchantmentName.replaceAll(" ", "").replaceAll("-", ""), enchantment, enchantmentName, stack);
        this.itemList.put(enchantment, new InvGUIStorage(index, page, stack));
    }

    public void addCustomStack(AbstractCustomEnchantment enchantment, ItemStack tool, ItemStack item, String toolType, String enchantmentName, int page, int index, boolean custom) {
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + enchantment.getKey())));
        this.addCustomStack(yourEnchantment, tool, item, toolType, enchantmentName, page, index, custom);
    }

    public void addCustomStack(Enchantment enchantment, ItemStack tool, ItemStack item, String toolType, String enchantmentName, int page, int index, boolean custom) {
        ItemStack stack = item;
        stack = custom ? this.handleCustomEnchantSection(stack, tool, enchantment, toolType, enchantmentName) : this.addEnchantment(tool, toolType, enchantmentName.replaceAll(" ", "").replaceAll("-", ""), enchantment, enchantmentName, stack);
        this.itemList.put(enchantment, new InvGUIStorage(index, page, stack));
    }

    public List<InvGUIStorage> getContents(int page) {
        ArrayList<InvGUIStorage> list = new ArrayList<InvGUIStorage>();
        for (Enchantment enchantment : this.itemList.keySet()) {
            if (this.itemList.get(enchantment).getPage() != page) continue;
            list.add(this.itemList.get(enchantment));
        }
        return list;
    }

    public InvGUIStorage getEnchantment(Enchantment enchantment) {
        return this.itemList.get(enchantment);
    }

    public void reset() {
        this.itemList.clear();
    }

    private ItemStack handleCustomEnchantSection(ItemStack item, ItemStack tool, Enchantment enchants, String type, String enchantment) {
        int level = tool.getEnchantmentLevel(enchants);
        String pathName = WordUtils.capitalizeFully(enchants.getKey().getKey().replaceAll("_", " ")).replaceAll(" ", "");
        String name = UpgradeableTools.PLUGIN.getConfig().getString("MultiplierToLevel." + type + "." + pathName + ".name", WordUtils.capitalizeFully(enchants.getKey().getKey().replaceAll("_", " ")));
        this.addCustomEnchant(type, item, enchants, level, name);
        if (UpgradeableTools.PLUGIN.getConfig().getBoolean("MultiplierToLevel." + type + "." + pathName + ".enabled")) {
            return item;
        }
        return null;
    }

    private ItemStack addCustomEnchant(String toolType, ItemStack item, Enchantment enchantment, int enchantmentLevel, String enchName) {
        ArrayList<CallSite> lores;
        ItemMeta itemMeta;
        block5: {
            itemMeta = item.getItemMeta();
            lores = new ArrayList<CallSite>();
            String pathName = WordUtils.capitalizeFully(enchantment.getKey().getKey().replaceAll("_", " ")).replaceAll(" ", "");
            int maxEnchantmentLevel = UpgradeableTools.PLUGIN.getConfig().getInt("MultiplierToLevel." + toolType + "." + pathName + ".MaximumLevel");
            lores.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + enchName + " " + maxEnchantmentLevel)));
            double enchantmentStart = UpgradeableTools.PLUGIN.getConfig().getDouble("MultiplierToLevel." + toolType + "." + pathName + ".Start");
            double enchantmentMultiplier = UpgradeableTools.PLUGIN.getConfig().getDouble("MultiplierToLevel." + toolType + "." + pathName + ".Multiplier");
            try {
                if (enchantmentLevel > 0) {
                    if (enchantmentLevel == maxEnchantmentLevel) {
                        itemMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + enchName + " --- " + String.valueOf(ChatColor.GREEN) + maxEnchantmentLevel + "/" + maxEnchantmentLevel);
                    } else {
                        double cost = (double)enchantmentLevel * enchantmentMultiplier * enchantmentStart;
                        lores.add((CallSite)((Object)(String.valueOf(ChatColor.BLUE) + " Cost: ")));
                        lores.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + cost)));
                        itemMeta.setLore(lores);
                        itemMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + enchName + " --- " + String.valueOf(ChatColor.DARK_AQUA) + enchantmentLevel + "/" + maxEnchantmentLevel);
                    }
                    break block5;
                }
                throw new Exception();
            }
            catch (Exception e) {
                lores.add((CallSite)((Object)(String.valueOf(ChatColor.BLUE) + "Cost: ")));
                lores.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + enchantmentStart)));
                itemMeta.setLore(lores);
                itemMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + enchName + " --- " + String.valueOf(ChatColor.DARK_AQUA) + "0/" + maxEnchantmentLevel);
            }
        }
        item.setItemMeta(itemMeta);
        lores.clear();
        return item;
    }

    private ItemStack addEnchantment(ItemStack tool, String toolString, String enchPath, Enchantment enchantment, String displayName, ItemStack item) {
        ArrayList<CallSite> lores = new ArrayList<CallSite>();
        Map enchants = tool.getItemMeta().getEnchants();
        ItemMeta itemMeta = item.getItemMeta();
        int maxLevel = UpgradeableTools.PLUGIN.getConfig().getInt("MultiplierToLevel." + toolString + "." + enchPath + ".MaximumLevel");
        double start = UpgradeableTools.PLUGIN.getConfig().getDouble("MultiplierToLevel." + toolString + "." + enchPath + ".Start");
        double multiplier = UpgradeableTools.PLUGIN.getConfig().getDouble("MultiplierToLevel." + toolString + "." + enchPath + ".Multiplier");
        itemMeta.addEnchant(enchantment, maxLevel, true);
        if (enchants.containsKey(enchantment)) {
            if ((Integer)enchants.get(enchantment) == maxLevel) {
                itemMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + displayName + " --- " + String.valueOf(ChatColor.GREEN) + maxLevel + "/" + maxLevel);
            } else {
                double cost = (double)((Integer)enchants.get(enchantment)).intValue() * multiplier * start;
                lores.add((CallSite)((Object)(String.valueOf(ChatColor.BLUE) + "Cost: ")));
                lores.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + cost)));
                itemMeta.setLore(lores);
                itemMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + displayName + " --- " + String.valueOf(ChatColor.DARK_AQUA) + String.valueOf(enchants.get(enchantment)) + "/" + maxLevel);
            }
        } else {
            lores.add((CallSite)((Object)(String.valueOf(ChatColor.BLUE) + "Cost: ")));
            lores.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + start)));
            itemMeta.setLore(lores);
            itemMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + displayName + " --- " + String.valueOf(ChatColor.DARK_AQUA) + "0/" + maxLevel);
        }
        item.setItemMeta(itemMeta);
        lores.clear();
        return item;
    }
}

