/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.marcangeloh.API.Util.ConfigurationUtil.ValueUtil;
import me.marcangeloh.Config.ConfigManager;
import me.marcangeloh.CustomEnchantments.CustomEnchants;
import me.marcangeloh.Events.AnvilEvent;
import me.marcangeloh.Events.DisenchantEvent;
import me.marcangeloh.Events.EnchantEvent;
import me.marcangeloh.Events.Events;
import me.marcangeloh.Events.JobEvents;
import me.marcangeloh.Metrics;
import me.marcangeloh.PointsCore;
import me.marcangeloh.Util.CommandUtil;
import me.marcangeloh.Util.PointsUtil;
import me.marcangeloh.Util.UpdateChecker;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Consumer;

public class UpgradeableTools
extends JavaPlugin {
    public static UpgradeableTools PLUGIN;
    private static final Pattern HEX_PATTERN;
    public static final String BRANDING_PREFIX;
    private final ConfigManager cfgm;
    private ValueUtil valueUtil;
    private PointsUtil pointsUtil;
    public PointsCore pointsCore;
    public static boolean isWorldGuardEnabled;
    public static WorldGuardPlugin WGBukkit;
    public static boolean useEconomy;
    public static boolean usePointsCore;
    private static Economy econ;
    private Events pluginEvents;
    private final CustomEnchants customEnchants;
    public static HashMap<UUID, Integer> cdtime;

    public static Economy getEconomy() {
        return econ;
    }

    public UpgradeableTools(ConfigManager configManager, CustomEnchants customEnchants) {
        this.cfgm = configManager;
        this.customEnchants = customEnchants;
    }

    public void onEnable() {
        PLUGIN = this;
        this.cfgm.setup();
        this.printAsciiArt();
        this.getLogger().info(BRANDING_PREFIX + "Config loaded.");
        this.pointsCore = (PointsCore)UpgradeableTools.getPlugin(PointsCore.class);
        this.valueUtil = new ValueUtil(this.pointsCore);
        this.pointsUtil = new PointsUtil(this.pointsCore);
        this.pluginEvents = new Events(this.valueUtil, this.pointsUtil);
        this.pluginEvents.onEnable();
        this.getServer().getPluginManager().registerEvents((Listener)this.pluginEvents, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DisenchantEvent(this.valueUtil), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AnvilEvent(this.valueUtil), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EnchantEvent(this.valueUtil), (Plugin)this);
        this.customEnchants.onEnable(this);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            CommandUtil commandUtil = new CommandUtil(commands);
            commandUtil.registerUTCommand();
            commandUtil.registerUTACommand();
        });
        this.setupMetrics();
        this.setupWorldGuardIntegration();
        this.setupEconomyIntegration();
        this.setupPointsCoreIntegration();
        try {
            this.setupNormalConfig();
        }
        catch (IOException e) {
            this.getServer().getConsoleSender().sendRichMessage(BRANDING_PREFIX + "<red>The plugin encountered an issue saving the config. Disabling now.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (econ == null && !usePointsCore) {
            this.getServer().getPluginManager().registerEvents((Listener)new JobEvents(), (Plugin)this);
        }
        this.setCraftingRecipes();
        this.startCooldownRunnable();
        this.checkForUpdates();
        this.getLogger().info(BRANDING_PREFIX + String.valueOf(ChatColor.GREEN) + "The plugin has been enabled successfully.");
    }

    public void onDisable() {
        if (econ == null && !usePointsCore) {
            this.savePlayerData();
        }
        this.pluginEvents.onDisable();
        this.customEnchants.onDisable();
        NamespacedKey craftingKey = new NamespacedKey((Plugin)this, "crafting-key");
        this.getServer().removeRecipe(craftingKey);
        this.getLogger().info(BRANDING_PREFIX + String.valueOf(ChatColor.RED) + "The plugin has been disabled successfully.");
    }

    private void printAsciiArt() {
        this.getLogger().info("\n\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2580\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\n\u2588\u2584\u2500\u2588\u2588\u2500\u2584\u2588\u2584\u2500\u2584\u2584\u2500\u2588\u2500\u2584\u2584\u2584\u2584\u2588\u2584\u2500\u2584\u2584\u2580\u2588\u2588\u2580\u2584\u2500\u2588\u2588\u2584\u2500\u2584\u2584\u2580\u2588\u2584\u2500\u2584\u2584\u2500\u2588\u2588\u2580\u2584\u2500\u2588\u2588\u2584\u2500\u2584\u2500\u2580\u2588\u2584\u2500\u2584\u2588\u2588\u2588\u2584\u2500\u2584\u2584\u2500\u2588\u2588\u2588\u2500\u2584\u2500\u2584\u2500\u2588\u2500\u2584\u2584\u2500\u2588\u2500\u2584\u2584\u2500\u2588\u2584\u2500\u2584\u2588\u2588\u2588\u2500\u2584\u2584\u2584\u2584\u2588\n\u2588\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2588\u2500\u2584\u2584\u2584\u2588\u2500\u2588\u2588\u2584\u2500\u2588\u2588\u2500\u2584\u2500\u2584\u2588\u2588\u2500\u2580\u2500\u2588\u2588\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2500\u2584\u2588\u2580\u2588\u2588\u2500\u2580\u2500\u2588\u2588\u2588\u2500\u2584\u2500\u2580\u2588\u2588\u2500\u2588\u2588\u2580\u2588\u2588\u2500\u2584\u2588\u2580\u2588\u2588\u2588\u2588\u2588\u2500\u2588\u2588\u2588\u2500\u2588\u2588\u2500\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2500\u2588\u2588\u2580\u2588\u2584\u2584\u2584\u2584\u2500\u2588\n\u2580\u2580\u2584\u2584\u2584\u2584\u2580\u2580\u2584\u2584\u2584\u2580\u2580\u2580\u2584\u2584\u2584\u2584\u2584\u2580\u2584\u2584\u2580\u2584\u2584\u2580\u2584\u2584\u2580\u2584\u2584\u2580\u2584\u2584\u2584\u2584\u2580\u2580\u2584\u2584\u2584\u2584\u2584\u2580\u2584\u2584\u2580\u2584\u2584\u2580\u2584\u2584\u2584\u2584\u2580\u2580\u2584\u2584\u2584\u2584\u2584\u2580\u2584\u2584\u2584\u2584\u2584\u2580\u2580\u2580\u2580\u2584\u2584\u2584\u2580\u2580\u2584\u2584\u2584\u2584\u2580\u2584\u2584\u2584\u2584\u2580\u2584\u2584\u2584\u2584\u2584\u2580\u2584\u2584\u2584\u2584\u2584\u2580");
    }

    private void setupMetrics() {
        int pluginId = 4292;
        new Metrics(this, pluginId);
    }

    private void checkForUpdates() {
        new UpdateChecker(this, 108554).getVersion((Consumer<String>)((Consumer)version -> {
            Double onlineDouble = this.parseVersionString((String)version);
            Double localDouble = this.parseVersionString(this.getDescription().getVersion());
            if (localDouble < onlineDouble) {
                this.getLogger().warning(BRANDING_PREFIX + String.valueOf(ChatColor.RED) + "has a new update available. Latest version is " + String.valueOf(ChatColor.GREEN) + version + String.valueOf(ChatColor.RED) + ". Your version is " + this.getDescription().getVersion());
            }
        }));
    }

    private Double parseVersionString(String rawVersion) {
        Object versionProcessed = rawVersion.replace(".", "").replace("-SNAPSHOT", "");
        if (((String)versionProcessed).length() >= 4) {
            versionProcessed = ((String)versionProcessed).substring(0, 3) + "." + ((String)versionProcessed).substring(3);
        }
        return Double.parseDouble((String)versionProcessed);
    }

    private void setupWorldGuardIntegration() {
        Plugin worldGuardPlugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        if (worldGuardPlugin instanceof WorldGuardPlugin) {
            WGBukkit = (WorldGuardPlugin)worldGuardPlugin;
            isWorldGuardEnabled = true;
            this.getLogger().info(BRANDING_PREFIX + "WorldGuard found and integrated.");
        } else {
            isWorldGuardEnabled = false;
            this.getLogger().info(BRANDING_PREFIX + "WorldGuard not found or not a WorldGuardPlugin instance. Integration disabled.");
        }
    }

    private void setupPointsCoreIntegration() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("PointsCore");
        if (plugin instanceof PointsCore) {
            usePointsCore = true;
            this.pointsCore = (PointsCore)plugin;
            this.getLogger().info(BRANDING_PREFIX + String.valueOf(ChatColor.GREEN) + "PointsCore has been setup on this server.");
        } else {
            this.getLogger().info(BRANDING_PREFIX + String.valueOf(ChatColor.RED) + "PointsCore has not been setup on this server due to missing dependency.");
            usePointsCore = false;
        }
    }

    private void setupEconomyIntegration() {
        if (this.cfgm.getPlayerData().getBoolean("UpgradeWithVault", false)) {
            RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp != null) {
                econ = (Economy)rsp.getProvider();
                useEconomy = true;
                this.getLogger().info(BRANDING_PREFIX + String.valueOf(ChatColor.GREEN) + "Vault Economy has been setup on this server.");
            } else {
                this.getLogger().warning(BRANDING_PREFIX + String.valueOf(ChatColor.RED) + "Vault found, but no Economy provider registered. Economy integration disabled.");
                useEconomy = false;
            }
        } else {
            this.getLogger().info(BRANDING_PREFIX + "Vault economy integration disabled by config.");
            useEconomy = false;
        }
        if (!useEconomy && this.cfgm.getPlayerData().getBoolean("UpgradeWithVault", false)) {
            this.getLogger().severe(BRANDING_PREFIX + String.valueOf(ChatColor.RED) + "Vault integration was enabled in config but could not be set up.");
        }
    }

    private void setupNormalConfig() throws IOException {
        this.saveResource("PermissionsConfig.yml", false);
        this.saveDefaultConfig();
    }

    private void setCraftingRecipes() {
        ItemStack result = new ItemStack(Material.ENCHANTING_TABLE);
        ItemMeta resultMeta = result.getItemMeta();
        if (resultMeta != null) {
            resultMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Enchanting Maximizer");
            ArrayList<CallSite> lores = new ArrayList<CallSite>();
            lores.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Place this block to begin")));
            lores.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "your enchanting journey!")));
            resultMeta.setLore(lores);
            result.setItemMeta(resultMeta);
        }
        NamespacedKey craftingKey = new NamespacedKey((Plugin)this, "crafting-key");
        ShapelessRecipe shapelessRecipe = new ShapelessRecipe(craftingKey, result);
        shapelessRecipe.addIngredient(Material.ENCHANTING_TABLE);
        shapelessRecipe.addIngredient(Material.AMETHYST_SHARD);
        this.getServer().addRecipe((Recipe)shapelessRecipe);
        this.getLogger().info(BRANDING_PREFIX + "Crafting recipes loaded.");
    }

    private void startCooldownRunnable() {
        new BukkitRunnable(){

            public void run() {
                if (cdtime.isEmpty()) {
                    return;
                }
                cdtime.entrySet().removeIf(entry -> {
                    entry.setValue((Integer)entry.getValue() - 1);
                    return (Integer)entry.getValue() <= 0;
                });
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    public static List<String> getEnchantmentNames() {
        ArrayList<String> enchantmentNames = new ArrayList<String>();
        if (PLUGIN != null && PLUGIN.getConfig().isConfigurationSection("MultiplierToLevel")) {
            for (String tools : PLUGIN.getConfig().getConfigurationSection("MultiplierToLevel").getKeys(false)) {
                if (!PLUGIN.getConfig().isConfigurationSection("MultiplierToLevel." + tools)) continue;
                for (String enchantment : PLUGIN.getConfig().getConfigurationSection("MultiplierToLevel." + tools).getKeys(false)) {
                    String name = PLUGIN.getConfig().getString("MultiplierToLevel." + tools + "." + enchantment + ".name");
                    if (name == null || name.equalsIgnoreCase("undefined enchantment")) continue;
                    enchantmentNames.add(name);
                }
            }
        }
        return enchantmentNames;
    }

    private static String format(String s) {
        String cleaned = s;
        Matcher matcher = HEX_PATTERN.matcher(cleaned);
        while (matcher.find()) {
            String color = cleaned.substring(matcher.start(), matcher.end());
            cleaned = cleaned.replace(color, String.valueOf(net.md_5.bungee.api.ChatColor.of((String)color)));
            matcher = HEX_PATTERN.matcher(cleaned);
        }
        return net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)cleaned).replaceAll("&", "");
    }

    private void savePlayerData() {
        this.saveJobPoints(JobEvents.fishingPoints, ".FishingPoints");
        this.saveJobPoints(JobEvents.pickaxePoints, ".PickaxePoints");
        this.saveJobPoints(JobEvents.shovelPoints, ".ShovelPoints");
        this.saveJobPoints(JobEvents.axePoints, ".AxePoints");
        this.saveJobPoints(JobEvents.weaponPoints, ".WeaponPoints");
        this.saveJobPoints(JobEvents.hoePoints, ".HoePoints");
        this.saveJobPoints(JobEvents.armorPoints, ".ArmorPoints");
        this.cfgm.savePlayerData();
        this.getLogger().info(BRANDING_PREFIX + String.valueOf(ChatColor.GREEN) + "Saved Player data.");
    }

    private void saveJobPoints(HashMap<String, Double> pointsMap, String pathSuffix) {
        for (Map.Entry<String, Double> entry : pointsMap.entrySet()) {
            this.cfgm.getPlayerData().set(entry.getKey() + pathSuffix, (Object)entry.getValue());
        }
    }

    static {
        HEX_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");
        BRANDING_PREFIX = UpgradeableTools.format("&#3e713eU&#44833cp&#4a943ag&#50a638r&#56b736a&#5bc933d&#61da31e&#67ec2fa&#6dfd2db&#77fd3eb&#80fe4fe&#8afe60T&#94fe71o&#9dfe81o&#a7ff92l&#b0ffa3s&#baffb4: ");
        useEconomy = false;
        usePointsCore = false;
        econ = null;
        cdtime = new HashMap();
    }
}

