/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.marcangeloh.Util.ChatActions;
import me.marcangeloh.Util.ChatStorage;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerChatEvent
implements Listener {
    private final HashMap<Player, ChatStorage> chatActionsMap = new HashMap();
    private final HashMap<Player, ArrayList<String>> loresCollector = new HashMap();

    public void setPlayerActions(Player player, ChatStorage storage) {
        if (this.chatActionsMap.containsKey(player)) {
            this.chatActionsMap.get(player).setActions(storage.getActions());
            this.chatActionsMap.get(player).setStack(storage.getStack());
            return;
        }
        this.chatActionsMap.putIfAbsent(player, storage);
    }

    public void onDisable() {
        for (Player player : this.chatActionsMap.keySet()) {
            if (this.chatActionsMap.get(player).getActions().equals((Object)ChatActions.NONE) || this.chatActionsMap.get(player).getStack() == null) continue;
            player.getInventory().addItem(new ItemStack[]{this.chatActionsMap.get(player).getStack()});
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void playerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!this.chatActionsMap.containsKey(player)) {
            return;
        }
        ChatStorage storage = this.chatActionsMap.get(player);
        if (storage.getActions().equals((Object)ChatActions.NONE)) {
            return;
        }
        event.setCancelled(true);
        ItemStack stack = storage.getStack();
        if (storage.getActions().equals((Object)ChatActions.HANDLE_NAME)) {
            ItemMeta im = storage.getStack().getItemMeta();
            String text = ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)ChatColor.translateAlternateColorCodes((char)'&', (String)event.getMessage()));
            im.setDisplayName(text);
            stack.setItemMeta(im);
            player.getInventory().addItem(new ItemStack[]{stack});
            storage.setActions(ChatActions.NONE);
            storage.setStack(null);
            this.chatActionsMap.put(player, storage);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Name changed successfully.");
            return;
        }
        if (storage.getActions().equals((Object)ChatActions.HANDLE_LORE)) {
            if (event.getMessage().equalsIgnoreCase("done")) {
                ItemMeta im = storage.getStack().getItemMeta();
                im.setLore((List)this.loresCollector.get(player));
                stack.setItemMeta(im);
                player.getInventory().addItem(new ItemStack[]{stack});
                storage.setActions(ChatActions.NONE);
                storage.setStack(null);
                this.chatActionsMap.put(player, storage);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Item Lore successfully modified.");
            } else {
                this.loresCollector.putIfAbsent(player, new ArrayList());
                String text = ChatColor.translateAlternateColorCodes((char)'&', (String)event.getMessage());
                this.loresCollector.get(player).add(ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)text));
            }
        }
    }
}

