/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Events;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import me.marcangeloh.API.Util.ConfigurationUtil.ValueUtil;
import me.marcangeloh.API.Util.GeneralUtil.Tools;
import me.marcangeloh.Config.ConfigManager;
import me.marcangeloh.CustomEnchantments.CustomEnchants;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.Events.JobEvents;
import me.marcangeloh.Events.PlayerChatEvent;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.ChatActions;
import me.marcangeloh.Util.ChatStorage;
import me.marcangeloh.Util.CheckerUtil;
import me.marcangeloh.Util.InvGUIStorage;
import me.marcangeloh.Util.InventoryUtil;
import me.marcangeloh.Util.PointsUtil;
import net.kyori.adventure.key.Key;
import org.apache.commons.text.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Events
extends ConfigManager
implements Listener {
    HashMap<Player, Boolean> giveBack = new HashMap();
    InventoryUtil inventoryUtil = new InventoryUtil();
    private final String branding = String.valueOf(ChatColor.AQUA) + "UT: ";
    private final PlayerChatEvent playerChatEvent = new PlayerChatEvent();
    private ItemStack settings;
    private ItemStack next;
    private ItemStack back;
    private ItemStack backpack;
    private ItemStack spook;
    private ItemStack secondChance;
    private ItemStack loreBook;
    private ItemStack bleed;
    private final ValueUtil valueUtil;
    private final PointsUtil pointsUtil;

    public Events(ValueUtil valueUtil, PointsUtil pointsUtil) {
        this.valueUtil = valueUtil;
        this.pointsUtil = pointsUtil;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void InventoryClickEvent(InventoryClickEvent e) throws NullPointerException {
        String currentItemName;
        if (e.getClickedInventory() == null) {
            return;
        }
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (e.getCurrentItem() == null) {
            return;
        }
        try {
            currentItemName = e.getCurrentItem().getItemMeta().getDisplayName();
        }
        catch (NullPointerException exception) {
            return;
        }
        if (!e.getClickedInventory().equals((Object)e.getView().getTopInventory())) {
            return;
        }
        String title = e.getView().getTitle();
        String upgradeTitle = this.branding + ChatColor.translateAlternateColorCodes((char)'&', (String)UpgradeableTools.PLUGIN.getConfig().getString("InventoryTitles.UpgradeInventory"));
        if (title.contains(this.branding + ChatColor.translateAlternateColorCodes((char)'&', (String)UpgradeableTools.PLUGIN.getConfig().getString("InventoryTitles.SelectionInventory")))) {
            if (currentItemName.equalsIgnoreCase(String.valueOf(ChatColor.RED) + "Cancel")) {
                e.setCancelled(true);
                if (e.getInventory().getItem(13) != null) {
                    player.getInventory().addItem(new ItemStack[]{e.getInventory().getItem(13)});
                }
                this.giveBack.put(player, false);
                player.closeInventory();
                this.giveBack.put(player, true);
            } else if (currentItemName.equalsIgnoreCase(String.valueOf(ChatColor.GREEN) + "Continue")) {
                e.setCancelled(true);
                this.giveBack.put(player, false);
                if (e.getInventory().getItem(13) == null || e.getInventory().getItem(13).getType().equals((Object)Material.AIR)) {
                    player.sendMessage(UpgradeableTools.BRANDING_PREFIX + String.valueOf(ChatColor.RED) + "You must put your tool to upgrade in the empty slot!");
                } else {
                    ItemStack tool = e.getClickedInventory().getItem(13);
                    this.openUpgradeGUI(player, tool, 1);
                }
                this.giveBack.put(player, true);
            } else if (currentItemName.equalsIgnoreCase(String.valueOf(ChatColor.GREEN))) {
                e.setCancelled(true);
            }
        } else if (title.contains(upgradeTitle)) {
            e.setCancelled(true);
            String pageString = title.replace(upgradeTitle, "").replaceAll(" ", "").replaceAll("p.", "");
            if (pageString == "") {
                return;
            }
            int page = Integer.parseInt(pageString);
            ItemStack item = e.getClickedInventory().getItem(22);
            if (item == null) {
                return;
            }
            ItemMeta itemMeta = item.getItemMeta();
            if (itemMeta.getEnchants().size() >= 2) {
                if (!CheckerUtil.checkForHelmet(item)) {
                    if (itemMeta.hasEnchant(Enchantment.AQUA_AFFINITY)) {
                        itemMeta.removeEnchant(Enchantment.AQUA_AFFINITY);
                        itemMeta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        item.setItemMeta(itemMeta);
                    }
                } else if (itemMeta.hasEnchant(Enchantment.SHARPNESS)) {
                    itemMeta.removeEnchant(Enchantment.SHARPNESS);
                    itemMeta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    item.setItemMeta(itemMeta);
                }
            }
            switch (e.getCurrentItem().getType()) {
                case BEACON: {
                    this.addToInventoryClickEvent(CustomEnchants.autoEquip, "AutoEquip", player, item, page);
                    break;
                }
                case HOPPER: {
                    this.addToInventoryClickEvent(CustomEnchants.magnetic, "Magnetic", player, item, page);
                    break;
                }
                case MINECART: {
                    this.addToInventoryClickEvent(CustomEnchants.speed, "Speed", player, item, page);
                    break;
                }
                case SKELETON_SKULL: {
                    this.addToInventoryClickEvent(CustomEnchants.decapitation, "Decapitation", player, item, page);
                    break;
                }
                case TURTLE_SCUTE: {
                    this.addToInventoryClickEvent(Enchantment.RESPIRATION, "Respiration", player, item, page);
                    break;
                }
                case DIAMOND_PICKAXE: {
                    this.addToInventoryClickEvent(Enchantment.AQUA_AFFINITY, "AquaAffinity", player, item, page);
                    break;
                }
                case ICE: {
                    if (!CheckerUtil.checkForBoots(item)) break;
                    this.addToInventoryClickEvent(Enchantment.FROST_WALKER, "FrostWalker", player, item, page);
                    break;
                }
                case SHIELD: {
                    this.addToInventoryClickEvent(Enchantment.PROTECTION, "Protection", player, item, page);
                    break;
                }
                case ACACIA_BOAT: {
                    if (!CheckerUtil.checkForBoots(item)) break;
                    this.addToInventoryClickEvent(Enchantment.DEPTH_STRIDER, "DepthStrider", player, item, page);
                    break;
                }
                case BLAZE_POWDER: {
                    this.addToInventoryClickEvent(Enchantment.FIRE_PROTECTION, "FireProtection", player, item, page);
                    break;
                }
                case SPONGE: {
                    if (!CheckerUtil.checkForPickaxe(item)) break;
                    this.addToInventoryClickEvent(CustomEnchants.drain, "Drain", player, item, page);
                    break;
                }
                case SOUL_LANTERN: {
                    this.addToInventoryClickEvent(CustomEnchants.soulBound, "SoulBound", player, item, page);
                    break;
                }
                case ELYTRA: {
                    this.addToInventoryClickEvent(CustomEnchants.mendWalker, "MendWalker", player, item, page);
                    break;
                }
                case FURNACE: {
                    this.addToInventoryClickEvent(CustomEnchants.smelter, "Smelter", player, item, page);
                    break;
                }
                case TNT: {
                    if (CheckerUtil.checkForPickaxe(item)) {
                        this.addToInventoryClickEvent(CustomEnchants.blastMining, "BlastMining", player, item, page);
                        break;
                    }
                    if (CheckerUtil.checkForShovel(item)) {
                        this.addToInventoryClickEvent(CustomEnchants.blastExcavating, "BlastExcavating", player, item, page);
                        break;
                    }
                    if (item.getType().equals((Object)Material.BOW)) {
                        this.addToInventoryClickEvent(CustomEnchants.explosive, "Explosive", player, item, page);
                        break;
                    }
                    this.addToInventoryClickEvent(Enchantment.BLAST_PROTECTION, "BlastProtection", player, item, page);
                    break;
                }
                case TNT_MINECART: {
                    this.addToInventoryClickEvent(CustomEnchants.explosiveTouch, "ExplosiveTouch", player, item, page);
                    break;
                }
                case SPLASH_POTION: {
                    if (currentItemName.contains("Poison Touch")) {
                        this.addToInventoryClickEvent(CustomEnchants.poisonTouch, "PoisonTouch", player, item, page);
                        break;
                    }
                    if (!currentItemName.contains("Poison Shot")) break;
                    this.addToInventoryClickEvent(CustomEnchants.poisonShot, "PoisonShot", player, item, page);
                    break;
                }
                case TOTEM_OF_UNDYING: {
                    this.addToInventoryClickEvent(CustomEnchants.lifeSteal, "LifeSteal", player, item, page);
                    break;
                }
                case REDSTONE: {
                    if (CheckerUtil.checkForTools(item)) {
                        this.addToInventoryClickEvent(Enchantment.EFFICIENCY, "Efficiency", player, item, page);
                        break;
                    }
                    if (!CheckerUtil.checkForSwords(item)) break;
                    this.addToInventoryClickEvent(CustomEnchants.shockwave, "Shockwave", player, item, page);
                    break;
                }
                case SCULK_SENSOR: {
                    this.addToInventoryClickEvent(CustomEnchants.confusion, "Confusion", player, item, page);
                    break;
                }
                case FEATHER: {
                    if (item.getEnchantmentLevel(Enchantment.FORTUNE) == 0) {
                        if (CheckerUtil.checkForPickaxe(item)) {
                            this.addToInventoryClickEvent(Enchantment.SILK_TOUCH, "SilkTouch", player, item, page);
                        } else if (CheckerUtil.checkForAxe(item)) {
                            this.addToInventoryClickEvent(Enchantment.SILK_TOUCH, "SilkTouch", player, item, page);
                        } else if (CheckerUtil.checkForShovel(item)) {
                            this.addToInventoryClickEvent(Enchantment.SILK_TOUCH, "SilkTouch", player, item, page);
                        }
                    } else {
                        player.sendMessage(UpgradeableTools.BRANDING_PREFIX + "UpgradableTools: " + String.valueOf(ChatColor.RED) + "You cannot enchant Fortune and Silk Touch");
                    }
                    if (!CheckerUtil.checkForBoots(item)) break;
                    this.addToInventoryClickEvent(Enchantment.FEATHER_FALLING, "FeatherFalling", player, item, page);
                    break;
                }
                case EMERALD: {
                    if (item.getEnchantmentLevel(Enchantment.SILK_TOUCH) == 0) {
                        if (CheckerUtil.checkForPickaxe(item)) {
                            this.addToInventoryClickEvent(Enchantment.FORTUNE, "Fortune", player, item, page);
                            break;
                        }
                        if (CheckerUtil.checkForAxe(item)) {
                            this.addToInventoryClickEvent(Enchantment.FORTUNE, "Fortune", player, item, page);
                            break;
                        }
                        if (!CheckerUtil.checkForShovel(item)) break;
                        this.addToInventoryClickEvent(Enchantment.FORTUNE, "Fortune", player, item, page);
                        break;
                    }
                    player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "UpgradableTools:" + String.valueOf(ChatColor.RED) + " You can't have fortune and silk touch on the same tool.");
                    break;
                }
                case BEDROCK: {
                    this.addToInventoryClickEvent(Enchantment.UNBREAKING, "Unbreaking", player, item, page);
                    break;
                }
                case EXPERIENCE_BOTTLE: {
                    if (CheckerUtil.checkForBow(item) && (item.containsEnchantment(Enchantment.INFINITY) || item.containsEnchantment(Enchantment.POWER))) {
                        player.sendMessage(UpgradeableTools.BRANDING_PREFIX + String.valueOf(ChatColor.RED) + "Cannot enchant due to a conflicting enchantment.");
                        break;
                    }
                    this.addToInventoryClickEvent(Enchantment.MENDING, "Mending", player, item, page);
                    break;
                }
                case COD_BUCKET: {
                    if (!item.getType().equals((Object)Material.FISHING_ROD)) break;
                    if (item.getEnchantmentLevel(Enchantment.LURE) + 1 > 5) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "UpgradableTools:" + String.valueOf(ChatColor.RED) + " Due to the games limitations, 5 is the maximum level for luck of the sea.");
                        return;
                    }
                    this.addToInventoryClickEvent(Enchantment.LURE, "Lure", player, item, page);
                    break;
                }
                case RABBIT_FOOT: {
                    if (item.getType().equals((Object)Material.FISHING_ROD)) {
                        if (item.getEnchantmentLevel(Enchantment.LUCK_OF_THE_SEA) + 1 > 5) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "UpgradableTools:" + String.valueOf(ChatColor.RED) + " Due to the games limitations, 5 is the maximum level for luck of the sea.");
                            return;
                        }
                        this.addToInventoryClickEvent(Enchantment.LUCK_OF_THE_SEA, "LuckOfTheSea", player, item, page);
                        break;
                    }
                    if (!CheckerUtil.checkForShovel(item)) break;
                    this.addToInventoryClickEvent(CustomEnchants.luck, "Luck", player, item, page);
                    break;
                }
                case PISTON: {
                    if (!CheckerUtil.checkForBow(item)) break;
                    this.addToInventoryClickEvent(Enchantment.PUNCH, "Punch", player, item, page);
                    break;
                }
                case ANVIL: {
                    if (!CheckerUtil.checkForBow(item)) break;
                    if (item.containsEnchantment(Enchantment.MENDING) || item.containsEnchantment(Enchantment.INFINITY)) {
                        player.sendMessage(UpgradeableTools.BRANDING_PREFIX + String.valueOf(ChatColor.RED) + "Cannot enchant due to a conflicting enchantment.");
                        break;
                    }
                    this.addToInventoryClickEvent(Enchantment.POWER, "Power", player, item, page);
                    break;
                }
                case CACTUS: {
                    if (CheckerUtil.checkForSwords(item)) {
                        this.addToInventoryClickEvent(Enchantment.SHARPNESS, "Sharpness", player, item, page);
                        break;
                    }
                    this.addToInventoryClickEvent(Enchantment.THORNS, "Thorns", player, item, page);
                    break;
                }
                case FIRE_CHARGE: {
                    if (CheckerUtil.checkForSwords(item)) {
                        this.addToInventoryClickEvent(Enchantment.FIRE_ASPECT, "FireAspect", player, item, page);
                        break;
                    }
                    if (!item.getType().equals((Object)Material.BOW)) break;
                    this.addToInventoryClickEvent(Enchantment.FLAME, "Flame", player, item, page);
                    break;
                }
                case BUCKET: {
                    if (!CheckerUtil.checkForSwords(item)) break;
                    this.addToInventoryClickEvent(Enchantment.LOOTING, "Looting", player, item, page);
                    break;
                }
                case ARROW: {
                    if (item.getType().equals((Object)Material.BOW)) {
                        if (item.containsEnchantment(Enchantment.MENDING) || item.containsEnchantment(Enchantment.POWER)) {
                            player.sendMessage(UpgradeableTools.BRANDING_PREFIX + String.valueOf(ChatColor.RED) + "Cannot enchant due to a conflicting enchantment.");
                            break;
                        }
                        this.addToInventoryClickEvent(Enchantment.INFINITY, "Infinity", player, item, page);
                        break;
                    }
                    if (item.getType().equals((Object)Material.TRIDENT)) {
                        this.addToInventoryClickEvent(Enchantment.IMPALING, "Impaling", player, item, page);
                        break;
                    }
                    if (item.getType().equals((Object)Material.CROSSBOW)) {
                        this.addToInventoryClickEvent(Enchantment.MULTISHOT, "Multishot", player, item, page);
                        break;
                    }
                    this.addToInventoryClickEvent(Enchantment.PROJECTILE_PROTECTION, "ProjectileProtection", player, item, page);
                    break;
                }
                case BONE: {
                    if (!CheckerUtil.checkForSwords(item)) break;
                    this.addToInventoryClickEvent(Enchantment.SMITE, "Smite", player, item, page);
                    break;
                }
                case SPIDER_EYE: {
                    if (!CheckerUtil.checkForSwords(item)) break;
                    this.addToInventoryClickEvent(Enchantment.BANE_OF_ARTHROPODS, "BaneOfArthropods", player, item, page);
                    break;
                }
                case DISPENSER: {
                    if (CheckerUtil.checkForSwords(item)) {
                        this.addToInventoryClickEvent(Enchantment.KNOCKBACK, "Knockback", player, item, page);
                        break;
                    }
                    if (!CheckerUtil.checkForHoe(item)) break;
                    this.addToInventoryClickEvent(CustomEnchants.massPlanter, "MassPlanter", player, item, page);
                    break;
                }
                case CHAINMAIL_CHESTPLATE: {
                    if (!item.getType().equals((Object)Material.CROSSBOW)) break;
                    this.addToInventoryClickEvent(Enchantment.PIERCING, "Piercing", player, item, page);
                    break;
                }
                case RAIL: {
                    if (!item.getType().equals((Object)Material.CROSSBOW)) break;
                    this.addToInventoryClickEvent(Enchantment.QUICK_CHARGE, "QuickCharge", player, item, page);
                    break;
                }
                case IRON_HOE: {
                    if (!CheckerUtil.checkForSwords(item)) break;
                    this.addToInventoryClickEvent(Enchantment.SWEEPING_EDGE, "SweepingEdge", player, item, page);
                    break;
                }
                case WOLF_SPAWN_EGG: {
                    if (!item.getType().equals((Object)Material.TRIDENT)) break;
                    if (item.containsEnchantment(Enchantment.RIPTIDE)) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "UpgradableTools:" + String.valueOf(ChatColor.RED) + " You can't have riptide and loyalty on the same tool.");
                        return;
                    }
                    this.addToInventoryClickEvent(Enchantment.LOYALTY, "Loyalty", player, item, page);
                    break;
                }
                case END_CRYSTAL: {
                    if (!item.getType().equals((Object)Material.TRIDENT)) break;
                    this.addToInventoryClickEvent(Enchantment.CHANNELING, "Channeling", player, item, page);
                    break;
                }
                case ENDER_PEARL: {
                    if (item.getType().equals((Object)Material.TRIDENT)) {
                        if (item.containsEnchantment(Enchantment.LOYALTY)) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "UpgradableTools:" + String.valueOf(ChatColor.RED) + " You can't have riptide and loyalty on the same tool.");
                            return;
                        }
                        this.addToInventoryClickEvent(Enchantment.RIPTIDE, "Riptide", player, item, page);
                        break;
                    }
                    if (!CheckerUtil.checkForHelmet(item)) break;
                    this.addToInventoryClickEvent(CustomEnchants.blink, "Blink", player, item, page);
                    break;
                }
                case ENDER_EYE: {
                    this.addToInventoryClickEvent(CustomEnchants.nightVision, "NightVision", player, item, page);
                    break;
                }
                case STONECUTTER: {
                    this.addToInventoryClickEvent(CustomEnchants.fell, "Fell", player, item, page);
                    break;
                }
                case OAK_LOG: {
                    this.addToInventoryClickEvent(CustomEnchants.dupe, "Dupe", player, item, page);
                    break;
                }
                case WHEAT: {
                    this.addToInventoryClickEvent(CustomEnchants.massHarvester, "MassHarvester", player, item, page);
                    break;
                }
                case SNOWBALL: {
                    if (!CheckerUtil.checkForSwords(item)) break;
                    this.addToInventoryClickEvent(CustomEnchants.freeze, "Freeze", player, item, page);
                    break;
                }
                case PLAYER_HEAD: {
                    if (currentItemName.equalsIgnoreCase(String.valueOf(ChatColor.BLUE) + "Settings")) {
                        this.giveBack.put(player, false);
                        player.closeInventory();
                        this.giveBack.put(player, true);
                        this.openSettingsGUI(player, item);
                        break;
                    }
                    if (e.getCurrentItem().equals((Object)this.backpack)) {
                        this.addToInventoryClickEvent(CustomEnchants.backpack, "Backpack", player, item, page);
                        break;
                    }
                    if (currentItemName.contains(UpgradeableTools.PLUGIN.getConfig().getString("MultiplierToLevel.Armor.SecondChance.name"))) {
                        this.addToInventoryClickEvent(CustomEnchants.secondChance, "SecondChance", player, item, page);
                        break;
                    }
                    if (currentItemName.contains(UpgradeableTools.PLUGIN.getConfig().getString("MultiplierToLevel.Swords.Bleed.name"))) {
                        this.addToInventoryClickEvent(CustomEnchants.bleed, "Bleed", player, item, page);
                        break;
                    }
                    if (currentItemName.contains(UpgradeableTools.PLUGIN.getConfig().getString("MultiplierToLevel.Swords.Spook.name"))) {
                        this.addToInventoryClickEvent(CustomEnchants.spook, "Spook", player, item, page);
                        break;
                    }
                    if (ChatColor.stripColor((String)currentItemName).contains("Next Page")) {
                        this.handleUpgradePage(player, item, page + 1);
                        break;
                    }
                    if (!currentItemName.contains("Back")) break;
                    this.handleUpgradePage(player, item, page - 1);
                    break;
                }
                case SOUL_CAMPFIRE: {
                    this.addToInventoryClickEvent(Enchantment.SOUL_SPEED, "SoulSpeed", player, item, page);
                    break;
                }
                case GOLDEN_APPLE: {
                    this.addToInventoryClickEvent(Enchantment.SWIFT_SNEAK, "SwiftSneak", player, item, page);
                    break;
                }
            }
        } else if (title.equalsIgnoreCase(this.branding + UpgradeableTools.PLUGIN.getConfig().getString("InventoryTitles.SettingsInventory"))) {
            e.setCancelled(true);
            ItemStack tool = e.getView().getItem(4);
            if (currentItemName.equalsIgnoreCase(String.valueOf(ChatColor.YELLOW) + "Name")) {
                this.giveBack.put(player, false);
                this.playerChatEvent.setPlayerActions(player, new ChatStorage(ChatActions.HANDLE_NAME, tool));
                player.closeInventory();
                player.sendMessage(UpgradeableTools.BRANDING_PREFIX + String.valueOf(ChatColor.GOLD) + "Please insert the name of the item:");
                this.giveBack.put(player, true);
            } else if (currentItemName.equalsIgnoreCase(String.valueOf(ChatColor.YELLOW) + "Lore")) {
                this.giveBack.put(player, false);
                this.playerChatEvent.setPlayerActions(player, new ChatStorage(ChatActions.HANDLE_LORE, tool));
                player.closeInventory();
                player.sendMessage(UpgradeableTools.BRANDING_PREFIX + String.valueOf(ChatColor.GOLD) + "Type in the lore as you want it, when done type in 'done'");
                this.giveBack.put(player, true);
            }
        }
    }

    private void handleGrindstone(ItemStack item) {
    }

    private void handleUpgradePage(Player player, ItemStack item, int i) {
        this.openUpgradeGUI(player, item, i);
    }

    @EventHandler
    public void InventoryCloseEvent(InventoryCloseEvent e) {
        String title = e.getView().getTitle();
        HumanEntity humanEntity = e.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        ItemStack item = new ItemStack(Material.AIR);
        if (this.giveBack.get(p) != null && !this.giveBack.get(p).booleanValue()) {
            return;
        }
        Inventory eventInventory = e.getInventory();
        if (title.contains(this.branding + ChatColor.translateAlternateColorCodes((char)'&', (String)UpgradeableTools.PLUGIN.getConfig().getString("InventoryTitles.UpgradeInventory")))) {
            if (eventInventory.getItem(22) == null) {
                return;
            }
            item = e.getInventory().getItem(22);
            p.sendMessage(String.valueOf(ChatColor.GREEN) + "Enchantments successfully applied.");
        } else if (title.equalsIgnoreCase(this.branding + ChatColor.translateAlternateColorCodes((char)'&', (String)UpgradeableTools.PLUGIN.getConfig().getString("InventoryTitles.SelectionInventory")))) {
            if (eventInventory.getItem(13) == null) {
                return;
            }
            item = eventInventory.getItem(13);
        } else if (title.equalsIgnoreCase(this.branding + ChatColor.translateAlternateColorCodes((char)'&', (String)UpgradeableTools.PLUGIN.getConfig().getString("InventoryTitles.SettingsInventory")))) {
            if (eventInventory.getItem(4) == null) {
                return;
            }
            item = eventInventory.getItem(4);
        }
        if (item.getType().equals((Object)Material.AIR)) {
            return;
        }
        if (p.getInventory().firstEmpty() == -1) {
            p.getLocation().getWorld().dropItemNaturally(p.getLocation(), item);
        } else {
            p.getInventory().addItem(new ItemStack[]{item});
        }
    }

    public void onEnable() {
        UpgradeableTools.PLUGIN.getServer().getPluginManager().registerEvents((Listener)this.playerChatEvent, (Plugin)UpgradeableTools.PLUGIN);
        this.handlePlayerHeads();
    }

    public void onDisable() {
        this.playerChatEvent.onDisable();
    }

    private void handlePlayerHeads() {
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(String.valueOf(ChatColor.GRAY) + "This will take you to the");
        lores.add(String.valueOf(ChatColor.GRAY) + "settings page. There you");
        lores.add(String.valueOf(ChatColor.GRAY) + "can modify the tool name, etc.");
        this.settings = CheckerUtil.getHead("db4898c14428dd2e4011d9be3760ec6bab521ae5651f6e20ad5341a0f5afce28", String.valueOf(ChatColor.BLUE) + "Settings", lores);
        lores.clear();
        lores.add(String.valueOf(ChatColor.GRAY) + "This will take you to the next page.");
        this.next = CheckerUtil.getHead("18660691d1ca029f120a3ff0eabab93a2306b37a7d61119fcd141ff2f6fcd798", String.valueOf(ChatColor.BLUE) + "Next Page", lores);
        lores.clear();
        lores.add(String.valueOf(ChatColor.GRAY) + "This will take you to the last page");
        this.back = CheckerUtil.getHead("52ba81b47d5ee06b484ea9bdf22934e6abca5e4ced7be3905d6ae6ecd6fcea2a", String.valueOf(ChatColor.BLUE) + "Back", lores);
        lores.clear();
        lores.add(String.valueOf(ChatColor.GRAY) + "Customize the lore of this item.");
        lores.add(String.valueOf(ChatColor.GRAY) + "The lore is this descriptive text.");
        this.loreBook = CheckerUtil.getHead("cdcdee6d06df234b8e603328b96c57f3a312e79aabfc3be72a8b421878ed68cf", String.valueOf(ChatColor.YELLOW) + "Lore", lores);
        lores.clear();
        this.backpack = CheckerUtil.getHead("a45c7bbcee900802da6b3f8ee538aecf5633beea8301d13f247bd63f75907a58", String.valueOf(ChatColor.BLUE) + "Backpack", lores);
        this.spook = CheckerUtil.getHead("cea1b8dd35f356cb66c682eea791df88447281c6d006b82cf853d6945ff6add7", String.valueOf(ChatColor.BLUE) + "Spook", lores);
        this.bleed = CheckerUtil.getHead("93a3960c879474017c0ca3c80f6ee73cf886e00e89c902a3ee893dd2849535c0", String.valueOf(ChatColor.BLUE) + "Bleed", lores);
        this.secondChance = CheckerUtil.getHead("77791ccec16fb68f3c92e0b0264f9680e124c3859d66403524ba5b9576c9818", "Glow", lores);
        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "Player heads loaded");
    }

    private void openUpgradeGUI(Player p, ItemStack tool, int page) {
        Inventory inv = Bukkit.createInventory(null, (int)45, (String)(this.branding + ChatColor.translateAlternateColorCodes((char)'&', (String)UpgradeableTools.PLUGIN.getConfig().getString("InventoryTitles.UpgradeInventory")) + " p. " + page));
        ItemStack filler = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(String.valueOf(ChatColor.BLUE) + "Upgrade points: " + String.valueOf(ChatColor.GOLD) + String.format("%.2f", this.pointsUtil.checkForPoints(tool, p)));
        filler.setItemMeta(fillerMeta);
        if (CheckerUtil.checkForPickaxe(tool)) {
            this.inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.backpack, "Pickaxe", "Backpack", 1, 7, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.autoEquip, tool, Material.BEACON, "Pickaxe", "Auto Equip", 1, 1, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.drain, tool, Material.SPONGE, "Pickaxe", "Drain", 1, 13, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.blastMining, tool, Material.TNT, "Pickaxe", "Blast Mining", 1, 34, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.magnetic, tool, Material.HOPPER, "Pickaxe", "Magnetic", 1, 21, true);
            this.inventoryUtil.addEnchantment(Enchantment.EFFICIENCY, tool, Material.REDSTONE, "Pickaxe", "Efficiency", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.SILK_TOUCH, tool, Material.FEATHER, "Pickaxe", "Silk Touch", 1, 16, false);
            this.inventoryUtil.addEnchantment(Enchantment.FORTUNE, tool, Material.EMERALD, "Pickaxe", "Fortune", 1, 19, false);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Pickaxe", "Unbreaking", 1, 25, false);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Pickaxe", "Mending", 1, 28, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.smelter, tool, Material.FURNACE, "Pickaxe", "Smelter", 1, 23, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.mendWalker, tool, Material.ELYTRA, "Pickaxe", "Mend-Walker", 1, 31, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Pickaxe", "Soul Bound", 1, 4, true);
        } else if (CheckerUtil.checkForShovel(tool)) {
            this.inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.backpack, "Shovel", "Backpack", 1, 1, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.autoEquip, tool, Material.BEACON, "Shovel", "Auto Equip", 1, 23, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.blastExcavating, tool, Material.TNT, "Shovel", "Blast Excavating", 1, 34, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.luck, tool, Material.RABBIT_FOOT, "Shovel", "Luck", 1, 31, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.magnetic, tool, Material.HOPPER, "Shovel", "Magnetic", 1, 21, true);
            this.inventoryUtil.addEnchantment(Enchantment.EFFICIENCY, tool, Material.REDSTONE, "Shovel", "Efficiency", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.SILK_TOUCH, tool, Material.FEATHER, "Shovel", "Silk Touch", 1, 16, false);
            this.inventoryUtil.addEnchantment(Enchantment.FORTUNE, tool, Material.EMERALD, "Shovel", "Fortune", 1, 19, false);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Shovel", "Unbreaking", 1, 25, false);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Shovel", "Mending", 1, 28, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.mendWalker, tool, Material.ELYTRA, "Shovel", "Mend-Walker", 1, 31, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Shovel", "Soul Bound", 1, 13, true);
        } else if (CheckerUtil.checkForAxe(tool)) {
            this.inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.backpack, "Axe", "Backpack", 1, 1, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.autoEquip, tool, Material.BEACON, "Axe", "Auto Equip", 1, 23, true);
            this.inventoryUtil.addEnchantment(Enchantment.EFFICIENCY, tool, Material.REDSTONE, "Axe", "Efficiency", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.SILK_TOUCH, tool, Material.FEATHER, "Axe", "Silk Touch", 1, 16, false);
            this.inventoryUtil.addEnchantment(Enchantment.FORTUNE, tool, Material.EMERALD, "Axe", "Fortune", 1, 19, false);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Axe", "Unbreaking", 1, 25, false);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Axe", "Mending", 1, 28, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.mendWalker, tool, Material.ELYTRA, "Axe", "Mend-Walker", 1, 31, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Axe", "Soul Bound", 1, 13, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.fell, tool, Material.STONECUTTER, "Axe", "Soul Bound", 1, 31, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.magnetic, tool, Material.HOPPER, "Axe", "Magnetic", 1, 21, true);
        } else if (tool.getType().equals((Object)Material.FISHING_ROD)) {
            this.inventoryUtil.addEnchantment(Enchantment.LUCK_OF_THE_SEA, tool, Material.RABBIT_FOOT, "FishingRod", "Luck Of The Sea", 1, 16, false);
            this.inventoryUtil.addEnchantment(Enchantment.LURE, tool, Material.COD_BUCKET, "FishingRod", "Lure", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "FishingRod", "Mending", 1, 28, false);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "FishingRod", "Unbreaking", 1, 34, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.mendWalker, tool, Material.ELYTRA, "FishingRod", "Mend-Walker", 1, 31, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "FishingRod", "Soul Bound", 1, 13, true);
        } else if (CheckerUtil.checkForSwords(tool)) {
            this.inventoryUtil.addEnchantment(CustomEnchants.confusion, tool, Material.SCULK_SENSOR, "Swords", "Confusion", 2, 13, true);
            this.inventoryUtil.addCustomStack(CustomEnchants.spook, tool, this.spook, "Swords", "Spook", 2, 7, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.freeze, tool, Material.SNOWBALL, "Swords", "Freeze", 2, 4, true);
            this.inventoryUtil.addCustomStack(CustomEnchants.bleed, tool, this.bleed, "Swords", "Bleed", 2, 1, true);
            this.inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.backpack, "Swords", "Backpack", 1, 20, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.mendWalker, tool, Material.ELYTRA, "Swords", "Mend-Walker", 1, 21, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Swords", "Soul Bound", 1, 4, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.lifeSteal, tool, Material.TOTEM_OF_UNDYING, "Swords", "Life Steal", 1, 13, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.shockwave, tool, Material.REDSTONE, "Swords", "Shockwave", 1, 31, true);
            this.inventoryUtil.addEnchantment(Enchantment.SHARPNESS, tool, Material.CACTUS, "Swords", "Sharpness", 1, 1, false);
            this.inventoryUtil.addEnchantment(Enchantment.FIRE_ASPECT, tool, Material.FIRE_CHARGE, "Swords", "Fire Aspect", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.LOOTING, tool, Material.BUCKET, "Swords", "Looting", 1, 19, false);
            this.inventoryUtil.addEnchantment(Enchantment.SWEEPING_EDGE, tool, Material.IRON_HOE, "Swords", "Sweeping Edge", 1, 34, false);
            this.inventoryUtil.addEnchantment(Enchantment.SMITE, tool, Material.BONE, "Swords", "Smite", 1, 23, false);
            this.inventoryUtil.addEnchantment(Enchantment.BANE_OF_ARTHROPODS, tool, Material.SPIDER_EYE, "Swords", "Bane Of Arthropods", 1, 7, false);
            this.inventoryUtil.addEnchantment(Enchantment.KNOCKBACK, tool, Material.DISPENSER, "Swords", "Knockback", 1, 16, false);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Swords", "Unbreaking", 1, 25, false);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Swords", "Mending", 1, 28, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.decapitation, tool, Material.SKELETON_SKULL, "Swords", "Decapitation", 1, 24, true);
        } else if (CheckerUtil.checkForHoe(tool)) {
            this.inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.backpack, "Hoe", "Backpack", 1, 1, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Hoe", "Soul Bound", 1, 13, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.massPlanter, tool, Material.DISPENSER, "Hoe", "Mass Planter", 1, 19, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.massHarvester, tool, Material.WHEAT, "Hoe", "Mass Harvester", 1, 25, true);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Hoe", "Unbreaking", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Hoe", "Mending", 1, 16, false);
        } else if (tool.getType().equals((Object)Material.BOW)) {
            this.inventoryUtil.addEnchantment(CustomEnchants.poisonShot, tool, Material.SPLASH_POTION, "Bow", "Poison Shot", 1, 7, true);
            this.inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.backpack, "Bow", "Backpack", 1, 1, true);
            this.inventoryUtil.addEnchantment(Enchantment.FLAME, tool, Material.FIRE_CHARGE, "Bow", "Flame", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.INFINITY, tool, Material.ARROW, "Bow", "Infinity", 1, 19, false);
            this.inventoryUtil.addEnchantment(Enchantment.PUNCH, tool, Material.PISTON, "Bow", "Punch", 1, 16, false);
            this.inventoryUtil.addEnchantment(Enchantment.POWER, tool, Material.ANVIL, "Bow", "Power", 1, 34, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.explosive, tool, Material.TNT, "Bow", "Explosive", 1, 31, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Bow", "Soul Bound", 1, 13, true);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Bow", "Unbreaking", 1, 25, false);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Bow", "Mending", 1, 28, false);
        } else if (CheckerUtil.checkForBoots(tool)) {
            this.inventoryUtil.addEnchantment(Enchantment.SOUL_SPEED, tool, Material.SOUL_CAMPFIRE, "Armor", "Soul Speed", 2, 4, false);
            this.inventoryUtil.addEnchantment(Enchantment.PROJECTILE_PROTECTION, tool, Material.ARROW, "Armor", "Projectile Protection", 1, 1, false);
            this.inventoryUtil.addEnchantment(Enchantment.FIRE_PROTECTION, tool, Material.BLAZE_POWDER, "Armor", "Fire Protection", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.BLAST_PROTECTION, tool, Material.TNT, "Armor", "Blast Protection", 1, 19, false);
            this.inventoryUtil.addEnchantment(Enchantment.DEPTH_STRIDER, tool, Material.ACACIA_BOAT, "Armor", "Depth Strider", 1, 16, false);
            this.inventoryUtil.addEnchantment(Enchantment.FEATHER_FALLING, tool, Material.FEATHER, "Armor", "Feather Falling", 1, 34, false);
            this.inventoryUtil.addEnchantment(Enchantment.FROST_WALKER, tool, Material.ICE, "Armor", "Frost Walker", 1, 13, false);
            this.inventoryUtil.addEnchantment(Enchantment.PROTECTION, tool, Material.SHIELD, "Armor", "Protection", 1, 31, false);
            this.inventoryUtil.addEnchantment(Enchantment.THORNS, tool, Material.CACTUS, "Armor", "Thorns", 1, 23, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Armor", "Soul Bound", 1, 21, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.poisonTouch, tool, Material.SPLASH_POTION, "Armor", "Poison Touch", 1, 7, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.explosiveTouch, tool, Material.TNT_MINECART, "Armor", "Explosive Touch", 2, 1, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.speed, tool, Material.MINECART, "Armor", "Speed", 1, 4, true);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Armor", "Unbreaking", 1, 25, false);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Armor", "Mending", 1, 28, false);
        } else if (CheckerUtil.checkForHelmet(tool)) {
            this.inventoryUtil.addEnchantment(Enchantment.PROJECTILE_PROTECTION, tool, Material.ARROW, "Armor", "Projectile Protection", 1, 1, false);
            this.inventoryUtil.addEnchantment(Enchantment.FIRE_PROTECTION, tool, Material.BLAZE_POWDER, "Armor", "Fire Protection", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.BLAST_PROTECTION, tool, Material.TNT, "Armor", "Blast Protection", 1, 19, false);
            this.inventoryUtil.addEnchantment(Enchantment.AQUA_AFFINITY, tool, Material.DIAMOND_PICKAXE, "Armor", "Aqua Affinity", 1, 16, false);
            this.inventoryUtil.addEnchantment(Enchantment.PROTECTION, tool, Material.SHIELD, "Armor", "Protection", 1, 31, false);
            this.inventoryUtil.addEnchantment(Enchantment.THORNS, tool, Material.CACTUS, "Armor", "Thorns", 1, 23, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Armor", "Soul Bound", 1, 13, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.poisonTouch, tool, Material.SPLASH_POTION, "Armor", "Poison Touch", 1, 7, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.explosiveTouch, tool, Material.TNT_MINECART, "Armor", "Explosive Touch", 1, 4, true);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Armor", "Unbreaking", 1, 25, false);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Armor", "Mending", 1, 28, false);
            this.inventoryUtil.addEnchantment(Enchantment.RESPIRATION, tool, Material.TURTLE_SCUTE, "Armor", "Respiration", 1, 34, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.nightVision, tool, Material.ENDER_EYE, "Armor", "Night Vision", 2, 1, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.blink, tool, Material.ENDER_PEARL, "Armor", "Blink", 1, 21, true);
        } else if (CheckerUtil.checkForLeggins(tool)) {
            this.inventoryUtil.addEnchantment(Enchantment.SWIFT_SNEAK, tool, Material.GOLDEN_APPLE, "Armor", "Swift Sneak", 1, 16, false);
            this.inventoryUtil.addEnchantment(Enchantment.PROJECTILE_PROTECTION, tool, Material.ARROW, "Armor", "Projectile Protection", 1, 1, false);
            this.inventoryUtil.addEnchantment(Enchantment.FIRE_PROTECTION, tool, Material.BLAZE_POWDER, "Armor", "Fire Protection", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.BLAST_PROTECTION, tool, Material.TNT, "Armor", "Blast Protection", 1, 19, false);
            this.inventoryUtil.addEnchantment(Enchantment.PROTECTION, tool, Material.SHIELD, "Armor", "Protection", 1, 31, false);
            this.inventoryUtil.addEnchantment(Enchantment.THORNS, tool, Material.CACTUS, "Armor", "Thorns", 1, 23, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Armor", "Soul Bound", 1, 13, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.poisonTouch, tool, Material.SPLASH_POTION, "Armor", "Poison Touch", 1, 4, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.explosiveTouch, tool, Material.TNT_MINECART, "Armor", "Explosive Touch", 1, 21, true);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Armor", "Unbreaking", 1, 25, false);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Armor", "Mending", 1, 28, false);
        } else if (CheckerUtil.checkForChestplate(tool)) {
            this.inventoryUtil.addEnchantment(Enchantment.PROJECTILE_PROTECTION, tool, Material.ARROW, "Armor", "Projectile Protection", 1, 1, false);
            this.inventoryUtil.addCustomStack(CustomEnchants.secondChance, tool, this.secondChance, "Armor", "Second Chance", 1, 4, true);
            this.inventoryUtil.addEnchantment(Enchantment.FIRE_PROTECTION, tool, Material.BLAZE_POWDER, "Armor", "Fire Protection", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.BLAST_PROTECTION, tool, Material.TNT, "Armor", "Blast Protection", 1, 19, false);
            this.inventoryUtil.addEnchantment(Enchantment.PROTECTION, tool, Material.SHIELD, "Armor", "Protection", 1, 31, false);
            this.inventoryUtil.addEnchantment(Enchantment.THORNS, tool, Material.CACTUS, "Armor", "Thorns", 1, 23, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Armor", "Soul Bound", 1, 13, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.poisonTouch, tool, Material.SPLASH_POTION, "Armor", "Poison Touch", 1, 16, true);
            this.inventoryUtil.addEnchantment(CustomEnchants.explosiveTouch, tool, Material.TNT_MINECART, "Armor", "Explosive Touch", 1, 21, true);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Armor", "Unbreaking", 1, 25, false);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Armor", "Mending", 1, 28, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.dupe, tool, Material.OAK_LOG, "Armor", "Dupe", 1, 34, true);
        } else if (tool.getType().equals((Object)Material.TRIDENT)) {
            this.inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.backpack, "Trident", "Backpack", 1, 1, true);
            this.inventoryUtil.addEnchantment(Enchantment.CHANNELING, tool, Material.END_CRYSTAL, "Trident", "Channeling", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.IMPALING, tool, Material.ARROW, "Trident", "Impaling", 1, 19, false);
            this.inventoryUtil.addEnchantment(Enchantment.LOYALTY, tool, Material.WOLF_SPAWN_EGG, "Trident", "Loyalty", 1, 16, false);
            this.inventoryUtil.addEnchantment(Enchantment.RIPTIDE, tool, Material.ENDER_PEARL, "Trident", "Riptide", 1, 34, false);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Trident", "Unbreaking", 1, 25, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Trident", "Soul Bound", 1, 13, true);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Trident", "Mending", 1, 28, false);
        } else if (tool.getType().equals((Object)Material.CROSSBOW)) {
            this.inventoryUtil.addEnchantment(CustomEnchants.poisonShot, tool, Material.SPLASH_POTION, "Crossbow", "Poison Shot", 1, 7, true);
            this.inventoryUtil.addCustomStack(CustomEnchants.backpack, tool, this.backpack, "Crossbow", "Backpack", 1, 1, true);
            this.inventoryUtil.addEnchantment(Enchantment.MULTISHOT, tool, Material.ARROW, "Crossbow", "Multishot", 1, 10, false);
            this.inventoryUtil.addEnchantment(Enchantment.PIERCING, tool, Material.CHAINMAIL_CHESTPLATE, "Crossbow", "Piercing", 1, 19, false);
            this.inventoryUtil.addEnchantment(Enchantment.QUICK_CHARGE, tool, Material.RAIL, "Crossbow", "Quick Charge", 1, 16, false);
            this.inventoryUtil.addEnchantment(CustomEnchants.soulBound, tool, Material.SOUL_LANTERN, "Crossbow", "Soul Bound", 1, 13, true);
            this.inventoryUtil.addEnchantment(Enchantment.UNBREAKING, tool, Material.BEDROCK, "Crossbow", "Unbreaking", 1, 25, false);
            this.inventoryUtil.addEnchantment(Enchantment.MENDING, tool, Material.EXPERIENCE_BOTTLE, "Crossbow", "Mending", 1, 28, false);
        } else {
            p.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "UpgradableTools:" + String.valueOf(ChatColor.RED) + "You cannot upgrade " + tool.getItemMeta().getDisplayName());
            return;
        }
        if (this.inventoryUtil.getContents(page).isEmpty()) {
            return;
        }
        this.giveBack.put(p, false);
        p.closeInventory();
        this.giveBack.put(p, true);
        for (InvGUIStorage invGUIStorage : this.inventoryUtil.getContents(page)) {
            inv.setItem(invGUIStorage.getIndex(), invGUIStorage.getStack());
        }
        this.inventoryUtil.reset();
        if (page > 1) {
            inv.setItem(38, this.back);
        }
        inv.setItem(42, this.next);
        inv.setItem(40, this.settings);
        inv.setItem(22, tool);
        ItemStack[] contents = inv.getContents();
        for (int x = 0; x < 45; ++x) {
            try {
                if (!contents[x].getType().equals((Object)Material.AIR)) continue;
                inv.setItem(x, filler);
                continue;
            }
            catch (NullPointerException e) {
                inv.setItem(x, filler);
            }
        }
        p.openInventory(inv);
    }

    private void processInventoryClickEvent(Enchantment enchantment, ItemStack tool, int level, Player player, String enchName, int page) {
        this.giveBack.put(player, false);
        if (tool.containsEnchantment(enchantment)) {
            tool.removeEnchantment(enchantment);
        }
        tool.addEnchantment(enchantment, ++level);
        this.giveBack.put(player, false);
        this.openUpgradeGUI(player, tool, page);
        this.giveBack.put(player, true);
    }

    public void addToInventoryClickEvent(AbstractCustomEnchantment abstractEnchant, String path, Player player, ItemStack tool, int page) {
        Enchantment enchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + abstractEnchant.getKey())));
        this.addToInventoryClickEvent(enchantment, path, player, tool, page);
    }

    public void addToInventoryClickEvent(Enchantment enchantment, String path, Player player, ItemStack tool, int page) {
        int level = 0;
        if (!tool.hasItemMeta()) {
            level = 0;
        }
        if (tool.getItemMeta().getEnchants().isEmpty()) {
            level = 0;
        }
        if (tool.getItemMeta().getEnchants().containsKey(enchantment)) {
            level = (Integer)tool.getItemMeta().getEnchants().get(enchantment);
        }
        if (CheckerUtil.checkForPickaxe(tool)) {
            this.handleAll(player, tool, level, "Pickaxe." + path, enchantment, JobEvents.pickaxePoints, page);
        } else if (CheckerUtil.checkForShovel(tool)) {
            this.handleAll(player, tool, level, "Shovel." + path, enchantment, JobEvents.shovelPoints, page);
        } else if (CheckerUtil.checkForAxe(tool)) {
            this.handleAll(player, tool, level, "Axe." + path, enchantment, JobEvents.axePoints, page);
        } else if (tool.getType().equals((Object)Material.FISHING_ROD)) {
            this.handleAll(player, tool, level, "FishingRod." + path, enchantment, JobEvents.fishingPoints, page);
        } else if (CheckerUtil.checkForHoe(tool)) {
            this.handleAll(player, tool, level, "Hoe." + path, enchantment, JobEvents.hoePoints, page);
        } else if (CheckerUtil.checkForWeapons(tool)) {
            String truePath = "Swords." + path;
            if (tool.getType().equals((Object)Material.BOW)) {
                truePath = "Bow." + path;
            } else if (tool.getType().equals((Object)Material.TRIDENT)) {
                truePath = "Trident." + path;
            } else if (tool.getType().equals((Object)Material.CROSSBOW)) {
                truePath = "Crossbow." + path;
            }
            this.handleAll(player, tool, level, truePath, enchantment, JobEvents.weaponPoints, page);
        } else if (CheckerUtil.checkForArmor(tool)) {
            this.handleAll(player, tool, level, "Armor." + path, enchantment, JobEvents.armorPoints, page);
        }
    }

    private void handleAll(Player player, ItemStack tool, int level, String path, Enchantment enchantment, HashMap<String, Double> points, int page) {
        String name = UpgradeableTools.PLUGIN.getConfig().getString("MultiplierToLevel." + path + ".name", WordUtils.capitalizeFully(enchantment.getKey().getKey().replaceAll("_", " ")));
        if (level <= 0) {
            try {
                level = tool.getEnchantmentLevel(enchantment);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
                level = tool.getItemMeta().getEnchantLevel(enchantment);
            }
        }
        if (level <= 0) {
            level = 0;
        }
        if (!CheckerUtil.checkEnchantmentPermission(player, enchantment, level)) {
            return;
        }
        this.handlePoints(player, tool, level, path, enchantment, points, page, name);
    }

    private void handlePoints(Player player, ItemStack tool, int level, String path, Enchantment enchantment, HashMap<String, Double> points, int page, String enchName) {
        int maxLevel = UpgradeableTools.PLUGIN.getConfig().getInt("MultiplierToLevel." + path + ".MaximumLevel");
        double start = UpgradeableTools.PLUGIN.getConfig().getDouble("MultiplierToLevel." + path + ".Start");
        double multiplier = UpgradeableTools.PLUGIN.getConfig().getDouble("MultiplierToLevel." + path + ".Multiplier");
        if (level >= maxLevel) {
            return;
        }
        if (this.pointHandler(player, points, tool, start, level, multiplier, maxLevel)) {
            this.processInventoryClickEvent(enchantment, tool, level, player, enchName, page);
        }
    }

    private boolean pointHandler(Player player, HashMap<String, Double> pointList, ItemStack toolType, double start, int level, double multiplier, double maxLevel) {
        String p = player.getName();
        String tool = CheckerUtil.getItemType(toolType);
        double cost = start;
        if ((double)level < maxLevel) {
            if (level > 0) {
                cost = (double)level * multiplier * start;
            }
        } else {
            player.sendMessage(UpgradeableTools.BRANDING_PREFIX + String.valueOf(ChatColor.RED) + "You cannot upgrade a tool that is already at it's maximum level.");
        }
        if (this.pointsUtil.withdrawPointsFor(toolType, player, cost)) {
            return true;
        }
        if (pointList.containsKey(p)) {
            if (pointList.get(p) > cost) {
                double oldValue = pointList.get(p);
                pointList.replace(p, oldValue, oldValue - cost);
                return true;
            }
            player.sendMessage(UpgradeableTools.BRANDING_PREFIX + "UpgradableTools:" + String.valueOf(ChatColor.RED) + " You do not have enough weapon points to upgrade your " + tool + "!");
            return false;
        }
        return false;
    }

    private void openSettingsGUI(Player p, ItemStack tool) {
        if (!this.settingsGUICheck(p)) {
            return;
        }
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)(this.branding + ChatColor.translateAlternateColorCodes((char)'&', (String)UpgradeableTools.PLUGIN.getConfig().getString("InventoryTitles.SettingsInventory", "Settings"))));
        ItemStack filler = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(String.valueOf(ChatColor.BLUE) + "Upgrade points: " + String.valueOf(ChatColor.GOLD) + String.format("%.2f", this.pointsUtil.checkForPoints(tool, p)));
        filler.setItemMeta(fillerMeta);
        ItemStack name = new ItemStack(Material.NAME_TAG);
        ItemMeta nameMeta = name.getItemMeta();
        nameMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Name");
        ArrayList<CallSite> lores = new ArrayList<CallSite>();
        lores.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Customize the name of the item")));
        nameMeta.setLore(lores);
        name.setItemMeta(nameMeta);
        inv.setItem(1, name);
        inv.setItem(7, this.loreBook);
        inv.setItem(4, tool);
        for (int i = 0; i < 9; ++i) {
            if (inv.getItem(i) == null) {
                inv.setItem(i, filler);
                continue;
            }
            if (inv.getItem(i).getType() != Material.AIR) continue;
            inv.setItem(i, filler);
        }
        p.openInventory(inv);
    }

    private boolean settingsGUICheck(Player p) {
        if (!UpgradeableTools.PLUGIN.getConfig().getBoolean("ToolSettingsPermission", false)) {
            return true;
        }
        return p.hasPermission("UpgradeableTools.settings");
    }

    @EventHandler
    public void blockPlaceEvent(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null) {
            return;
        }
        if (!itemInHand.hasItemMeta()) {
            return;
        }
        ItemMeta itemMeta = itemInHand.getItemMeta();
        if (!itemMeta.getDisplayName().contains("Enchanting Maximizer")) {
            return;
        }
        CheckerUtil.setUpgradeData(event.getBlock());
    }

    @EventHandler
    public void blockBreakEvent(BlockBreakEvent event) {
        if (!CheckerUtil.checkForUpgradeStructure(event.getBlock())) {
            return;
        }
        if (!UpgradeableTools.PLUGIN.getConfig().getBoolean("CanPickupEnchantmentMaximizer", false)) {
            return;
        }
        ItemStack result = new ItemStack(Material.ENCHANTING_TABLE);
        ItemMeta resultMeta = result.getItemMeta();
        resultMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Enchanting Maximizer");
        ArrayList<CallSite> lores = new ArrayList<CallSite>();
        lores.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Place this block to begin")));
        lores.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "your enchanting journey!")));
        resultMeta.setLore(lores);
        result.setItemMeta(resultMeta);
        event.getPlayer().getWorld().dropItemNaturally(event.getBlock().getLocation(), result);
        event.setCancelled(true);
        event.getBlock().setType(Material.AIR);
        event.getBlock().getState().update();
    }

    @EventHandler
    public void playerInteractEvent(PlayerInteractEvent event) {
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        if (!event.getClickedBlock().getType().equals((Object)Material.ENCHANTING_TABLE)) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (this.valueUtil.getToolType(itemInHand.getType()) == Tools.NONE) {
            return;
        }
        if (CheckerUtil.checkForUpgradeStructure(event.getClickedBlock())) {
            event.setCancelled(true);
            this.openUpgradeGUI(player, itemInHand, 1);
            player.getInventory().remove(itemInHand);
        }
    }
}

