/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments.Enchantments.Weapons;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import io.papermc.paper.registry.keys.tags.ItemTypeTagKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.tag.TagKey;
import java.util.HashMap;
import java.util.UUID;
import me.marcangeloh.API.Events.PlayerDamageEntityEvent;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.UpgradeableTools;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Freeze
extends AbstractCustomEnchantment {
    HashMap<UUID, Integer> cdtime = new HashMap();
    HashMap<LivingEntity, Integer> freezeMap = new HashMap();

    @EventHandler(priority=EventPriority.HIGH)
    public void freezeEvent(PlayerDamageEntityEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        Entity entity = event.getEntity();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (itemStack.getItemMeta().getEnchants().isEmpty()) {
            return;
        }
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.getKey())));
        if (!itemStack.containsEnchantment(yourEnchantment)) {
            return;
        }
        int level = itemStack.getEnchantmentLevel(yourEnchantment);
        if (level <= 0) {
            return;
        }
        if (this.cdtime.containsKey(player.getUniqueId())) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity.isDead()) {
            return;
        }
        livingEntity.setAI(false);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have instilled " + String.valueOf(ChatColor.BLUE) + "Freeze" + String.valueOf(ChatColor.GREEN) + " on your opponent.");
        this.cdtime.put(player.getUniqueId(), 1800 / (level == 0 ? 1 : level));
        this.freezeMap.put(livingEntity, 5);
    }

    @EventHandler
    public void playerMovedEvent(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (this.freezeMap.containsKey(player)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You have been " + String.valueOf(ChatColor.BLUE) + "FROZEN!");
            event.setCancelled(true);
        }
    }

    public void freezablerunner() {
        new BukkitRunnable(){

            public void run() {
                if (Freeze.this.freezeMap.isEmpty()) {
                    return;
                }
                for (LivingEntity entity : Freeze.this.freezeMap.keySet()) {
                    int timeleft = Freeze.this.freezeMap.get(entity);
                    Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)148, (int)255, (int)255), 5.0f);
                    entity.getWorld().spawnParticle(Particle.DUST, entity.getLocation(), 50, (Object)dustOptions);
                    if (entity.isDead() && timeleft > 60) {
                        timeleft = 60;
                    }
                    if (timeleft <= 0) {
                        entity.setAI(true);
                        Freeze.this.freezeMap.remove(entity);
                        continue;
                    }
                    Freeze.this.freezeMap.put(entity, timeleft - 1);
                }
            }
        }.runTaskTimer((Plugin)UpgradeableTools.PLUGIN, 0L, 20L);
    }

    public void runnablerunner() {
        new BukkitRunnable(){

            public void run() {
                if (Freeze.this.cdtime.isEmpty()) {
                    return;
                }
                for (UUID uuid : Freeze.this.cdtime.keySet()) {
                    int timeleft = Freeze.this.cdtime.get(uuid);
                    if (timeleft <= 0) {
                        Freeze.this.cdtime.remove(uuid);
                        continue;
                    }
                    Freeze.this.cdtime.put(uuid, timeleft - 1);
                }
            }
        }.runTaskTimer((Plugin)UpgradeableTools.PLUGIN, 0L, 20L);
    }

    public Freeze(String path, String name, BootstrapContext context) {
        super(name, path, context);
        if (!this.isEnchantEnabled()) {
            return;
        }
        context.getLifecycleManager().registerEventHandler(RegistryEvents.ENCHANTMENT.freeze().newHandler(event -> event.registry().register(EnchantmentKeys.create((Key)Key.key((String)("utools:" + this.getKey()))), b -> b.description((Component)Component.text((String)name.replace("_", " "))).supportedItems((RegistryKeySet)event.getOrCreateTag(this.getItemTarget())).maxLevel(this.getMaxLevel()).anvilCost(0).weight(1).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).activeSlots(new EquipmentSlotGroup[]{this.getEquipmentSlotGroup()}))));
    }

    @Override
    public void registerEvent(JavaPlugin plugin) {
        this.runnablerunner();
        this.freezablerunner();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public String getName() {
        return "Freeze";
    }

    @Override
    public EquipmentSlotGroup getEquipmentSlotGroup() {
        return EquipmentSlotGroup.MAINHAND;
    }

    @Override
    public TagKey<ItemType> getItemTarget() {
        return ItemTypeTagKeys.SWORDS;
    }
}

