/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments.Enchantments.Tools;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import io.papermc.paper.registry.keys.tags.ItemTypeTagKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.tag.TagKey;
import java.util.Collection;
import java.util.Random;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.Util.CheckerUtil;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;

public class Smelter
extends AbstractCustomEnchantment {
    @EventHandler(priority=EventPriority.HIGH)
    public void smelterEnchantmentEvent(BlockBreakEvent e) {
        int rand;
        Material blockType;
        Player p = e.getPlayer();
        ItemStack tool = p.getInventory().getItemInMainHand();
        if (tool == null) {
            return;
        }
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.getKey())));
        if (!tool.containsEnchantment(yourEnchantment)) {
            return;
        }
        boolean magnetic = false;
        Enchantment magneticEnchant = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)"utools:magnetic"));
        if (magneticEnchant == null) {
            magnetic = false;
        }
        if (tool.containsEnchantment(magneticEnchant)) {
            magnetic = true;
        }
        if (!this.isSmeltable(blockType = e.getBlock().getType())) {
            return;
        }
        ItemStack is = null;
        int level = p.getInventory().getItemInMainHand().getEnchantmentLevel(yourEnchantment);
        if (level > 10) {
            level = 10;
        }
        if (level < (rand = new Random().nextInt(10)) && level != 10) {
            return;
        }
        e.setCancelled(true);
        Location loc = e.getBlock().getLocation();
        if (CheckerUtil.isPlayerInRegion(e.getPlayer(), loc)) {
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Cannot use this enchantment in a protected region.");
            return;
        }
        Collection drops = e.getBlock().getDrops(p.getInventory().getItemInMainHand());
        for (ItemStack stack : drops) {
            if (!this.isSmeltable(stack.getType())) {
                p.getInventory().addItem(new ItemStack[]{stack});
                continue;
            }
            Object type = stack.getType().toString();
            if (!((String)type).contains("RAW_") || Material.getMaterial((String)(type = ((String)type).replace("RAW_", "") + "_INGOT")) == null) continue;
            is = new ItemStack(Material.getMaterial((String)type), stack.getAmount());
        }
        if (is == null) {
            return;
        }
        if (magnetic && p.getInventory().firstEmpty() != -1) {
            p.getInventory().addItem(new ItemStack[]{is});
            return;
        }
        p.getWorld().dropItemNaturally(loc, is);
        e.getBlock().setType(Material.AIR);
        e.getBlock().getState().update();
    }

    private boolean isSmeltable(Material blockType) {
        return blockType.equals((Object)Material.IRON_ORE) || blockType.equals((Object)Material.GOLD_ORE) || blockType.equals((Object)Material.COPPER_ORE) || blockType.equals((Object)Material.DEEPSLATE_GOLD_ORE) || blockType.equals((Object)Material.NETHER_GOLD_ORE) || blockType.equals((Object)Material.DEEPSLATE_IRON_ORE) || blockType.equals((Object)Material.DEEPSLATE_COPPER_ORE) || blockType.equals((Object)Material.RAW_GOLD) || blockType.equals((Object)Material.RAW_COPPER) || blockType.equals((Object)Material.RAW_IRON);
    }

    public Smelter(String path, String name, BootstrapContext context) {
        super(name, path, context);
        if (!this.isEnchantEnabled()) {
            return;
        }
        context.getLifecycleManager().registerEventHandler(RegistryEvents.ENCHANTMENT.freeze().newHandler(event -> event.registry().register(EnchantmentKeys.create((Key)Key.key((String)("utools:" + this.getKey()))), b -> b.description((Component)Component.text((String)name.replace("_", " "))).supportedItems((RegistryKeySet)event.getOrCreateTag(this.getItemTarget())).maxLevel(this.getMaxLevel()).anvilCost(0).weight(1).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).activeSlots(new EquipmentSlotGroup[]{this.getEquipmentSlotGroup()}))));
    }

    @Override
    public String getName() {
        return "Smelter";
    }

    @Override
    public EquipmentSlotGroup getEquipmentSlotGroup() {
        return EquipmentSlotGroup.MAINHAND;
    }

    @Override
    public TagKey<ItemType> getItemTarget() {
        return ItemTypeTagKeys.PICKAXES;
    }
}

