/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments.Enchantments.Tools;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import io.papermc.paper.registry.keys.tags.ItemTypeTagKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.tag.TagKey;
import me.marcangeloh.API.Util.ConfigurationUtil.ToolUtil;
import me.marcangeloh.API.Util.GeneralUtil.Tools;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.Util.CheckerUtil;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;

public class BlastMining
extends AbstractCustomEnchantment {
    @EventHandler(priority=EventPriority.HIGH)
    public void playerBlockBreakEvent(BlockBreakEvent e) {
        Player p = e.getPlayer();
        if (p.isSneaking()) {
            return;
        }
        ItemStack tool = p.getInventory().getItemInMainHand();
        if (tool.isEmpty()) {
            return;
        }
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.getKey())));
        if (!tool.containsEnchantment(yourEnchantment)) {
            return;
        }
        int level = tool.getEnchantmentLevel(yourEnchantment);
        int magneticLevel = -1;
        Enchantment magnetic = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)"utools:magnetic"));
        for (int z = e.getBlock().getZ() - level; z <= e.getBlock().getZ() + level; ++z) {
            for (int x = e.getBlock().getX() - level; x <= e.getBlock().getX() + level; ++x) {
                for (int y = e.getBlock().getY() - level; y <= e.getBlock().getY() + level; ++y) {
                    Location loc = new Location(p.getWorld(), (double)x, (double)y, (double)z);
                    if (CheckerUtil.isPlayerInRegion(p, loc)) {
                        p.sendMessage(String.valueOf(ChatColor.RED) + "You're trying to break a protected region.");
                        return;
                    }
                    if (!this.isPickaxeBreakeable(loc)) continue;
                    if (tool.containsEnchantment(magnetic)) {
                        for (ItemStack item : loc.getBlock().getDrops(p.getInventory().getItemInMainHand())) {
                            if (p.getInventory().firstEmpty() == -1) {
                                p.getWorld().dropItemNaturally(p.getLocation(), item);
                                continue;
                            }
                            p.getInventory().addItem(new ItemStack[]{item});
                        }
                        loc.getBlock().setType(Material.AIR);
                        continue;
                    }
                    loc.getBlock().breakNaturally(p.getInventory().getItemInMainHand());
                }
            }
        }
    }

    private boolean isPickaxeBreakeable(Location loc) {
        return ToolUtil.getToolTypeForMaterial((Material)loc.getBlock().getType()).equals((Object)Tools.PICKAXE);
    }

    public BlastMining(String path, String name, BootstrapContext context) {
        super(name, path, context);
        if (!this.isEnchantEnabled()) {
            return;
        }
        context.getLifecycleManager().registerEventHandler(RegistryEvents.ENCHANTMENT.freeze().newHandler(event -> event.registry().register(EnchantmentKeys.create((Key)Key.key((String)("utools:" + this.getKey()))), b -> b.description((Component)Component.text((String)name.replace("_", " "))).supportedItems((RegistryKeySet)event.getOrCreateTag(this.getItemTarget())).maxLevel(this.getMaxLevel()).anvilCost(0).weight(1).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).activeSlots(new EquipmentSlotGroup[]{this.getEquipmentSlotGroup()}))));
    }

    @Override
    public String getName() {
        return "Blast Mining";
    }

    @Override
    public EquipmentSlotGroup getEquipmentSlotGroup() {
        return EquipmentSlotGroup.MAINHAND;
    }

    @Override
    public TagKey<ItemType> getItemTarget() {
        return ItemTypeTagKeys.PICKAXES;
    }
}

