/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments.Enchantments.Tools;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.tag.TagKey;
import java.util.List;
import me.marcangeloh.API.Util.ConfigurationUtil.ToolUtil;
import me.marcangeloh.API.Util.GeneralUtil.Tools;
import me.marcangeloh.Bootstrap;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.Util.CheckerUtil;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;

public class AutoEquip
extends AbstractCustomEnchantment {
    @EventHandler(priority=EventPriority.HIGH)
    public void interactEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null) continue;
            Material clickedBlockType = event.getClickedBlock().getType();
            if (ToolUtil.getToolTypeForMaterial((Material)clickedBlockType).equals((Object)Tools.PICKAXE) && CheckerUtil.checkForPickaxe(item)) {
                this.handleEnchant(player, item);
                continue;
            }
            if (ToolUtil.getToolTypeForMaterial((Material)clickedBlockType).equals((Object)Tools.SHOVEL) && CheckerUtil.checkForShovel(item)) {
                this.handleEnchant(player, item);
                continue;
            }
            if (!ToolUtil.getToolTypeForMaterial((Material)clickedBlockType).equals((Object)Tools.AXE) || !CheckerUtil.checkForAxe(item)) continue;
            this.handleEnchant(player, item);
        }
    }

    private void handleEnchant(Player player, ItemStack item) {
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.getKey())));
        if (!item.containsEnchantment(yourEnchantment)) {
            return;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        if (mainHand.getType().equals((Object)item.getType())) {
            return;
        }
        player.getInventory().remove(item);
        player.getInventory().setItemInMainHand(item);
        player.getInventory().addItem(new ItemStack[]{mainHand});
    }

    public AutoEquip(List<String> path, String name, BootstrapContext context) {
        super(name, path, context);
        if (!this.isEnchantEnabled()) {
            return;
        }
        context.getLifecycleManager().registerEventHandler(RegistryEvents.ENCHANTMENT.freeze().newHandler(event -> event.registry().register(EnchantmentKeys.create((Key)Key.key((String)("utools:" + this.getKey()))), b -> b.description((Component)Component.text((String)name.replace("_", " "))).supportedItems((RegistryKeySet)event.getOrCreateTag(Bootstrap.Tools)).maxLevel(this.getMaxLevel()).anvilCost(0).weight(1).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).activeSlots(new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY}))));
    }

    @Override
    public String getName() {
        return "Auto Equip";
    }

    @Override
    public EquipmentSlotGroup getEquipmentSlotGroup() {
        return EquipmentSlotGroup.HAND;
    }

    @Override
    public TagKey<ItemType> getItemTarget() {
        return null;
    }
}

