/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments.Enchantments.Multi.Backpack;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.tag.TagKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import me.marcangeloh.API.Util.ConfigurationUtil.ToolUtil;
import me.marcangeloh.API.Util.ConfigurationUtil.ValueUtil;
import me.marcangeloh.API.Util.GeneralUtil.Tools;
import me.marcangeloh.Bootstrap;
import me.marcangeloh.Config.ConfigManager;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.CustomEnchantments.Enchantments.Multi.Backpack.BackpackData;
import me.marcangeloh.PointsCore;
import me.marcangeloh.Util.CheckerUtil;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Backpack
extends AbstractCustomEnchantment {
    ItemStack nextPage = null;
    ItemStack lastPage = null;
    ItemStack filler;
    ConfigManager cfgm;
    PointsCore pointsCore;
    protected ArrayList<HashMap<String, BackpackData>> backpacks = new ArrayList();

    public void loadData() {
        for (int i = 0; i < 6; ++i) {
            this.backpacks.add(new HashMap());
            try {
                Set uuids;
                if (this.cfgm.getPlayerData().getConfigurationSection("backpacks" + i) == null || (uuids = this.cfgm.getPlayerData().getConfigurationSection("backpacks" + i).getKeys(false)) == null) continue;
                for (String uuid : uuids) {
                    this.backpacks.get(i).put(uuid, new BackpackData());
                    Set stackids = this.cfgm.getPlayerData().getConfigurationSection("backpacks" + i + "." + uuid + ".stacks").getKeys(false);
                    if (this.cfgm.getPlayerData().getConfigurationSection("backpacks" + i + "." + uuid + ".stacks") == null || stackids == null) continue;
                    for (String stackid : stackids) {
                        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)("Backpack p. " + stackid));
                        ArrayList itemstackList = (ArrayList)this.cfgm.getPlayerData().getList("backpacks" + i + "." + uuid + ".stacks." + stackid);
                        if (itemstackList == null) continue;
                        ItemStack[] contents = new ItemStack[itemstackList.size()];
                        contents = itemstackList.toArray(contents);
                        inventory.setContents(contents);
                        this.backpacks.get(i).get(uuid).setInventory(Integer.parseInt(stackid), inventory);
                    }
                }
                continue;
            }
            catch (NullPointerException exception) {
                exception.printStackTrace();
                continue;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveData() throws IOException {
        for (int i = 0; i < 6; ++i) {
            for (String uuid : this.backpacks.get(i).keySet()) {
                int counter = 0;
                for (ItemStack[] stacks : this.backpacks.get((int)i).get((Object)uuid).inventories) {
                    this.cfgm.getPlayerData().set("backpacks" + i + "." + uuid + ".stacks." + counter, (Object)stacks);
                    this.cfgm.savePlayerData();
                    ++counter;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void interactEvent(PlayerInteractEvent event) {
        Enchantment yourEnchantment;
        Player player = event.getPlayer();
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (!itemStack.containsEnchantment(yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.getKey()))))) {
            return;
        }
        this.openBackpack(player, 0);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void inventoryInteractEvent(InventoryClickEvent event) {
        Tools required;
        Tools tools;
        String title = event.getView().getTitle();
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!title.contains("Backpack")) {
            return;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        int page = this.backpacks.get(this.getHashmapIndex(itemInHand)).get(player.getUniqueId().toString()).getPage(title);
        if (page == -1) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null) {
            return;
        }
        event.setCancelled(true);
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.getKey())));
        if (clicked.equals((Object)this.nextPage)) {
            int level = player.getInventory().getItemInMainHand().getEnchantmentLevel(yourEnchantment);
            if (level - 1 <= page) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You need to upgrade the backpack for more pages");
                return;
            }
            this.openBackpack(player, page + 1);
        }
        if (clicked.equals((Object)this.lastPage)) {
            if (page - 1 < 0) {
                return;
            }
            this.openBackpack(player, page - 1);
        }
        if ((tools = new ValueUtil(this.pointsCore).getToolType(itemInHand.getType())).equals((Object)Tools.RANGED_WEAPON)) {
            tools = Tools.MELEE_WEAPON;
        }
        if (!(required = ToolUtil.getToolTypeForMaterial((Material)clicked.getType())).equals((Object)tools)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This item cannot be stored in a " + String.valueOf(tools) + " backpack, \ninstead, try storing it in a " + String.valueOf(required) + " backpack.");
            return;
        }
        this.backpacks.get(this.getHashmapIndex(player.getInventory().getItemInMainHand())).get(player.getUniqueId().toString()).setInventory(page, event.getView().getTopInventory());
        Inventory inv = this.backpacks.get(this.getHashmapIndex(player.getInventory().getItemInMainHand())).get(player.getUniqueId().toString()).getInventory(page);
        if (event.getView().getTopInventory().equals((Object)event.getClickedInventory())) {
            player.getInventory().addItem(new ItemStack[]{clicked});
            inv.removeItem(new ItemStack[]{clicked});
        } else {
            player.getInventory().removeItem(new ItemStack[]{clicked});
            inv.addItem(new ItemStack[]{clicked});
        }
        this.backpacks.get(this.getHashmapIndex(player.getInventory().getItemInMainHand())).get(player.getUniqueId().toString()).setInventory(page, inv);
        player.openInventory(inv);
    }

    @EventHandler
    public void saveEvent(InventoryCloseEvent event) {
        if (event.getView().getTitle().contains("Backpack")) {
            try {
                this.saveData();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void openBackpack(Player player, int page) {
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (tool == null) {
            return;
        }
        int index = this.getHashmapIndex(tool);
        if (index == -1) {
            return;
        }
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.getKey())));
        int level = tool.getEnchantmentLevel(yourEnchantment);
        if (level <= 0) {
            return;
        }
        if (!this.backpacks.get(index).containsKey(player.getUniqueId().toString())) {
            this.backpacks.get(index).put(player.getUniqueId().toString(), new BackpackData());
        }
        if (this.nextPage == null || this.lastPage == null) {
            return;
        }
        if (this.backpacks.get(index).get(player.getUniqueId().toString()).getInventory(page) == null) {
            Inventory inventory = Bukkit.createInventory(null, (int)54, (String)("Backpack p. " + page));
            for (int i = 45; i < 54; ++i) {
                if (i == 47) {
                    inventory.setItem(i, this.lastPage);
                    continue;
                }
                if (i == 51) {
                    inventory.setItem(i, this.nextPage);
                    continue;
                }
                inventory.setItem(i, this.filler);
            }
            this.backpacks.get(index).get(player.getUniqueId().toString()).setInventory(page, inventory);
        }
        player.openInventory(this.backpacks.get(index).get(player.getUniqueId().toString()).getInventory(page));
    }

    private int getHashmapIndex(ItemStack tool) {
        if (CheckerUtil.checkForPickaxe(tool)) {
            return 0;
        }
        if (CheckerUtil.checkForShovel(tool)) {
            return 1;
        }
        if (CheckerUtil.checkForWeapons(tool)) {
            return 3;
        }
        if (CheckerUtil.checkForAxe(tool)) {
            return 2;
        }
        if (CheckerUtil.checkForHoe(tool)) {
            return 4;
        }
        if (tool.getType().equals((Object)Material.FISHING_ROD)) {
            return 5;
        }
        return -1;
    }

    public Backpack(List<String> path, String name, ConfigManager cfgm, BootstrapContext context) {
        super(name, path, context);
        this.cfgm = cfgm;
        if (!this.isEnchantEnabled()) {
            return;
        }
        context.getLifecycleManager().registerEventHandler(RegistryEvents.ENCHANTMENT.freeze().newHandler(event -> event.registry().register(EnchantmentKeys.create((Key)Key.key((String)("utools:" + this.getKey()))), b -> b.description((Component)Component.text((String)name.replace("_", " "))).supportedItems((RegistryKeySet)event.getOrCreateTag(Bootstrap.Tools)).maxLevel(this.getMaxLevel()).anvilCost(0).weight(1).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).activeSlots(new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY}))));
    }

    @Override
    public void registerEvent(JavaPlugin plugin) {
        ArrayList<String> lores = new ArrayList<String>();
        this.pointsCore = (PointsCore)Bukkit.getServer().getPluginManager().getPlugin("PointsCore");
        lores.add(String.valueOf(ChatColor.GRAY) + "This will take you to the next page.");
        this.nextPage = CheckerUtil.getHead("ee5d9dc951196223ac72947803a1093965ea8986a95bd9cd42e3d00240113f10", String.valueOf(ChatColor.BLUE) + "Next Page", lores);
        lores.clear();
        lores.add(String.valueOf(ChatColor.GRAY) + "This will take you to the last page");
        this.lastPage = CheckerUtil.getHead("7ee09290620c8b29591fd001e7395cf32464e2fd4b5459ff757d0cd8e1c752f8", String.valueOf(ChatColor.BLUE) + "Last Page", lores);
        lores.clear();
        this.filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fm = this.filler.getItemMeta();
        fm.setDisplayName(String.valueOf(ChatColor.YELLOW));
        this.filler.setItemMeta(fm);
        this.loadData();
        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "Backpacks Loaded");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public String getName() {
        return "Backpack";
    }

    @Override
    public EquipmentSlotGroup getEquipmentSlotGroup() {
        return EquipmentSlotGroup.HAND;
    }

    @Override
    public TagKey<ItemType> getItemTarget() {
        return null;
    }
}

