/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments.Enchantments.Armor;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import io.papermc.paper.registry.keys.tags.ItemTypeTagKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.tag.TagKey;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class NightVision
extends AbstractCustomEnchantment {
    @EventHandler(priority=EventPriority.LOWEST)
    public void playerMoveEvent(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        ItemStack tool = event.getPlayer().getInventory().getHelmet();
        if (tool == null) {
            return;
        }
        if (tool.getType().equals((Object)Material.AIR)) {
            return;
        }
        if (tool.getEnchantments().isEmpty()) {
            return;
        }
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.getKey())));
        if (!tool.containsEnchantment(yourEnchantment)) {
            return;
        }
        double level = tool.getEnchantmentLevel(yourEnchantment);
        if (player.getPotionEffect(PotionEffectType.NIGHT_VISION) != null) {
            return;
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, (int)(2.0 * level)));
    }

    @EventHandler(priority=EventPriority.LOW)
    public void armorUnequipEvent(InventoryClickEvent event) {
        if (event.getClickedInventory() == null) {
            return;
        }
        if (!event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
            return;
        }
        if (event.getSlot() != 39) {
            return;
        }
        ItemStack tool = event.getCurrentItem();
        if (tool == null) {
            return;
        }
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.getKey())));
        if (!tool.containsEnchantment(yourEnchantment)) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        player.removePotionEffect(PotionEffectType.NIGHT_VISION);
    }

    public NightVision(String path, String name, BootstrapContext context) {
        super(name, path, context);
        if (!this.isEnchantEnabled()) {
            return;
        }
        context.getLifecycleManager().registerEventHandler(RegistryEvents.ENCHANTMENT.freeze().newHandler(event -> event.registry().register(EnchantmentKeys.create((Key)Key.key((String)("utools:" + this.getKey()))), b -> b.description((Component)Component.text((String)name.replace("_", " "))).supportedItems((RegistryKeySet)event.getOrCreateTag(this.getItemTarget())).maxLevel(this.getMaxLevel()).anvilCost(0).weight(1).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).activeSlots(new EquipmentSlotGroup[]{EquipmentSlotGroup.HEAD}))));
    }

    @Override
    public String getName() {
        return "Night Vision";
    }

    @Override
    public EquipmentSlotGroup getEquipmentSlotGroup() {
        return EquipmentSlotGroup.HEAD;
    }

    @Override
    public TagKey<ItemType> getItemTarget() {
        return ItemTypeTagKeys.ENCHANTABLE_HEAD_ARMOR;
    }
}

