/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments.Enchantments.Armor;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import io.papermc.paper.registry.keys.tags.ItemTypeTagKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.tag.TagKey;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.PointsUtil;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;

public class Blink
extends AbstractCustomEnchantment {
    public Blink(String path, String name, BootstrapContext context) {
        super(name, path, context);
        if (!this.isEnchantEnabled()) {
            return;
        }
        context.getLifecycleManager().registerEventHandler(RegistryEvents.ENCHANTMENT.freeze().newHandler(event -> event.registry().register(EnchantmentKeys.create((Key)Key.key((String)("utools:" + this.getKey()))), b -> b.description((Component)Component.text((String)name.replace("_", " "))).supportedItems((RegistryKeySet)event.getOrCreateTag(this.getItemTarget())).maxLevel(this.getMaxLevel()).anvilCost(0).weight(1).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)0, (int)0)).activeSlots(new EquipmentSlotGroup[]{EquipmentSlotGroup.HEAD}))));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void playerRightClick(PlayerInteractEvent event) {
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getInventory().getItemInMainHand() != null && player.getInventory().getItemInMainHand().getType() != Material.AIR) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        ItemStack helmet = player.getInventory().getHelmet();
        if (helmet == null || helmet.getType() == Material.AIR) {
            return;
        }
        Enchantment yourEnchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(Key.key((String)("utools:" + this.getKey())));
        if (yourEnchantment == null) {
            return;
        }
        int level = helmet.getEnchantmentLevel(yourEnchantment);
        if (level == 0) {
            return;
        }
        PointsUtil pointsUtil = new PointsUtil(UpgradeableTools.PLUGIN.pointsCore);
        int maxDistance = 10 * level;
        Block targetBlock = player.getTargetBlockExact(maxDistance, FluidCollisionMode.NEVER);
        if (targetBlock == null) {
            return;
        }
        Location targetLocation = targetBlock.getLocation();
        Block blockAbove = targetLocation.clone().add(0.0, 1.0, 0.0).getBlock();
        Block twoBlocksAbove = targetLocation.clone().add(0.0, 2.0, 0.0).getBlock();
        if (blockAbove.getType().isSolid() || twoBlocksAbove.getType().isSolid()) {
            return;
        }
        Location teleportLocation = targetLocation.add(0.5, 1.0, 0.5);
        if (pointsUtil.withdrawPointsFor(helmet, player, 50.0 / (double)level)) {
            player.teleport(teleportLocation);
        }
    }

    @Override
    public String getName() {
        return "Blink";
    }

    @Override
    public TagKey<ItemType> getItemTarget() {
        return ItemTypeTagKeys.ENCHANTABLE_HEAD_ARMOR;
    }

    @Override
    public EquipmentSlotGroup getEquipmentSlotGroup() {
        return EquipmentSlotGroup.HEAD;
    }
}

