/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.CustomEnchantments;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.marcangeloh.Config.ConfigManager;
import me.marcangeloh.CustomEnchantments.Enchantments.AbstractCustomEnchantment;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.Blink;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.Dupe;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.ExplosiveTouch;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.NightVision;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.PoisonTouch;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.SecondChance;
import me.marcangeloh.CustomEnchantments.Enchantments.Armor.Speed;
import me.marcangeloh.CustomEnchantments.Enchantments.Multi.Backpack.Backpack;
import me.marcangeloh.CustomEnchantments.Enchantments.Multi.MendWalker;
import me.marcangeloh.CustomEnchantments.Enchantments.Multi.SoulBound;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.AutoEquip;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.BlastExcavating;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.BlastMining;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.Drain;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.Fell;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.Luck;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.Magnetic;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.MassHarvest;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.MassPlanter;
import me.marcangeloh.CustomEnchantments.Enchantments.Tools.Smelter;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.Bleed.Bleed;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.Confusion;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.Decapitation;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.Explosive;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.Freeze;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.LifeSteal;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.PoisonShot;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.ShockWave;
import me.marcangeloh.CustomEnchantments.Enchantments.Weapons.Spook;
import me.marcangeloh.UpgradeableTools;
import me.marcangeloh.Util.CheckerUtil;
import me.marcangeloh.Util.GeneralUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomEnchants {
    public static Plugin PLUGIN;
    public static ArrayList<AbstractCustomEnchantment> custom_enchants;
    public static Drain drain;
    public static Smelter smelter;
    public static Luck luck;
    public static MendWalker mendWalker;
    public static BlastMining blastMining;
    public static BlastExcavating blastExcavating;
    public static Decapitation decapitation;
    public static Explosive explosive;
    public static LifeSteal lifeSteal;
    public static SoulBound soulBound;
    public static Blink blink;
    public static Speed speed;
    public static PoisonTouch poisonTouch;
    public static ExplosiveTouch explosiveTouch;
    public static Dupe dupe;
    public static NightVision nightVision;
    public static Magnetic magnetic;
    public static Fell fell;
    public static MassPlanter massPlanter;
    public static MassHarvest massHarvester;
    public static ShockWave shockwave;
    public static AutoEquip autoEquip;
    public static Backpack backpack;
    public static SecondChance secondChance;
    public static Bleed bleed;
    public static Freeze freeze;
    public static PoisonShot poisonShot;
    public static Spook spook;
    public static Confusion confusion;

    public void onDisable() {
        try {
            backpack.saveData();
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "Backpacks saved");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save backpack data.", e);
        }
    }

    public void onBootstrap(BootstrapContext context, ConfigManager cfgm) {
        drain = new Drain("Pickaxe.Drain", "Drain", context);
        smelter = new Smelter("Pickaxe.Smelter", "Smelter", context);
        luck = new Luck("Shovel.Luck", "Luck", context);
        blastMining = new BlastMining("Pickaxe.BlastMining", "Blast_Mining", context);
        mendWalker = new MendWalker(Arrays.asList("Pickaxe.MendWalker", "Shovel.MendWalker", "Axe.MendWalker", "FishingRod.MendWalker", "Swords.MendWalker", "Hoe.MendWalker"), "Mend_Walker", context);
        blastExcavating = new BlastExcavating("Shovel.BlastExcavating", "Blast_Excavating", context);
        decapitation = new Decapitation("Swords.Decapitation", "Decapitation", context);
        explosive = new Explosive("Bow.Explosive", "Explosive", context);
        lifeSteal = new LifeSteal("Swords.LifeSteal", "Life_Steal", context);
        soulBound = new SoulBound(Arrays.asList("Swords.SoulBound", "Trident.SoulBound", "Crossbow.SoulBound", "Bow.SoulBound", "Hoe.SoulBound", "Armor.SoulBound", "Pickaxe.SoulBound", "Axe.SoulBound", "FishingRod.SoulBound", "Shovel.SoulBound"), "Soul_Bound", context);
        blink = new Blink("Armor.Blink", "Blink", context);
        speed = new Speed("Armor.Speed", "Speed", context);
        poisonTouch = new PoisonTouch("Armor.PoisonTouch", "Poison_Touch", context);
        explosiveTouch = new ExplosiveTouch("Armor.ExplosiveTouch", "Explosive_Touch", context);
        dupe = new Dupe("Armor.Dupe", "Dupe", context);
        nightVision = new NightVision("Armor.NightVision", "Night_Vision", context);
        magnetic = new Magnetic(Arrays.asList("Pickaxe.Magnetic", "Shovel.Magnetic", "Axe.Magnetic"), "Magnetic", context);
        fell = new Fell("Axe.Fell", "Fell", context);
        massPlanter = new MassPlanter("Hoe.MassPlanter", "Mass_Planter", context);
        massHarvester = new MassHarvest("Hoe.MassHarvester", "Mass_Harvester", context);
        shockwave = new ShockWave("Swords.Shockwave", "Shockwave", context);
        autoEquip = new AutoEquip(Arrays.asList("Pickaxe.AutoEquip", "Shovel.AutoEquip", "Axe.AutoEquip"), "Auto_Equip", context);
        backpack = new Backpack(Arrays.asList("Pickaxe.Backpack", "Shovel.Backpack", "Axe.Backpack", "FishingRod.Backpack", "Swords.Backpack", "Trident.Backpack", "Crossbow.Backpack", "Bow.Backpack", "Hoe.Backpack"), "Backpack", cfgm, context);
        secondChance = new SecondChance("Armor.SecondChance", "Second_Chance", context);
        bleed = new Bleed("Swords.Bleed", "Bleed", context);
        freeze = new Freeze("Swords.Freeze", "Freeze", context);
        poisonShot = new PoisonShot(Arrays.asList("Crossbow.PoisonShot", "Bow.PoisonShot"), "Poison_Shot", context);
        spook = new Spook("Swords.Spook", "Spook", context);
        confusion = new Confusion("Swords.Confusion", "Confusion", context);
        custom_enchants.addAll(List.of(drain, smelter, luck, blastMining, mendWalker, blastExcavating, decapitation, explosive, lifeSteal, soulBound, blink, speed, poisonTouch, explosiveTouch, dupe, nightVision, magnetic, fell, massPlanter, massHarvester, autoEquip, shockwave, backpack, secondChance, bleed, freeze, poisonShot, spook, confusion));
    }

    public static int getLevel(ItemStack item, String enchantDisplayName) {
        List lores;
        if (item == null || !item.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        List list = lores = meta.hasLore() ? meta.getLore() : null;
        if (lores == null || lores.isEmpty()) {
            return 0;
        }
        String strippedEnchantDisplayName = ChatColor.stripColor((String)enchantDisplayName).trim();
        for (String lore : lores) {
            String strippedLore = ChatColor.stripColor((String)lore).trim();
            if (!strippedLore.startsWith(strippedEnchantDisplayName)) continue;
            String levelString = strippedLore.substring(strippedEnchantDisplayName.length()).trim();
            if (levelString.isEmpty()) {
                return 0;
            }
            try {
                for (int x = 10; x > 0; --x) {
                    if (!levelString.equalsIgnoreCase(GeneralUtil.integerToRoman(x))) continue;
                    return x;
                }
                return Integer.parseInt(levelString);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public static String getConfigEnchantmentDisplayName(ItemStack item, String enchantKey) {
        String baseConfigPath = "MultiplierToLevel.";
        String typeSpecificPath = "";
        if (CheckerUtil.checkForBow(item)) {
            typeSpecificPath = "Bow.";
        } else if (CheckerUtil.checkForCrossbow(item)) {
            typeSpecificPath = "Crossbow.";
        } else if (CheckerUtil.checkForTrident(item)) {
            typeSpecificPath = "Trident.";
        } else if (CheckerUtil.checkForAxe(item)) {
            typeSpecificPath = "Axe.";
        } else if (CheckerUtil.checkForShovel(item)) {
            typeSpecificPath = "Shovel.";
        } else if (CheckerUtil.checkForPickaxe(item)) {
            typeSpecificPath = "Pickaxe.";
        } else if (CheckerUtil.checkForSwords(item)) {
            typeSpecificPath = "Swords.";
        } else if (CheckerUtil.checkForHoe(item)) {
            typeSpecificPath = "Hoe.";
        } else if (CheckerUtil.checkForArmor(item)) {
            typeSpecificPath = "Armor.";
        } else {
            return "";
        }
        return UpgradeableTools.PLUGIN.getConfig().getString(baseConfigPath + typeSpecificPath + enchantKey + ".name", "");
    }

    public void onEnable(JavaPlugin plugin) {
        for (AbstractCustomEnchantment enchant : custom_enchants) {
            enchant.registerEvent(plugin);
        }
    }

    static {
        custom_enchants = new ArrayList();
    }
}

