/*
 * Decompiled with CFR 0.152.
 */
package me.marcangeloh.Config;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import java.io.File;
import java.io.IOException;
import me.marcangeloh.UpgradeableTools;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    public static FileConfiguration permissions;
    public static File permissionsFile;
    protected static FileConfiguration fileConfig;
    protected File playerFiles;

    public ConfigManager(BootstrapContext context) {
        this.setup(this.getDataFolder(context));
    }

    public ConfigManager() {
        this.setup(UpgradeableTools.PLUGIN.getDataFolder());
    }

    private static void setDefaultPermissions() {
        String permsPath = "Permissions.";
        String perEnchant = permsPath + "per-enchantment-permissions.";
        String perEnchEnabled = perEnchant + ".enabled";
        String perEnchLevel = perEnchant + ".per-level";
        String permissionsCheck = perEnchant + ".permissions-check";
        permissions.addDefault(perEnchEnabled, (Object)true);
        permissions.addDefault(perEnchLevel, (Object)true);
        permissions.addDefault(permissionsCheck, (Object)false);
        permissions.options().copyDefaults(true);
        try {
            permissions.save(permissionsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setup() {
        this.setup(UpgradeableTools.PLUGIN.getDataFolder());
        fileConfig = YamlConfiguration.loadConfiguration((File)this.playerFiles);
    }

    public void setup(File dataFolder) {
        if (!dataFolder.exists()) {
            dataFolder.mkdir();
        }
        this.playerFiles = new File(dataFolder, "player.yml");
        permissionsFile = new File(dataFolder, "permissions.yml");
        try {
            permissionsFile.createNewFile();
            this.playerFiles.createNewFile();
        }
        catch (IOException e) {
            Bukkit.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "Couldn't create player.yml file!");
        }
        permissions = YamlConfiguration.loadConfiguration((File)permissionsFile);
        ConfigManager.setDefaultPermissions();
    }

    private File getDataFolder(BootstrapContext context) {
        return context.getDataDirectory().toFile();
    }

    public FileConfiguration getPlayerData() {
        return fileConfig;
    }

    public void savePlayerData() {
        try {
            fileConfig.save(this.playerFiles);
        }
        catch (IOException e) {
            Bukkit.getServer().getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "Couldn't save player.yml File!");
        }
    }

    public void reloadPlayerData() {
        fileConfig = YamlConfiguration.loadConfiguration((File)this.playerFiles);
    }
}

