/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.utils.selection;

import io.github.lijinhong11.supermines.SuperMines;
import io.github.lijinhong11.supermines.message.MessageReplacement;
import io.github.lijinhong11.supermines.utils.selection.AreaSelection;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class SelectionValidator {
    private SelectionValidator() {
    }

    public static boolean validateSingleLocation(Player player, Location loc) {
        if (loc == null || loc.getWorld() == null) {
            return false;
        }
        World world = loc.getWorld();
        int y = loc.getBlockY();
        if (y < world.getMinHeight() || y >= world.getMaxHeight()) {
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.pos.invalid-height", new MessageReplacement[0]);
            return false;
        }
        WorldBorder border = world.getWorldBorder();
        if (!border.isInside(loc)) {
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.pos.outside-border", new MessageReplacement[0]);
            return false;
        }
        return true;
    }

    public static boolean validateWorldConsistency(Player player, AreaSelection sel, Location newLoc) {
        Location other;
        if (sel == null) {
            return true;
        }
        Location location = other = sel.pos1() != null ? sel.pos1() : sel.pos2();
        if (other == null) {
            return true;
        }
        if (!other.getWorld().equals((Object)newLoc.getWorld())) {
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.pos.different-world", new MessageReplacement[0]);
            return false;
        }
        return true;
    }

    public static boolean validateAll(Player player, AreaSelection current, Location newLoc) {
        return SelectionValidator.validateSingleLocation(player, newLoc) && SelectionValidator.validateWorldConsistency(player, current, newLoc);
    }
}

