/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.utils;

import io.github.lijinhong11.supermines.SuperMines;
import io.github.lijinhong11.supermines.message.MessageReplacement;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.command.CommandSender;

public class NumberUtils {
    private NumberUtils() {
    }

    public static boolean matchChance(double chancePercent) {
        return chancePercent / 100.0 >= 1.0 || ThreadLocalRandom.current().nextDouble(1.0) < chancePercent / 100.0;
    }

    public static <T> T weightedRandom(Map<T, Double> map) {
        double totalWeight = map.values().stream().mapToDouble(Double::doubleValue).sum();
        double random = Math.random() * totalWeight;
        double current = 0.0;
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            if (!(random <= (current += entry.getValue().doubleValue()))) continue;
            return entry.getKey();
        }
        return map.keySet().iterator().next();
    }

    public static String formatSeconds(CommandSender cs, int totalSeconds) {
        String secondText = SuperMines.getInstance().getLanguageManager().getMsg(cs, "second", new MessageReplacement[0]);
        String secondsText = SuperMines.getInstance().getLanguageManager().getMsg(cs, "seconds", new MessageReplacement[0]);
        String minuteText = SuperMines.getInstance().getLanguageManager().getMsg(cs, "minute", new MessageReplacement[0]);
        String minutesText = SuperMines.getInstance().getLanguageManager().getMsg(cs, "minutes", new MessageReplacement[0]);
        String hourText = SuperMines.getInstance().getLanguageManager().getMsg(cs, "hour", new MessageReplacement[0]);
        String hoursText = SuperMines.getInstance().getLanguageManager().getMsg(cs, "hours", new MessageReplacement[0]);
        String dayText = SuperMines.getInstance().getLanguageManager().getMsg(cs, "day", new MessageReplacement[0]);
        String daysText = SuperMines.getInstance().getLanguageManager().getMsg(cs, "days", new MessageReplacement[0]);
        int days = totalSeconds / 86400;
        int hours = totalSeconds % 86400 / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        StringBuilder sb = new StringBuilder();
        if (days > 0) {
            sb.append(days).append(" ").append(days == 1 ? dayText : daysText).append(" ");
        }
        if (hours > 0) {
            sb.append(hours).append(" ").append(hours == 1 ? hourText : hoursText).append(" ");
        }
        if (minutes > 0) {
            sb.append(minutes).append(" ").append(minutes == 1 ? minuteText : minutesText).append(" ");
        }
        if (seconds > 0 || sb.isEmpty()) {
            sb.append(seconds).append(" ").append(seconds == 1 ? secondText : secondsText);
        }
        return sb.toString().trim();
    }
}

