/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.message;

import com.google.common.base.Preconditions;
import io.github.lijinhong11.supermines.api.data.Rank;
import io.github.lijinhong11.supermines.api.mine.Mine;
import io.github.lijinhong11.supermines.api.mine.Treasure;
import io.github.lijinhong11.supermines.message.MessageReplacement;
import io.github.lijinhong11.supermines.utils.ComponentUtils;
import io.github.lijinhong11.supermines.utils.ConfigFileUtil;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageManager {
    private final Plugin plugin;
    private final String defaultLanguage;
    private final Map<String, YamlConfiguration> configurations = new HashMap<String, YamlConfiguration>();
    private boolean detectPlayerLocale;
    private YamlConfiguration defaultConfiguration;

    public LanguageManager(Plugin plugin) {
        this(plugin, "en-US");
    }

    public LanguageManager(Plugin plugin, String defaultLanguage) {
        this.plugin = plugin;
        this.defaultLanguage = defaultLanguage;
        this.loadLanguages();
    }

    public static Component parseToComponent(String msg) {
        return ComponentUtils.deserialize(msg);
    }

    public static List<Component> parseToComponentList(List<String> msgList) {
        return msgList.stream().map(LanguageManager::parseToComponent).toList();
    }

    private void loadLanguages() {
        this.detectPlayerLocale = this.plugin.getConfig().getBoolean("detect-player-locale", true);
        File pluginFolder = this.plugin.getDataFolder();
        URL fileURL = Objects.requireNonNull(this.plugin.getClass().getClassLoader().getResource("language/"));
        String jarPath = fileURL.toString().substring(0, fileURL.toString().indexOf("!/") + 2);
        File languageFolder = new File(pluginFolder, "language");
        try {
            languageFolder.mkdirs();
            URL jar = URI.create(jarPath).toURL();
            JarURLConnection jarCon = (JarURLConnection)jar.openConnection();
            JarFile jarFile = jarCon.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("language/") || entry.isDirectory()) continue;
                String realName = name.replaceFirst("language/", "");
                Path path = languageFolder.toPath().resolve(realName);
                if (!path.toFile().exists()) {
                    this.plugin.saveResource("language/" + realName, false);
                    continue;
                }
                ConfigFileUtil.completeLangFile(this.plugin, "language/" + realName);
            }
        }
        catch (Exception jar) {
            // empty catch block
        }
        this.defaultConfiguration = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "language/en-US.yml"));
        File[] languageFiles = languageFolder.listFiles(f -> f.getName().endsWith(".yml"));
        if (languageFiles != null) {
            for (File languageFile : languageFiles) {
                String language = this.convertToRightLangCode(languageFile.getName().replaceAll(".yml", ""));
                ConfigFileUtil.completeLangFile(this.plugin, "language/" + languageFile.getName());
                this.configurations.put(language, YamlConfiguration.loadConfiguration((File)languageFile));
            }
        }
    }

    private String convertToRightLangCode(String lang) {
        if (lang == null || lang.isBlank()) {
            return "en-US";
        }
        String[] split = lang.split("-");
        if (split.length == 1) {
            String[] split2 = lang.split("_");
            if (split2.length == 1) {
                return lang;
            }
            return lang.replace(split2[1], split2[1].toUpperCase());
        }
        return lang.replace(split[1], split[1].toUpperCase());
    }

    public List<Component> getMineInfo(@NotNull Player p, @NotNull Mine mine) {
        Preconditions.checkNotNull((Object)mine, (Object)"mine cannot be null");
        MessageReplacement world = MessageReplacement.replace("%world%", mine.getWorld().getName());
        MessageReplacement regenerateSeconds = MessageReplacement.replace("%regenerate_seconds%", String.valueOf(mine.getRegenerateSeconds()));
        MessageReplacement pos1 = MessageReplacement.replace("%pos1%", mine.getArea().pos1().toString());
        MessageReplacement pos2 = MessageReplacement.replace("%pos2%", mine.getArea().pos2().toString());
        return this.getMsgComponentList((CommandSender)p, "gui.mines.info", world, regenerateSeconds, pos1, pos2);
    }

    public List<Component> getTreasureInfo(@NotNull Player p, @NotNull Treasure treasure) {
        MessageReplacement chance = MessageReplacement.replace("%chance%", String.valueOf(treasure.getChance()));
        MessageReplacement matchedMaterials = MessageReplacement.replace("%matched_materials%", String.valueOf(treasure.getMatchedBlocks().size()));
        return this.getMsgComponentList((CommandSender)p, "gui.treasures.info", chance, matchedMaterials);
    }

    public List<Component> getRankInfo(@NotNull Player p, @NotNull Rank rank) {
        MessageReplacement level = MessageReplacement.replace("%level%", String.valueOf(rank.getLevel()));
        return this.getMsgComponentList((CommandSender)p, "gui.ranks.info", level);
    }

    public void sendMessage(CommandSender commandSender, String key, MessageReplacement ... args) {
        commandSender.sendMessage(LanguageManager.parseToComponent(this.getMsg(commandSender, key, args)));
    }

    public void sendMessage(CommandSender commandSender, String key, ClickEvent clickEvent, MessageReplacement ... args) {
        commandSender.sendMessage(LanguageManager.parseToComponent(this.getMsg(commandSender, key, args)).clickEvent(clickEvent));
    }

    public void sendMessages(CommandSender commandSender, String key, MessageReplacement ... args) {
        for (String msg : this.getMsgList(commandSender, key, args)) {
            commandSender.sendMessage(LanguageManager.parseToComponent(msg));
        }
    }

    public Component getMsgComponent(@Nullable CommandSender commandSender, String key, MessageReplacement ... args) {
        return LanguageManager.parseToComponent(this.getMsg(commandSender, key, args));
    }

    public Component getMsgComponentByLanguage(@Nullable String lang, String key, MessageReplacement ... args) {
        return LanguageManager.parseToComponent(this.getMsgByLanguage(lang, key, args));
    }

    public List<Component> getMsgComponentList(@Nullable CommandSender commandSender, String key, MessageReplacement ... args) {
        return LanguageManager.parseToComponentList(this.getMsgList(commandSender, key, args));
    }

    public List<Component> getMsgComponentListByLanguage(@Nullable String lang, String key, MessageReplacement ... args) {
        return LanguageManager.parseToComponentList(this.getMsgListByLanguage(lang, key, args));
    }

    public String getMsg(@Nullable CommandSender commandSender, String key, MessageReplacement ... args) {
        String msg = this.getConfiguration(commandSender).getString(key);
        if (msg == null) {
            return key;
        }
        for (MessageReplacement arg : args) {
            msg = arg.parse(msg);
        }
        return msg;
    }

    public List<String> getMsgList(@Nullable CommandSender commandSender, String key, MessageReplacement ... args) {
        List msgList = this.getConfiguration(commandSender).getStringList(key);
        for (MessageReplacement arg : args) {
            msgList.replaceAll(arg::parse);
        }
        return msgList;
    }

    public String getMsgByLanguage(@Nullable String lang, String key, MessageReplacement ... args) {
        String msg = this.getConfiguration(lang).getString(key);
        if (msg == null) {
            return key;
        }
        for (MessageReplacement arg : args) {
            msg = arg.parse(msg);
        }
        return msg;
    }

    public List<String> getMsgListByLanguage(@Nullable String lang, String key, MessageReplacement ... args) {
        List msgList = this.getConfiguration(lang).getStringList(key);
        for (MessageReplacement arg : args) {
            msgList.replaceAll(arg::parse);
        }
        return msgList;
    }

    public void reload() {
        this.loadLanguages();
    }

    private Configuration getConfiguration(CommandSender p) {
        if (!this.detectPlayerLocale || !(p instanceof Player)) {
            String lang = this.plugin.getConfig().getString("language", this.defaultLanguage);
            return (Configuration)this.configurations.getOrDefault(lang, this.defaultConfiguration);
        }
        Player pl = (Player)p;
        return (Configuration)this.configurations.getOrDefault(pl.locale().toLanguageTag(), this.defaultConfiguration);
    }

    private Configuration getConfiguration(String lang) {
        return (Configuration)this.configurations.getOrDefault(Objects.requireNonNullElse(lang, this.defaultLanguage), this.defaultConfiguration);
    }
}

