/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.managers;

import io.github.lijinhong11.supermines.api.data.PlayerData;
import io.github.lijinhong11.supermines.api.data.Rank;
import io.github.lijinhong11.supermines.libraries.database.DatabaseConnection;
import io.github.lijinhong11.supermines.managers.abstracts.AbstractDatabaseObjectManager;
import io.github.lijinhong11.supermines.managers.database.StringRankSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerDataManager
extends AbstractDatabaseObjectManager<PlayerData> {
    private final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();

    public PlayerDataManager(DatabaseConnection connection) {
        super(connection, PlayerData.class);
        this.load();
    }

    private void load() {
        for (PlayerData object : super.getAll()) {
            this.playerDataMap.put(object.getPlayerUUID(), object);
        }
    }

    @Nullable
    public PlayerData getPlayerData(String name) {
        for (PlayerData object : this.playerDataMap.values()) {
            if (!object.getPlayerName().equals(name)) continue;
            return object;
        }
        return null;
    }

    @Nullable
    public PlayerData getPlayerData(UUID uuid) {
        return this.playerDataMap.get(uuid);
    }

    @NotNull
    public PlayerData getOrCreatePlayerData(@NotNull UUID playerUUID) {
        PlayerData playerData = this.getPlayerData(playerUUID);
        if (playerData == null) {
            playerData = new PlayerData(Bukkit.getOfflinePlayer((UUID)playerUUID).getName(), playerUUID, new StringRankSet(Rank.DEFAULT));
            super.saveObject(playerData);
            this.playerDataMap.put(playerUUID, playerData);
        }
        return playerData;
    }

    @Override
    public void saveAndClose() {
        for (PlayerData playerData : this.playerDataMap.values()) {
            super.saveObject(playerData);
        }
        super.close();
    }
}

