/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.managers;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.github.lijinhong11.supermines.SuperMines;
import io.github.lijinhong11.supermines.api.mine.Mine;
import io.github.lijinhong11.supermines.api.mine.Treasure;
import io.github.lijinhong11.supermines.api.pos.BlockPos;
import io.github.lijinhong11.supermines.api.pos.CuboidArea;
import io.github.lijinhong11.supermines.integrates.block.AddonBlock;
import io.github.lijinhong11.supermines.integrates.block.BlockAddon;
import io.github.lijinhong11.supermines.managers.abstracts.AbstractFileObjectManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MineManager
extends AbstractFileObjectManager<Mine> {
    private final Map<String, Mine> mines = new HashMap<String, Mine>();

    public MineManager() {
        super("data/mines.yml");
        this.load();
    }

    private void load() {
        for (Mine object : super.getAll()) {
            this.mines.put(object.getId(), object);
        }
    }

    @Override
    protected Mine getObject(@NotNull ConfigurationSection section) {
        String id = section.getCurrentPath();
        String displayName = section.getString("displayName", id);
        String worldName = section.getString("world");
        ConfigurationSection pos1 = section.getConfigurationSection("pos1");
        ConfigurationSection pos2 = section.getConfigurationSection("pos2");
        int regenerateSeconds = section.getInt("regenerateSeconds", 0);
        boolean onlyFillAirWhenRegenerate = section.getBoolean("onlyFillAirWhenRegenerate", false);
        Material displayIcon = Material.getMaterial((String)section.getString("displayIcon", "STONE"));
        int requiredRankLevel = section.getInt("requiredRankLevel", 1);
        Location loc = section.getLocation("teleportLocation");
        if (id == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)worldName)) {
            return null;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return null;
        }
        if (pos1 == null) {
            return null;
        }
        if (pos2 == null) {
            return null;
        }
        if (displayIcon == null) {
            return null;
        }
        if (regenerateSeconds < 0) {
            regenerateSeconds = 3600;
            section.set("regenerateSeconds", (Object)regenerateSeconds);
        }
        BlockPos blockPos1 = new BlockPos(pos1.getInt("x"), pos1.getInt("y"), pos1.getInt("z"));
        BlockPos blockPos2 = new BlockPos(pos2.getInt("x"), pos2.getInt("y"), pos2.getInt("z"));
        HashMap<AddonBlock, Double> blockSpawnEntries = new HashMap<AddonBlock, Double>();
        ConfigurationSection blockSpawn = section.getConfigurationSection("blockSpawnEntries");
        if (blockSpawn != null) {
            for (String m : blockSpawn.getKeys(false)) {
                AddonBlock block = BlockAddon.getAddonBlock(m);
                if (block == null) continue;
                blockSpawnEntries.put(block, blockSpawn.getDouble(m, 1.0));
            }
        }
        List treasures = section.getStringList("treasures");
        List<Treasure> treasureList = treasures.stream().filter(treasure -> SuperMines.getInstance().getTreasureManager().getTreasure((String)treasure) != null).map(t -> SuperMines.getInstance().getTreasureManager().getTreasure((String)t)).toList();
        HashSet<String> allowedRankIds = new HashSet<String>();
        if (section.contains("allowedRankIds")) {
            allowedRankIds = new HashSet(section.getStringList("allowedRankIds"));
        }
        HashSet<Integer> resetWarningSeconds = new HashSet<Integer>();
        if (section.contains("resetWarningSeconds")) {
            resetWarningSeconds = new HashSet(section.getIntegerList("resetWarningSeconds"));
        }
        return new Mine(id, MiniMessage.miniMessage().deserialize((Object)displayName), displayIcon, world, new CuboidArea(blockPos1, blockPos2), blockSpawnEntries, regenerateSeconds, onlyFillAirWhenRegenerate, treasureList, requiredRankLevel, allowedRankIds, loc, resetWarningSeconds);
    }

    @Override
    protected void putObject(@NotNull ConfigurationSection section, Mine object) {
        section.set("displayName", MiniMessage.miniMessage().serialize(object.getDisplayName()));
        section.set("world", (Object)object.getWorld().getName());
        section.set("pos1", object.getArea().pos1().toMap());
        section.set("pos2", object.getArea().pos2().toMap());
        section.set("regenerateSeconds", (Object)object.getRegenerateSeconds());
        section.set("onlyFillAirWhenRegenerate", (Object)object.isOnlyFillAirWhenRegenerate());
        section.set("displayIcon", (Object)object.getDisplayIcon().toString());
        section.set("requiredRankLevel", (Object)object.getRequiredRankLevel());
        section.set("allowedRankIds", object.getAllowedRankIds().stream().toList());
        section.set("resetWarningSeconds", object.getWarningSeconds().stream().toList());
        ArrayList<String> treasures = new ArrayList<String>();
        for (Treasure treasure : object.getTreasures()) {
            treasures.add(treasure.getId());
        }
        section.set("treasures", treasures);
        HashMap<String, Double> blockSpawnEntries = new HashMap<String, Double>();
        for (Map.Entry<AddonBlock, Double> entry : object.getBlockSpawnEntries().entrySet()) {
            blockSpawnEntries.put(entry.getKey().toString(), entry.getValue());
        }
        ConfigurationSection configurationSection = section.createSection("blockSpawnEntries");
        for (Map.Entry entry : blockSpawnEntries.entrySet()) {
            configurationSection.set((String)entry.getKey(), entry.getValue());
        }
        if (object.getTeleportLocation() != null) {
            section.set("teleportLocation", (Object)object.getTeleportLocation());
        }
    }

    @Override
    public void saveAndClose() {
        for (Mine mine : this.mines.values()) {
            super.putObject(mine.getId(), mine);
        }
    }

    public void addMine(@NotNull Mine mine) {
        Preconditions.checkNotNull((Object)mine, (Object)"mine cannot be null");
        if (this.mines.containsKey(mine.getId())) {
            throw new IllegalArgumentException("mine with ID " + mine.getId() + " already exists");
        }
        this.mines.put(mine.getId(), mine);
        super.putObject(mine.getId(), mine);
    }

    @Nullable
    public Mine getMine(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return this.mines.get(id);
    }

    @Nullable
    public Mine getMine(@NotNull Location loc) {
        for (Mine mine : this.mines.values()) {
            boolean sameWorld = mine.getWorld() == loc.getWorld();
            boolean contains = mine.getArea().contains(BlockPos.fromLocation(loc));
            if (!sameWorld || !contains) continue;
            return mine;
        }
        return null;
    }

    public void removeMine(@NotNull String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"mine ID cannot be null or empty");
        this.mines.remove(id);
        super.remove(id);
    }

    public Collection<Mine> getAllMines() {
        return this.mines.values();
    }

    public Set<String> getAllMineIds() {
        return this.mines.keySet();
    }
}

