/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.listeners;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import io.github.lijinhong11.supermines.command.SuperMinesCommand;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WorldEditListener {
    private final WorldEdit we = WorldEdit.getInstance();

    public WorldEditListener() {
        this.we.getEventBus().register((Object)this);
    }

    @Subscribe
    public void onWorldEdit(EditSessionEvent e) {
        if (e.getActor() == null) {
            return;
        }
        CommandSender sender = BukkitAdapter.adapt((Actor)e.getActor());
        if (!(sender instanceof Player)) {
            return;
        }
        Player p = (Player)sender;
        if (e.getActor() == null) {
            return;
        }
        LocalSession sess = this.we.getSessionManager().get((SessionOwner)BukkitAdapter.adapt((Player)p));
        if (sess.getSelectionWorld() == null || !sess.isSelectionDefined(sess.getSelectionWorld())) {
            return;
        }
        World world = p.getWorld();
        try {
            Region sel = sess.getSelection(sess.getSelectionWorld());
            if (!(sel instanceof CuboidRegion)) {
                return;
            }
            CuboidRegion cub = (CuboidRegion)sel;
            BlockVector3 pos1 = cub.getMinimumPoint();
            BlockVector3 pos2 = cub.getMaximumPoint();
            Location loc1 = BukkitAdapter.adapt((World)world, (BlockVector3)pos1);
            Location loc2 = BukkitAdapter.adapt((World)world, (BlockVector3)pos2);
            SuperMinesCommand.handlePos(p, true, loc1);
            SuperMinesCommand.handlePos(p, false, loc2);
        }
        catch (IncompleteRegionException incompleteRegionException) {
            // empty catch block
        }
    }
}

