/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.sql.sentence;

import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.SQL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class TruncateSQL
extends SQL {
    private String tableName;
    private boolean restartIdentity;
    private boolean cascade;

    TruncateSQL() {
    }

    public TruncateSQL table(String tableName) {
        this.validateIdentifier(tableName);
        this.tableName = tableName;
        return this;
    }

    public TruncateSQL restartIdentity() {
        this.restartIdentity = true;
        return this;
    }

    public TruncateSQL cascade() {
        this.cascade = true;
        return this;
    }

    @Override
    public String getSql(DatabaseType type) {
        if (this.tableName == null) {
            throw new IllegalStateException("Table name must be specified");
        }
        this.sqlBuilder.setLength(0);
        if (type == DatabaseType.POSTGRESQL) {
            this.sqlBuilder.append("TRUNCATE TABLE ").append(this.tableName);
            if (this.restartIdentity) {
                this.sqlBuilder.append(" RESTART IDENTITY");
            }
            if (this.cascade) {
                this.sqlBuilder.append(" CASCADE");
            }
        } else {
            this.sqlBuilder.append("TRUNCATE TABLE ").append(this.tableName);
        }
        return this.sqlBuilder.toString();
    }

    @Override
    public PreparedStatement build(Connection connection, DatabaseType type) throws SQLException {
        return connection.prepareStatement(this.getSql(type));
    }
}

