/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.sql.sentence;

import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.sql.conditions.Condition;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.SQL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class InsertSQL
extends SQL {
    private final Map<String, Object> values = new LinkedHashMap<String, Object>();
    private final boolean upsert;
    private String table;
    private Condition whereCondition;
    private List<String> conflictKeys;

    InsertSQL(boolean upsert) {
        this.upsert = upsert;
    }

    public InsertSQL into(String table) {
        this.validateIdentifier(table);
        this.table = table;
        return this;
    }

    public InsertSQL value(String column, Object value) {
        this.validateIdentifier(column);
        this.values.put(column, value);
        return this;
    }

    public InsertSQL where(Condition condition) {
        this.whereCondition = condition;
        return this;
    }

    public InsertSQL conflictKeys(String ... keys) {
        this.conflictKeys = Arrays.asList(keys);
        return this;
    }

    @Override
    public String getSql(DatabaseType type) {
        this.sqlBuilder.setLength(0);
        this.parameters.clear();
        this.sqlBuilder.append("INSERT INTO ").append(this.table);
        if (!this.values.isEmpty()) {
            this.sqlBuilder.append(" (").append(String.join((CharSequence)", ", this.values.keySet())).append(") VALUES (").append(String.join((CharSequence)", ", Collections.nCopies(this.values.size(), "?"))).append(")");
            this.parameters.addAll(this.values.values());
        }
        if (!this.upsert) {
            this.appendWhere();
            return this.sqlBuilder.toString();
        }
        switch (type) {
            case SQLITE: 
            case POSTGRESQL: {
                if (this.conflictKeys == null || this.conflictKeys.isEmpty()) {
                    throw new IllegalStateException(String.valueOf((Object)type) + " UPSERT requires conflict keys");
                }
                this.sqlBuilder.append(" ON CONFLICT(").append(String.join((CharSequence)", ", this.conflictKeys)).append(") DO UPDATE SET ");
                this.sqlBuilder.append(this.values.keySet().stream().map(col -> col + " = excluded." + col).collect(Collectors.joining(", ")));
                break;
            }
            case MYSQL: 
            case MARIADB: {
                this.sqlBuilder.append(" ON DUPLICATE KEY UPDATE ");
                this.sqlBuilder.append(this.values.keySet().stream().map(col -> col + " = VALUES(" + col + ")").collect(Collectors.joining(", ")));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported database type: " + String.valueOf((Object)type));
            }
        }
        this.appendWhere();
        return this.sqlBuilder.toString();
    }

    private void appendWhere() {
        if (this.whereCondition != null) {
            this.sqlBuilder.append(" WHERE ").append(this.whereCondition.getSql());
            this.parameters.addAll(this.whereCondition.getParameters());
        }
    }
}

