/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.sql.sentence;

import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.SQL;

public final class DropSQL
extends SQL {
    private String name;
    private boolean ifExists;
    private boolean isTable;
    private boolean isIndex;
    private boolean isView;
    private String tableName;

    DropSQL() {
    }

    private DropSQL name(String name) {
        this.validateIdentifier(name);
        this.name = name;
        return this;
    }

    public DropSQL ifExists() {
        this.ifExists = true;
        return this;
    }

    public DropSQL table(String tableName) {
        this.isTable = true;
        this.isIndex = false;
        this.isView = false;
        return this.name(tableName);
    }

    public DropSQL index(String indexName) {
        this.isTable = false;
        this.isIndex = true;
        this.isView = false;
        return this.name(indexName);
    }

    public DropSQL view(String viewName) {
        this.isTable = false;
        this.isIndex = false;
        this.isView = true;
        return this.name(viewName);
    }

    public DropSQL fromTable(String tableName) {
        this.validateIdentifier(tableName);
        this.tableName = tableName;
        return this;
    }

    @Override
    public String getSql(DatabaseType type) {
        this.sqlBuilder.setLength(0);
        if (this.isTable) {
            this.buildDropTable();
        } else if (this.isIndex) {
            this.buildDropIndex();
        } else if (this.isView) {
            this.buildDropView();
        } else {
            throw new IllegalStateException("Neither table, index nor view specified");
        }
        return this.sqlBuilder.toString();
    }

    private void buildDropTable() {
        this.sqlBuilder.append("DROP TABLE ");
        this.appendIfExists();
        this.sqlBuilder.append(this.name);
    }

    private void buildDropIndex() {
        this.sqlBuilder.append("DROP INDEX ");
        this.appendIfExists();
        this.sqlBuilder.append(this.name);
        if (this.tableName != null) {
            this.sqlBuilder.append(" ON ").append(this.tableName);
        }
    }

    private void buildDropView() {
        this.sqlBuilder.append("DROP VIEW ");
        this.appendIfExists();
        this.sqlBuilder.append(this.name);
    }

    private void appendIfExists() {
        if (this.ifExists) {
            this.sqlBuilder.append("IF EXISTS ");
        }
    }
}

