/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.sql.sentence;

import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.SQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.SelectSQL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class CreateViewSQL
extends SQL {
    private String viewName;
    private String selectQuery;
    private SelectSQL selectSQL;
    private boolean orReplace;
    private boolean ifNotExists;

    CreateViewSQL() {
    }

    public CreateViewSQL view(String viewName) {
        this.validateIdentifier(viewName);
        this.viewName = viewName;
        return this;
    }

    public CreateViewSQL as(String selectQuery) {
        if (selectQuery == null || selectQuery.trim().isEmpty()) {
            throw new IllegalArgumentException("Select query cannot be null or empty");
        }
        this.selectQuery = selectQuery.trim();
        this.selectSQL = null;
        return this;
    }

    public CreateViewSQL as(SelectSQL selectSQL) {
        if (selectSQL == null) {
            throw new IllegalArgumentException("SelectSQL cannot be null");
        }
        this.selectSQL = selectSQL;
        this.selectQuery = null;
        return this;
    }

    public CreateViewSQL orReplace() {
        this.orReplace = true;
        return this;
    }

    public CreateViewSQL ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    @Override
    public String getSql(DatabaseType type) {
        String query;
        if (this.viewName == null) {
            throw new IllegalStateException("View name must be specified");
        }
        if (this.selectSQL != null) {
            query = this.selectSQL.getSql(type);
        } else if (this.selectQuery != null && !this.selectQuery.isEmpty()) {
            query = this.selectQuery;
        } else {
            throw new IllegalStateException("Select query must be specified");
        }
        this.sqlBuilder.setLength(0);
        this.sqlBuilder.append("CREATE ");
        if (this.orReplace) {
            if (type == DatabaseType.SQLITE) {
                throw new UnsupportedOperationException("SQLite does not support OR REPLACE. Use DROP VIEW then CREATE VIEW instead.");
            }
            this.sqlBuilder.append("OR REPLACE ");
        }
        this.sqlBuilder.append("VIEW ");
        if (this.ifNotExists && type == DatabaseType.POSTGRESQL) {
            this.sqlBuilder.append("IF NOT EXISTS ");
        }
        this.sqlBuilder.append(this.viewName).append(" AS ").append(query);
        return this.sqlBuilder.toString();
    }

    @Override
    public PreparedStatement build(Connection connection, DatabaseType type) throws SQLException {
        return connection.prepareStatement(this.getSql(type));
    }
}

