/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.sql.sentence;

import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.SQL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class CreateIndexSQL
extends SQL {
    private final List<String> columns = new ArrayList<String>();
    private String indexName;
    private String tableName;
    private boolean unique;
    private boolean ifNotExists;

    CreateIndexSQL() {
    }

    public CreateIndexSQL index(String indexName) {
        this.validateIdentifier(indexName);
        this.indexName = indexName;
        return this;
    }

    public CreateIndexSQL on(String tableName) {
        this.validateIdentifier(tableName);
        this.tableName = tableName;
        return this;
    }

    public CreateIndexSQL column(String columnName) {
        this.validateIdentifier(columnName);
        this.columns.add(columnName);
        return this;
    }

    public CreateIndexSQL columns(String ... columnNames) {
        for (String columnName : columnNames) {
            this.validateIdentifier(columnName);
            this.columns.add(columnName);
        }
        return this;
    }

    public CreateIndexSQL unique() {
        this.unique = true;
        return this;
    }

    public CreateIndexSQL ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    @Override
    public String getSql(DatabaseType type) {
        if (this.indexName == null) {
            throw new IllegalStateException("Index name must be specified");
        }
        if (this.tableName == null) {
            throw new IllegalStateException("Table name must be specified");
        }
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("At least one column must be specified");
        }
        this.sqlBuilder.setLength(0);
        if (this.unique) {
            this.sqlBuilder.append("CREATE UNIQUE INDEX ");
        } else {
            this.sqlBuilder.append("CREATE INDEX ");
        }
        if (this.ifNotExists && (type == DatabaseType.SQLITE || type == DatabaseType.POSTGRESQL)) {
            this.sqlBuilder.append("IF NOT EXISTS ");
        }
        this.sqlBuilder.append(this.indexName).append(" ON ").append(this.tableName).append(" (").append(String.join((CharSequence)", ", this.columns)).append(")");
        return this.sqlBuilder.toString();
    }

    @Override
    public PreparedStatement build(Connection connection, DatabaseType type) throws SQLException {
        return connection.prepareStatement(this.getSql(type));
    }
}

