/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.sql.sentence;

import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.SQL;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class AlterTableSQL
extends SQL {
    private final List<AlterOperation> operations = new ArrayList<AlterOperation>();
    private String tableName;

    AlterTableSQL() {
    }

    public AlterTableSQL table(String tableName) {
        this.validateIdentifier(tableName);
        this.tableName = tableName;
        return this;
    }

    public AlterTableSQL addColumn(String columnName, String dataType) {
        return this.addColumn(columnName, dataType, false, null);
    }

    public AlterTableSQL addColumn(String columnName, String dataType, boolean notNull, String defaultValue) {
        return this.addColumn(columnName, dataType, notNull, defaultValue, null);
    }

    public AlterTableSQL addColumn(String columnName, String dataType, boolean notNull, String defaultValue, String position) {
        this.validateIdentifier(columnName);
        this.operations.add(new AlterOperation(OperationType.ADD_COLUMN, columnName, dataType, notNull, defaultValue, position));
        return this;
    }

    public AlterTableSQL dropColumn(String columnName) {
        this.validateIdentifier(columnName);
        this.operations.add(new AlterOperation(OperationType.DROP_COLUMN, columnName, null, false, null, null));
        return this;
    }

    public AlterTableSQL modifyColumn(String columnName, String newDataType) {
        return this.modifyColumn(columnName, newDataType, false, null);
    }

    public AlterTableSQL modifyColumn(String columnName, String newDataType, boolean notNull, String defaultValue) {
        return this.modifyColumn(columnName, newDataType, notNull, defaultValue, null);
    }

    public AlterTableSQL modifyColumn(String columnName, String newDataType, boolean notNull, String defaultValue, String position) {
        this.validateIdentifier(columnName);
        if (position != null && !((String)position).equals("FIRST") && !((String)position).startsWith("AFTER ")) {
            this.validateIdentifier((String)position);
            position = "AFTER " + (String)position;
        }
        this.operations.add(new AlterOperation(OperationType.MODIFY_COLUMN, columnName, newDataType, notNull, defaultValue, (String)position));
        return this;
    }

    public AlterTableSQL moveColumnFirst(String columnName, String dataType) {
        return this.modifyColumn(columnName, dataType, false, null, "FIRST");
    }

    public AlterTableSQL moveColumnAfter(String columnName, String dataType, String afterColumnName) {
        return this.modifyColumn(columnName, dataType, false, null, afterColumnName);
    }

    public AlterTableSQL renameColumn(String oldColumnName, String newColumnName) {
        return this.renameColumn(oldColumnName, newColumnName, null);
    }

    public AlterTableSQL renameColumn(String oldColumnName, String newColumnName, String dataType) {
        this.validateIdentifier(oldColumnName);
        this.validateIdentifier(newColumnName);
        this.operations.add(new AlterOperation(OperationType.RENAME_COLUMN, oldColumnName, dataType, false, null, newColumnName));
        return this;
    }

    public AlterTableSQL addPrimaryKey(String ... columnNames) {
        for (String columnName : columnNames) {
            this.validateIdentifier(columnName);
        }
        this.operations.add(new AlterOperation(OperationType.ADD_PRIMARY_KEY, null, null, false, null, String.join((CharSequence)", ", columnNames)));
        return this;
    }

    public AlterTableSQL dropPrimaryKey() {
        this.operations.add(new AlterOperation(OperationType.DROP_PRIMARY_KEY, null, null, false, null, null));
        return this;
    }

    public AlterTableSQL addForeignKey(String columnName, String referenceTable, String referenceColumn) {
        return this.addForeignKey(columnName, referenceTable, referenceColumn, null);
    }

    public AlterTableSQL addForeignKey(String columnName, String referenceTable, String referenceColumn, String constraintName) {
        this.validateIdentifier(columnName);
        this.validateIdentifier(referenceTable);
        this.validateIdentifier(referenceColumn);
        if (constraintName != null) {
            this.validateIdentifier(constraintName);
        }
        String extraInfo = constraintName != null ? constraintName + ":" + referenceTable + "(" + referenceColumn + ")" : referenceTable + "(" + referenceColumn + ")";
        this.operations.add(new AlterOperation(OperationType.ADD_FOREIGN_KEY, columnName, null, false, null, extraInfo));
        return this;
    }

    public AlterTableSQL dropForeignKey(String constraintName) {
        this.validateIdentifier(constraintName);
        this.operations.add(new AlterOperation(OperationType.DROP_FOREIGN_KEY, null, null, false, null, constraintName));
        return this;
    }

    public AlterTableSQL addUnique(String ... columnNames) {
        for (String columnName : columnNames) {
            this.validateIdentifier(columnName);
        }
        this.operations.add(new AlterOperation(OperationType.ADD_UNIQUE, null, null, false, null, String.join((CharSequence)", ", columnNames)));
        return this;
    }

    public AlterTableSQL dropUnique(String constraintName) {
        this.validateIdentifier(constraintName);
        this.operations.add(new AlterOperation(OperationType.DROP_UNIQUE, null, null, false, null, constraintName));
        return this;
    }

    public AlterTableSQL renameTable(String newTableName) {
        this.validateIdentifier(newTableName);
        this.operations.add(new AlterOperation(OperationType.RENAME_TABLE, null, null, false, null, newTableName));
        return this;
    }

    @Override
    public String getSql(DatabaseType type) {
        if (this.tableName == null) {
            throw new IllegalStateException("Table name must be specified");
        }
        if (this.operations.isEmpty()) {
            throw new IllegalStateException("At least one alter operation must be specified");
        }
        this.sqlBuilder.setLength(0);
        if (type == DatabaseType.SQLITE && this.operations.size() > 1) {
            throw new UnsupportedOperationException("SQLite only supports one operation per ALTER TABLE statement");
        }
        for (int i = 0; i < this.operations.size(); ++i) {
            if (i > 0) {
                this.sqlBuilder.append("; ");
            }
            this.sqlBuilder.append("ALTER TABLE ").append(this.tableName).append(" ");
            this.buildOperation(this.operations.get(i), type);
        }
        return this.sqlBuilder.toString();
    }

    private void buildOperation(AlterOperation op, DatabaseType type) {
        switch (op.type.ordinal()) {
            case 0: {
                if ((type == DatabaseType.POSTGRESQL || type == DatabaseType.SQLITE) && op.extraInfo != null && (op.extraInfo.equals("FIRST") || op.extraInfo.startsWith("AFTER "))) {
                    throw new UnsupportedOperationException(String.valueOf((Object)type) + " does not support column positioning (FIRST/AFTER)");
                }
                this.sqlBuilder.append("ADD COLUMN ").append(op.columnName).append(" ").append(op.dataType);
                if (op.notNull) {
                    this.sqlBuilder.append(" NOT NULL");
                }
                if (op.defaultValue != null && !op.defaultValue.isEmpty()) {
                    this.sqlBuilder.append(" DEFAULT ").append(op.defaultValue);
                }
                if (op.extraInfo == null || type != DatabaseType.MYSQL && type != DatabaseType.MARIADB) break;
                if (op.extraInfo.equals("FIRST")) {
                    this.sqlBuilder.append(" FIRST");
                    break;
                }
                if (!op.extraInfo.startsWith("AFTER ")) break;
                String afterColumn = op.extraInfo.substring(6);
                this.validateIdentifier(afterColumn);
                this.sqlBuilder.append(" AFTER ").append(afterColumn);
                break;
            }
            case 1: {
                if (type == DatabaseType.SQLITE) {
                    throw new UnsupportedOperationException("SQLite does not support DROP COLUMN");
                }
                this.sqlBuilder.append("DROP COLUMN ").append(op.columnName);
                break;
            }
            case 2: {
                if (type == DatabaseType.SQLITE) {
                    throw new UnsupportedOperationException("SQLite does not support MODIFY COLUMN");
                }
                if (type == DatabaseType.POSTGRESQL) {
                    if (op.extraInfo != null && (op.extraInfo.equals("FIRST") || op.extraInfo.startsWith("AFTER "))) {
                        throw new UnsupportedOperationException("PostgreSQL does not support column positioning (FIRST/AFTER)");
                    }
                    ArrayList<CallSite> alterClauses = new ArrayList<CallSite>();
                    if (op.dataType != null) {
                        alterClauses.add((CallSite)((Object)("ALTER COLUMN " + op.columnName + " TYPE " + op.dataType)));
                    }
                    if (op.notNull) {
                        alterClauses.add((CallSite)((Object)("ALTER COLUMN " + op.columnName + " SET NOT NULL")));
                    }
                    if (op.defaultValue != null) {
                        if (op.defaultValue.isEmpty()) {
                            alterClauses.add((CallSite)((Object)("ALTER COLUMN " + op.columnName + " DROP DEFAULT")));
                        } else {
                            alterClauses.add((CallSite)((Object)("ALTER COLUMN " + op.columnName + " SET DEFAULT " + op.defaultValue)));
                        }
                    }
                    if (alterClauses.isEmpty()) {
                        throw new IllegalStateException("MODIFY COLUMN requires at least one modification (dataType, notNull, or defaultValue)");
                    }
                    this.sqlBuilder.append(String.join((CharSequence)", ", alterClauses));
                    break;
                }
                this.sqlBuilder.append("MODIFY COLUMN ").append(op.columnName);
                if (op.dataType != null) {
                    this.sqlBuilder.append(" ").append(op.dataType);
                }
                if (op.notNull) {
                    this.sqlBuilder.append(" NOT NULL");
                }
                if (op.defaultValue != null && !op.defaultValue.isEmpty()) {
                    this.sqlBuilder.append(" DEFAULT ").append(op.defaultValue);
                }
                if (op.extraInfo == null) break;
                if (op.extraInfo.equals("FIRST")) {
                    this.sqlBuilder.append(" FIRST");
                    break;
                }
                if (!op.extraInfo.startsWith("AFTER ")) break;
                String afterColumn = op.extraInfo.substring(6);
                this.validateIdentifier(afterColumn);
                this.sqlBuilder.append(" AFTER ").append(afterColumn);
                break;
            }
            case 3: {
                if (type == DatabaseType.SQLITE) {
                    this.sqlBuilder.append("RENAME COLUMN ").append(op.columnName).append(" TO ").append(op.extraInfo);
                    break;
                }
                if (type == DatabaseType.POSTGRESQL) {
                    this.sqlBuilder.append("RENAME COLUMN ").append(op.columnName).append(" TO ").append(op.extraInfo);
                    break;
                }
                this.sqlBuilder.append("CHANGE COLUMN ").append(op.columnName).append(" ").append(op.extraInfo);
                if (op.dataType != null) {
                    this.sqlBuilder.append(" ").append(op.dataType);
                    break;
                }
                throw new IllegalStateException("MySQL/MariaDB RENAME COLUMN requires data type. Use renameColumn(oldName, newName, dataType) instead.");
            }
            case 5: {
                this.sqlBuilder.append("ADD PRIMARY KEY (").append(op.extraInfo).append(")");
                break;
            }
            case 6: {
                if (type == DatabaseType.SQLITE) {
                    throw new UnsupportedOperationException("SQLite does not support DROP PRIMARY KEY");
                }
                this.sqlBuilder.append("DROP PRIMARY KEY");
                break;
            }
            case 4: {
                this.sqlBuilder.append("RENAME TO ").append(op.extraInfo);
                break;
            }
            case 7: {
                String constraintName = null;
                String reference = op.extraInfo;
                if (op.extraInfo != null && op.extraInfo.contains(":")) {
                    int colonIndex = op.extraInfo.indexOf(58);
                    constraintName = op.extraInfo.substring(0, colonIndex);
                    reference = op.extraInfo.substring(colonIndex + 1);
                }
                if (constraintName != null) {
                    this.sqlBuilder.append("ADD CONSTRAINT ").append(constraintName).append(" ");
                }
                this.sqlBuilder.append("FOREIGN KEY (").append(op.columnName).append(") REFERENCES ").append(reference);
                break;
            }
            case 8: {
                if (type == DatabaseType.SQLITE) {
                    throw new UnsupportedOperationException("SQLite does not support DROP FOREIGN KEY");
                }
                if (type == DatabaseType.POSTGRESQL) {
                    this.sqlBuilder.append("DROP CONSTRAINT ").append(op.extraInfo);
                    break;
                }
                this.sqlBuilder.append("DROP FOREIGN KEY ").append(op.extraInfo);
                break;
            }
            case 9: {
                this.sqlBuilder.append("ADD UNIQUE (").append(op.extraInfo).append(")");
                break;
            }
            case 10: {
                if (type == DatabaseType.SQLITE) {
                    throw new UnsupportedOperationException("SQLite does not support DROP UNIQUE");
                }
                if (type == DatabaseType.POSTGRESQL) {
                    this.sqlBuilder.append("DROP CONSTRAINT ").append(op.extraInfo);
                    break;
                }
                this.sqlBuilder.append("DROP INDEX ").append(op.extraInfo);
            }
        }
    }

    @Override
    public PreparedStatement build(Connection connection, DatabaseType type) throws SQLException {
        return connection.prepareStatement(this.getSql(type));
    }

    private record AlterOperation(OperationType type, String columnName, String dataType, boolean notNull, String defaultValue, String extraInfo) {
    }

    private static enum OperationType {
        ADD_COLUMN,
        DROP_COLUMN,
        MODIFY_COLUMN,
        RENAME_COLUMN,
        RENAME_TABLE,
        ADD_PRIMARY_KEY,
        DROP_PRIMARY_KEY,
        ADD_FOREIGN_KEY,
        DROP_FOREIGN_KEY,
        ADD_UNIQUE,
        DROP_UNIQUE;

    }
}

