/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.sql.conditions;

import io.github.lijinhong11.supermines.libraries.database.sql.conditions.Condition;
import java.util.ArrayList;
import java.util.List;

class AppendableCondition
implements Condition {
    private final Condition[] multi;
    private final String operator;

    public AppendableCondition(Condition[] multi, String operator) {
        this.multi = multi;
        this.operator = operator;
    }

    @Override
    public String getSql() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("(");
        for (Condition condition : this.multi) {
            sqlBuilder.append(condition.getSql());
            if (condition == this.multi[this.multi.length - 1]) continue;
            sqlBuilder.append(" ").append(this.operator).append(" ");
        }
        sqlBuilder.append(")");
        return sqlBuilder.toString();
    }

    @Override
    public List<Object> getParameters() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Condition condition : this.multi) {
            params.addAll(condition.getParameters());
        }
        System.out.println("params count:" + params.size());
        return params;
    }
}

