/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.postgre.shaded.com.ongres.scram.common.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Preconditions {
    private Preconditions() {
        throw new IllegalStateException("Utility class");
    }

    @NotNull
    public static <T> T checkNotNull(@Nullable T value, @NotNull String valueName) {
        if (null == value) {
            throw new IllegalArgumentException("Null value for '" + valueName + "'");
        }
        return value;
    }

    @NotNull
    public static <T> T castNonNull(@Nullable T ref) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument";
        return ref;
    }

    @NotNull
    public static String checkNotEmpty(@NotNull String value, @NotNull String valueName) {
        if (Preconditions.checkNotNull(value, valueName).isEmpty()) {
            throw new IllegalArgumentException("The value for '" + valueName + "' must not be empty");
        }
        return value;
    }

    public static char @NotNull [] checkNotEmpty(char @NotNull [] value, @NotNull String valueName) {
        if (Preconditions.checkNotNull(value, valueName).length == 0) {
            throw new IllegalArgumentException("The value for '" + valueName + "' must not be empty");
        }
        return value;
    }

    public static void checkArgument(boolean check, @NotNull String valueName) {
        if (!check) {
            throw new IllegalArgumentException("Argument '" + valueName + "' is not valid");
        }
    }

    public static void checkArgument(boolean check, @NotNull String valueName, @NotNull String errMsg) {
        if (!check) {
            throw new IllegalArgumentException("Argument '" + valueName + "' is not valid, " + errMsg);
        }
    }

    public static int gt0(int value, @NotNull String valueName) {
        if (value <= 0) {
            throw new IllegalArgumentException("'" + valueName + "' must be positive, was: " + value);
        }
        return value;
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }
}

