/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication;

import io.github.lijinhong11.supermines.libraries.database.libs.postgre.core.BaseConnection;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.PGReplicationConnection;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.ChainedCreateReplicationSlotBuilder;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.ChainedStreamBuilder;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.ReplicationCreateSlotBuilder;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.ReplicationStreamBuilder;
import java.sql.SQLException;
import java.sql.Statement;

public class PGReplicationConnectionImpl
implements PGReplicationConnection {
    private final BaseConnection connection;

    public PGReplicationConnectionImpl(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    public ChainedStreamBuilder replicationStream() {
        return new ReplicationStreamBuilder(this.connection);
    }

    @Override
    public ChainedCreateReplicationSlotBuilder createReplicationSlot() {
        return new ReplicationCreateSlotBuilder(this.connection);
    }

    @Override
    public void dropReplicationSlot(String slotName) throws SQLException {
        if (slotName == null || slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slot name can't be null or empty");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DROP_REPLICATION_SLOT " + slotName);
        }
    }
}

