/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.postgre.gss;

import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.ByteConverter;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.internal.Nullness;
import java.io.IOException;
import java.io.InputStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public class GSSInputStream
extends InputStream {
    private final GSSContext gssContext;
    private final MessageProp messageProp;
    private final InputStream wrapped;
    private byte[] encrypted = new byte[16384];
    private int encryptedPos;
    private int encryptedLength;
    private byte @Nullable [] unencrypted;
    private int unencryptedPos;
    private final byte[] int4Buf = new byte[4];
    private int lenPos;
    private final byte[] int1Buf = new byte[1];

    public GSSInputStream(InputStream wrapped, GSSContext gssContext, MessageProp messageProp) {
        this.wrapped = wrapped;
        this.gssContext = gssContext;
        this.messageProp = messageProp;
    }

    @Override
    public int read() throws IOException {
        int res = 0;
        while (res == 0) {
            res = this.read(this.int1Buf);
        }
        return res == -1 ? -1 : this.int1Buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int pos, int len) throws IOException {
        int n = 0;
        do {
            int res;
            if (this.lenPos < 4 && (res = this.readLength()) <= 0) {
                return n == 0 ? res : n;
            }
            if (this.encryptedPos < this.encryptedLength && (res = this.readEncryptedBytesAndUnwrap()) <= 0) {
                return n == 0 ? res : n;
            }
            byte[] unencrypted = Nullness.castNonNull(this.unencrypted);
            int copyLength = Math.min(len - n, unencrypted.length - this.unencryptedPos);
            System.arraycopy(unencrypted, this.unencryptedPos, buffer, pos + n, copyLength);
            this.unencryptedPos += copyLength;
            n += copyLength;
            if (this.unencryptedPos != unencrypted.length) continue;
            this.lenPos = 0;
            this.encryptedPos = 0;
            this.unencrypted = null;
        } while (n < len && this.wrapped.available() > 0);
        return n;
    }

    private int readLength() throws IOException {
        block3: {
            do {
                int res;
                if ((res = this.wrapped.read(this.int4Buf, this.lenPos, 4 - this.lenPos)) == -1) {
                    return -1;
                }
                this.lenPos += res;
                if (this.lenPos == 4) break block3;
            } while (this.wrapped.available() > 0);
            return 0;
        }
        this.encryptedLength = ByteConverter.int4(this.int4Buf, 0);
        if (this.encrypted.length < this.encryptedLength) {
            this.encrypted = new byte[this.encryptedLength];
        }
        return 1;
    }

    private int readEncryptedBytesAndUnwrap() throws IOException {
        block4: {
            do {
                int res;
                if ((res = this.wrapped.read(this.encrypted, this.encryptedPos, this.encryptedLength - this.encryptedPos)) == -1) {
                    return -1;
                }
                this.encryptedPos += res;
                if (this.encryptedPos == this.encryptedLength) break block4;
            } while (this.wrapped.available() > 0);
            return 0;
        }
        try {
            this.unencrypted = this.gssContext.unwrap(this.encrypted, 0, this.encryptedLength, this.messageProp);
        }
        catch (GSSException e) {
            throw new IOException(e);
        }
        this.unencryptedPos = 0;
        return 1;
    }
}

