/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.postgre.core;

import io.github.lijinhong11.supermines.libraries.database.libs.postgre.PGProperty;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.ssl.LibPQFactory;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.GT;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.ObjectFactory;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.PSQLException;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.PSQLState;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SocketFactoryFactory {
    public static SocketFactory getSocketFactory(Properties info) throws PSQLException {
        String socketFactoryClassName = PGProperty.SOCKET_FACTORY.getOrDefault(info);
        if (socketFactoryClassName == null) {
            return SocketFactory.getDefault();
        }
        try {
            return ObjectFactory.instantiate(SocketFactory.class, socketFactoryClassName, info, true, PGProperty.SOCKET_FACTORY_ARG.getOrDefault(info));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The SocketFactory class provided {0} could not be instantiated.", socketFactoryClassName), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(Properties info) throws PSQLException {
        String classname = PGProperty.SSL_FACTORY.getOrDefault(info);
        if (classname == null || "io.github.lijinhong11.supermines.libraries.database.libs.postgre.ssl.jdbc4.LibPQFactory".equals(classname) || "io.github.lijinhong11.supermines.libraries.database.libs.postgre.ssl.LibPQFactory".equals(classname)) {
            return new LibPQFactory(info);
        }
        try {
            return ObjectFactory.instantiate(SSLSocketFactory.class, classname, info, true, PGProperty.SSL_FACTORY_ARG.getOrDefault(info));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }
}

