/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.postgre.core;

import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.GT;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.PSQLException;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.PSQLState;
import java.sql.SQLException;

public enum ProtocolVersion {
    v3_0(3, 0),
    v3_2(3, 2);

    private final int major;
    private final int minor;
    private static final ProtocolVersion[] values;

    private ProtocolVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public static ProtocolVersion fromMajorMinor(int major, int minor) throws SQLException {
        for (ProtocolVersion version : values) {
            if (version.major != major || version.minor != minor) continue;
            return version;
        }
        throw new PSQLException(GT.tr("Invalid version number major: {0}, minor: {1}", major, minor), PSQLState.NOT_IMPLEMENTED);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    static {
        values = ProtocolVersion.values();
    }
}

