/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.codec;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ColumnDecoder;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Context;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.DataType;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ReadableByteBuf;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Writer;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.util.MutableInt;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.Codec;
import java.io.IOException;
import java.sql.SQLDataException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;

public class TimeCodec
implements Codec<Time> {
    public static final TimeCodec INSTANCE = new TimeCodec();
    public static final LocalDate EPOCH_DATE = LocalDate.of(1970, 1, 1);
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TIME, new DataType[]{DataType.DATETIME, DataType.TIMESTAMP, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Time.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(Time.class) && !type.equals(Date.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Time;
    }

    @Override
    public Time decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return column.decodeTimeText(buf, length, cal, context);
    }

    @Override
    public Time decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar calParam, Context context) throws SQLDataException {
        return column.decodeTimeBinary(buf, length, calParam, context);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object val, Calendar providedCal, Long maxLen) throws IOException {
        Calendar cal = providedCal == null ? Calendar.getInstance() : providedCal;
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
        sdf.setTimeZone(cal.getTimeZone());
        String dateString = sdf.format(val);
        encoder.writeByte(39);
        encoder.writeAscii(dateString);
        encoder.writeByte(39);
    }

    @Override
    public int getApproximateTextProtocolLength(Object value, Long maxLen) {
        return 14;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeBinary(Writer encoder, Context context, Object value, Calendar providedCal, Long maxLength) throws IOException {
        if (providedCal == null) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.setTime((Time)value);
            cal.set(5, 1);
            if (cal.get(14) > 0) {
                encoder.writeByte(12);
                encoder.writeByte(0);
                encoder.writeInt(0);
                encoder.writeByte((byte)cal.get(11));
                encoder.writeByte((byte)cal.get(12));
                encoder.writeByte((byte)cal.get(13));
                encoder.writeInt(cal.get(14) * 1000);
            } else {
                encoder.writeByte(8);
                encoder.writeByte(0);
                encoder.writeInt(0);
                encoder.writeByte((byte)cal.get(11));
                encoder.writeByte((byte)cal.get(12));
                encoder.writeByte((byte)cal.get(13));
            }
        } else {
            Calendar calendar = providedCal;
            synchronized (calendar) {
                providedCal.clear();
                providedCal.setTime((Time)value);
                providedCal.set(5, 1);
                if (providedCal.get(14) > 0) {
                    encoder.writeByte(12);
                    encoder.writeByte(0);
                    encoder.writeInt(0);
                    encoder.writeByte((byte)providedCal.get(11));
                    encoder.writeByte((byte)providedCal.get(12));
                    encoder.writeByte((byte)providedCal.get(13));
                    encoder.writeInt(providedCal.get(14) * 1000);
                } else {
                    encoder.writeByte(8);
                    encoder.writeByte(0);
                    encoder.writeInt(0);
                    encoder.writeByte((byte)providedCal.get(11));
                    encoder.writeByte((byte)providedCal.get(12));
                    encoder.writeByte((byte)providedCal.get(13));
                }
            }
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.TIME.get();
    }
}

