/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.client;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Context;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Writer;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.util.Parameter;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.util.Parameters;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.ClientMessage;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.client.RedoableClientMessage;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.codec.ByteArrayCodec;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.util.ClientParser;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public final class QueryWithParametersPacket
implements RedoableClientMessage {
    private final String preSqlCmd;
    private final ClientParser parser;
    private final InputStream localInfileInputStream;
    private Parameters parameters;

    public QueryWithParametersPacket(String preSqlCmd, ClientParser parser, Parameters parameters, InputStream localInfileInputStream) {
        this.preSqlCmd = preSqlCmd;
        this.parser = parser;
        this.parameters = parameters;
        this.localInfileInputStream = localInfileInputStream;
    }

    @Override
    public void ensureReplayable(Context context) throws IOException, SQLException {
        int parameterCount = this.parameters.size();
        for (int i = 0; i < parameterCount; ++i) {
            Parameter p = this.parameters.get(i);
            if (p.isNull() || !p.canEncodeLongData()) continue;
            this.parameters.set(i, new io.github.lijinhong11.supermines.libraries.database.libs.mariadb.codec.Parameter<byte[]>(ByteArrayCodec.INSTANCE, p.encodeData()));
        }
    }

    @Override
    public void saveParameters() {
        this.parameters = this.parameters.clone();
    }

    @Override
    public int encode(Writer encoder, Context context) throws IOException, SQLException {
        encoder.initPacket();
        encoder.writeByte(3);
        if (this.preSqlCmd != null) {
            encoder.writeAscii(this.preSqlCmd);
        }
        if (this.parser.getParamPositions().isEmpty()) {
            encoder.writeBytes(this.parser.getQuery());
        } else {
            int pos = 0;
            for (int i = 0; i < this.parser.getParamPositions().size(); ++i) {
                int paramPos = this.parser.getParamPositions().get(i);
                encoder.writeBytes(this.parser.getQuery(), pos, paramPos - pos);
                pos = paramPos + 1;
                this.parameters.get(i).encodeText(encoder, context);
            }
            encoder.writeBytes(this.parser.getQuery(), pos, this.parser.getQuery().length - pos);
        }
        encoder.flush();
        return 1;
    }

    @Override
    public int batchUpdateLength() {
        return 1;
    }

    @Override
    public boolean validateLocalFileName(String fileName, Context context) {
        return ClientMessage.validateLocalFileName(this.parser.getSql(), this.parameters, fileName, context);
    }

    @Override
    public InputStream getLocalInfileInputStream() {
        return this.localInfileInputStream;
    }

    @Override
    public String description() {
        return this.parser.getSql();
    }
}

