/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.impl;

import com.sun.jna.platform.win32.Kernel32;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

public class NamedPipeSocket
extends Socket {
    private final String host;
    private final String name;
    private RandomAccessFile file;
    private InputStream is;
    private OutputStream os;

    public NamedPipeSocket(String host, String name) {
        this.host = host;
        this.name = name;
    }

    @Override
    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        String filename = String.format("\\\\%s\\pipe\\%s", this.host == null || this.host.equals("localhost") ? "." : this.host, this.name);
        int usedTimeout = timeout == 0 ? 100 : timeout;
        long initialNano = System.nanoTime();
        while (true) {
            try {
                this.file = new RandomAccessFile(filename, "rw");
                break;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    Kernel32.INSTANCE.WaitNamedPipe(filename, timeout);
                    this.file = new RandomAccessFile(filename, "rw");
                }
                catch (Throwable cle) {
                    if (System.nanoTime() - initialNano > TimeUnit.MILLISECONDS.toNanos(usedTimeout)) {
                        if (timeout == 0) {
                            throw new FileNotFoundException(fileNotFoundException.getMessage() + "\nplease consider set connectTimeout option, so connection can retry having access to named pipe. \n(Named pipe can throw ERROR_PIPE_BUSY error)");
                        }
                        throw fileNotFoundException;
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(5L);
                    }
                    catch (InterruptedException interrupted) {
                        IOException ioException = new IOException("Interruption during connection to named pipe");
                        ioException.initCause(interrupted);
                        throw ioException;
                    }
                }
            }
        }
        this.is = new InputStream(){

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                return NamedPipeSocket.this.file.read(bytes, off, len);
            }

            @Override
            public int read() throws IOException {
                return NamedPipeSocket.this.file.read();
            }

            @Override
            public int read(byte[] bytes) throws IOException {
                return NamedPipeSocket.this.file.read(bytes);
            }
        };
        this.os = new OutputStream(){

            @Override
            public void write(byte[] bytes, int off, int len) throws IOException {
                NamedPipeSocket.this.file.write(bytes, off, len);
            }

            @Override
            public void write(int value) {
            }
        };
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void setTcpNoDelay(boolean bool) {
    }

    @Override
    public void setKeepAlive(boolean bool) {
    }

    @Override
    public void setSoLinger(boolean bool, int value) {
    }

    @Override
    public void setSoTimeout(int timeout) {
    }

    @Override
    public void shutdownOutput() {
    }
}

