/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.context;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.Configuration;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.HostAddress;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.PrepareCache;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.context.BaseContext;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.impl.TransactionSaver;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.export.ExceptionFactory;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.ClientMessage;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.client.RedoableClientMessage;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.server.InitialHandshakePacket;

public class RedoContext
extends BaseContext {
    private final TransactionSaver transactionSaver;

    public RedoContext(HostAddress hostAddress, InitialHandshakePacket handshake, long clientCapabilities, Configuration conf, ExceptionFactory exceptionFactory, PrepareCache prepareCache, Boolean loopbackAddress) {
        super(hostAddress, handshake, clientCapabilities, conf, exceptionFactory, prepareCache, loopbackAddress);
        this.transactionSaver = new TransactionSaver(conf.transactionReplaySize());
    }

    @Override
    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
        if ((serverStatus & 1) == 0) {
            this.transactionSaver.clear();
        }
    }

    public void saveRedo(ClientMessage msg) {
        if (msg instanceof RedoableClientMessage) {
            RedoableClientMessage redoMsg = (RedoableClientMessage)msg;
            redoMsg.saveParameters();
            this.transactionSaver.add(redoMsg);
        }
    }

    public void saveRedo(ClientMessage[] msgs) {
        for (ClientMessage msg : msgs) {
            this.saveRedo(msg);
        }
    }

    public TransactionSaver getTransactionSaver() {
        return this.transactionSaver;
    }
}

