/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.impl;

import io.github.lijinhong11.supermines.libraries.database.DatabaseParameters;
import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.impl.AbstractDatabaseConnection;
import io.github.lijinhong11.supermines.libraries.database.libs.hikari.HikariConfig;
import io.github.lijinhong11.supermines.libraries.database.libs.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class PostgreSQLConnection
extends AbstractDatabaseConnection {
    private static final String JDBC_URL_FORMAT = "jdbc:postgresql://%s:%d/%s?useSSL=false&serverTimezone=UTC";
    private static final String JDBC_DRIVER_CLASS_NAME = "io.github.lijinhong11.supermines.libraries.database.libs.postgre.Driver";
    private final HikariDataSource dataSource;

    public PostgreSQLConnection(String host, int port, String database, String username, String password, DatabaseParameters parameters) {
        HikariConfig cfg = new HikariConfig();
        cfg.setJdbcUrl(JDBC_URL_FORMAT.formatted(host, port, database));
        cfg.setDriverClassName(JDBC_DRIVER_CLASS_NAME);
        cfg.setUsername(username);
        cfg.setPassword(password);
        cfg.setMaximumPoolSize(parameters.getMaxPoolSize());
        cfg.setAutoCommit(true);
        cfg.setIdleTimeout(parameters.getIdleTimeout());
        cfg.setKeepaliveTime(parameters.getMaxKeepAlive());
        try (HikariDataSource dataSource = new HikariDataSource(cfg);){
            this.dataSource = dataSource;
        }
    }

    @Override
    Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    @NotNull
    public DatabaseType getType() {
        return DatabaseType.POSTGRESQL;
    }

    @Override
    public void close() {
        this.dataSource.close();
    }
}

