/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.impl;

import io.github.lijinhong11.supermines.libraries.database.DatabaseConnection;
import io.github.lijinhong11.supermines.libraries.database.DatabaseParameters;
import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.impl.MariaDBConnection;
import io.github.lijinhong11.supermines.libraries.database.impl.MySQLConnection;
import io.github.lijinhong11.supermines.libraries.database.impl.PostgreSQLConnection;
import io.github.lijinhong11.supermines.libraries.database.impl.SQLiteConnection;
import java.io.File;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class DatabaseConnections {
    private DatabaseConnections() {
    }

    @Contract(value="null, _, _, _, _, _, _, _ -> fail")
    public static DatabaseConnection createByType(DatabaseType type, @Nullable File sqlite, String host, int port, String database, String username, String password, DatabaseParameters parameters) {
        if (type == null) {
            throw new RuntimeException(new NullPointerException("database type"));
        }
        switch (type) {
            case POSTGRESQL: {
                return DatabaseConnections.postgresql(host, port, database, username, password, parameters);
            }
            case SQLITE: {
                if (sqlite == null) {
                    throw new RuntimeException(new NullPointerException("sqlite database file"));
                }
                return DatabaseConnections.sqlite(sqlite.getAbsolutePath(), parameters);
            }
            case MARIADB: {
                return DatabaseConnections.mariadb(host, port, database, username, password, parameters);
            }
            case MYSQL: {
                return DatabaseConnections.mysql(host, port, database, username, password, parameters);
            }
        }
        return null;
    }

    public static DatabaseConnection sqlite(String file, DatabaseParameters parameters) {
        return new SQLiteConnection(file, parameters);
    }

    public static DatabaseConnection mysql(String host, int port, String database, String username, String password, DatabaseParameters parameters) {
        return new MySQLConnection(host, port, database, username, password, parameters);
    }

    public static DatabaseConnection mariadb(String host, int port, String database, String username, String password, DatabaseParameters parameters) {
        return new MariaDBConnection(host, port, database, username, password, parameters);
    }

    public static DatabaseConnection postgresql(String host, int port, String database, String username, String password, DatabaseParameters parameters) {
        return new PostgreSQLConnection(host, port, database, username, password, parameters);
    }
}

