/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.integrates.placeholders;

import io.github.lijinhong11.supermines.SuperMines;
import io.github.lijinhong11.supermines.api.data.PlayerData;
import io.github.lijinhong11.supermines.api.mine.Mine;
import io.github.lijinhong11.supermines.utils.NumberUtils;
import io.github.miniplaceholders.api.Expansion;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class MiniPlaceholderExtension {
    public static void register() {
        Expansion expansion = (Expansion)Expansion.builder((String)"supermines").version(SuperMines.getInstance().getDescription().getVersion()).author("mmmjjkx (lijinhong11)").audiencePlaceholder("bestRank", (a, args, ctx) -> {
            if (args.hasNext()) {
                String playerName = args.pop().value();
                OfflinePlayer p2 = Bukkit.getOfflinePlayer((String)playerName);
                PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(p2.getUniqueId());
                return Tag.selfClosingInserting((Component)data.getRank().getBestValuedRank().getDisplayName());
            }
            OfflinePlayer p = (OfflinePlayer)a;
            PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(p.getUniqueId());
            return Tag.selfClosingInserting((Component)data.getRank().getBestValuedRank().getDisplayName());
        }).audiencePlaceholder("biggestRankLevel", (a, args, ctx) -> {
            if (args.hasNext()) {
                String playerName = args.pop().value();
                OfflinePlayer p2 = Bukkit.getOfflinePlayer((String)playerName);
                PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(p2.getUniqueId());
                return Tag.selfClosingInserting((Component)Component.text((int)data.getRank().getBiggestRankLevel()));
            }
            OfflinePlayer p = (OfflinePlayer)a;
            PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(p.getUniqueId());
            return Tag.selfClosingInserting((Component)Component.text((int)data.getRank().getBiggestRankLevel()));
        }).audiencePlaceholder("minedBlocks", (a, args, ctx) -> {
            if (args.hasNext()) {
                String playerName = args.pop().value();
                OfflinePlayer p2 = Bukkit.getOfflinePlayer((String)playerName);
                PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(p2.getUniqueId());
                return Tag.selfClosingInserting((Component)Component.text((int)data.getMinedBlocks()));
            }
            OfflinePlayer p = (OfflinePlayer)a;
            PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(p.getUniqueId());
            return Tag.selfClosingInserting((Component)Component.text((int)data.getMinedBlocks()));
        }).audiencePlaceholder("hasrank", (a, args, ctx) -> {
            if (!args.hasNext()) {
                return Tag.selfClosingInserting((Component)Component.text((String)"NO_RANK_ID_INPUT"));
            }
            String rankId = args.pop().value();
            OfflinePlayer player = (OfflinePlayer)a;
            if (args.hasNext()) {
                player = Bukkit.getOfflinePlayer((String)args.pop().value());
            }
            PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(player.getUniqueId());
            return Tag.selfClosingInserting((Component)Component.text((boolean)data.getRank().matchRank(rankId)));
        }).globalPlaceholder("mine_blocksbroken", (args, ctx) -> {
            String mineId = args.popOr("missing_mine_id").value();
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                return Tag.selfClosingInserting((Component)Component.text((String)"MINE_NOT_FOUND"));
            }
            return Tag.selfClosingInserting((Component)Component.text((int)mine.getBlocksBroken()));
        }).globalPlaceholder("mine_resettime", (args, ctx) -> {
            String mineId = args.popOr("missing_mine_id").value();
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                return Tag.selfClosingInserting((Component)Component.text((String)"MINE_NOT_FOUND"));
            }
            int millis = (int)(SuperMines.getInstance().getTaskMaker().getMineUntilResetTime(mine) * 1000L);
            return Tag.selfClosingInserting((Component)Component.text((String)NumberUtils.formatSeconds(null, millis)));
        }).globalPlaceholder("mine_blockpercent", (args, ctx) -> {
            String mineId = args.popOr("missing_mine_id").value();
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                return Tag.selfClosingInserting((Component)Component.text((String)"MINE_NOT_FOUND"));
            }
            int broken = mine.getBlocksBroken();
            int total = mine.getArea().volume();
            double percent = total == 0 ? 100.0 : (double)(total - broken) / (double)total * 100.0;
            return Tag.selfClosingInserting((Component)Component.text((String)String.format("%.2f", percent)));
        }).globalPlaceholder("mine_minedpercent", (args, ctx) -> {
            String mineId = args.popOr("missing_mine_id").value();
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                return Tag.selfClosingInserting((Component)Component.text((String)"MINE_NOT_FOUND"));
            }
            int broken = mine.getBlocksBroken();
            int total = mine.getArea().volume();
            double percent = total == 0 ? 0.0 : (double)broken / (double)total * 100.0;
            return Tag.selfClosingInserting((Component)Component.text((String)String.format("%.2f", percent)));
        }).globalPlaceholder("totalblocks", (args, ctx) -> {
            String mineId = args.popOr("missing_mine_id").value();
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                return Tag.selfClosingInserting((Component)Component.text((String)"MINE_NOT_FOUND"));
            }
            return Tag.selfClosingInserting((Component)Component.text((int)mine.getArea().volume()));
        }).build();
        expansion.register();
    }
}

