/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.integrates.block;

import io.github.lijinhong11.supermines.integrates.block.AddonBlock;
import io.github.lijinhong11.supermines.integrates.block.ItemsAdderBlockAddon;
import io.github.lijinhong11.supermines.integrates.block.MinecraftBlockAddon;
import io.github.lijinhong11.supermines.integrates.block.NexoBlockAddon;
import io.github.lijinhong11.supermines.integrates.block.OraxenBlockAddon;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public abstract class BlockAddon {
    private static final List<BlockAddon> blockAddons = new ArrayList<BlockAddon>();

    public static void init() {
        if (Bukkit.getPluginManager().isPluginEnabled("ItemsAdder")) {
            blockAddons.add(new ItemsAdderBlockAddon());
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Nexo")) {
            blockAddons.add(new NexoBlockAddon());
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Oraxen")) {
            blockAddons.add(new OraxenBlockAddon());
        }
        blockAddons.add(MinecraftBlockAddon.INSTANCE);
    }

    public static BlockAddon getBlockAddon(String key) {
        return blockAddons.stream().filter(b -> b.getKey().contains(key)).findFirst().orElse(null);
    }

    public static AddonBlock getAddonBlock(String keyID) {
        int index = keyID.indexOf(58);
        if (index == -1) {
            return BlockAddon.getAddonBlock("", keyID);
        }
        String key = keyID.substring(0, index);
        String id = keyID.substring(index);
        return BlockAddon.getAddonBlock(key, id);
    }

    public static List<String> getBlockSuggestions() {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (BlockAddon addon : blockAddons) {
            addon.addBlockSuggestions(suggestions);
        }
        return suggestions;
    }

    public static AddonBlock getAddonBlock(String key, String id) {
        Optional<BlockAddon> addon = blockAddons.stream().filter(b -> b.getKey().contains(key)).findFirst();
        return addon.map(blockAddon -> blockAddon.getBlock(id)).orElse(null);
    }

    public static AddonBlock getAddonBlockByLocation(Location loc) {
        for (BlockAddon addon : blockAddons) {
            AddonBlock block = addon.getBlock(loc);
            if (block == null) continue;
            return block;
        }
        return MinecraftBlockAddon.INSTANCE.getBlock(loc);
    }

    public static void removeAddonBlock(Location loc) {
        blockAddons.forEach(b -> b.removeBlock(loc));
    }

    public static List<AddonBlock> getAllBlocks() {
        ArrayList<AddonBlock> blocks = new ArrayList<AddonBlock>();
        for (BlockAddon addon : blockAddons) {
            ArrayList<String> suggestions = new ArrayList<String>();
            addon.addBlockSuggestions(suggestions);
            blocks.addAll(suggestions.parallelStream().map(BlockAddon::getAddonBlock).toList());
        }
        return blocks;
    }

    public abstract AddonBlock getBlock(String var1);

    public abstract AddonBlock getBlock(Location var1);

    public abstract void removeBlock(Location var1);

    public abstract void addBlockSuggestions(List<String> var1);

    public abstract List<String> getKey();
}

