/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.command;

import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.BooleanArgument;
import dev.jorel.commandapi.arguments.DoubleArgument;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.LocationArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import io.github.lijinhong11.supermines.SuperMines;
import io.github.lijinhong11.supermines.api.data.PlayerData;
import io.github.lijinhong11.supermines.api.data.Rank;
import io.github.lijinhong11.supermines.api.iface.Identified;
import io.github.lijinhong11.supermines.api.mine.Mine;
import io.github.lijinhong11.supermines.api.mine.Treasure;
import io.github.lijinhong11.supermines.api.pos.CuboidArea;
import io.github.lijinhong11.supermines.command.BlockArgument;
import io.github.lijinhong11.supermines.command.DisplayNameArgument;
import io.github.lijinhong11.supermines.command.EnumArgument;
import io.github.lijinhong11.supermines.gui.GuiManager;
import io.github.lijinhong11.supermines.integrates.block.AddonBlock;
import io.github.lijinhong11.supermines.managers.MineManager;
import io.github.lijinhong11.supermines.message.MessageReplacement;
import io.github.lijinhong11.supermines.utils.ComponentUtils;
import io.github.lijinhong11.supermines.utils.Constants;
import io.github.lijinhong11.supermines.utils.NullUtils;
import io.github.lijinhong11.supermines.utils.NumberUtils;
import io.github.lijinhong11.supermines.utils.StringUtils;
import io.github.lijinhong11.supermines.utils.selection.AreaSelection;
import io.github.lijinhong11.supermines.utils.selection.SelectionValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class SuperMinesCommand {
    private static final Map<UUID, AreaSelection> selectionMap = new ConcurrentHashMap<UUID, AreaSelection>();

    public static void handlePos(Player player, boolean isPos1, Location forcedLoc) {
        Location loc = forcedLoc != null ? forcedLoc : player.getLocation();
        MineManager mineManager = SuperMines.getInstance().getMineManager();
        if (mineManager.getMine(loc) != null) {
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.pos.in-mine", new MessageReplacement[0]);
            return;
        }
        UUID uuid = player.getUniqueId();
        AreaSelection sel = selectionMap.get(uuid);
        if (!SelectionValidator.validateAll(player, sel, loc)) {
            return;
        }
        if (sel == null) {
            sel = new AreaSelection(null, null);
        }
        sel = isPos1 ? new AreaSelection(loc, sel.pos2()) : new AreaSelection(sel.pos1(), loc);
        selectionMap.put(uuid, sel);
        String parsed = StringUtils.parseLocation((CommandSender)player, loc);
        MessageReplacement pos = MessageReplacement.replace("%pos%", parsed);
        SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, isPos1 ? "command.pos.set.pos1" : "command.pos.set.pos2", pos);
    }

    public void register() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("supermines").withAliases(new String[]{"sm", "mine", "mines"})).executes((sender, args) -> this.showHelp(sender), new ExecutorType[0])).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("treasures").withPermission("supermines.treasures")).executes((sender, args) -> SuperMines.getInstance().getLanguageManager().sendMessages(sender, "command.help.treasures", new MessageReplacement[0]), new ExecutorType[0])).withSubcommands((AbstractCommandAPICommand[])new CommandAPICommand[]{(CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withPermission("supermines.treasures")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("id"), new DoubleArgument("chance", 1.0, 100.0)})).withOptionalArguments((AbstractArgument[])new Argument[]{new DisplayNameArgument()})).executesPlayer((player, args) -> {
            String id = (String)args.getByClassOrDefault("id", String.class, (Object)"");
            Optional displayName = args.getOptionalByClass("displayName", Component.class);
            double chance = (Double)args.getByClassOrDefault("chance", Double.TYPE, (Object)0.0);
            if (!id.matches("^[a-zA-Z0-9_-]+$")) {
                SuperMines.getInstance().getLanguageManager().sendMessages((CommandSender)player, "command.invalid-id", new MessageReplacement[0]);
                return;
            }
            ItemStack is = player.getInventory().getItemInMainHand();
            if (is.getType().isAir()) {
                SuperMines.getInstance().getLanguageManager().sendMessages((CommandSender)player, "command.treasures.no-item-in-hand", new MessageReplacement[0]);
                return;
            }
            Treasure treasure = new Treasure(id, (Component)displayName.orElse(Component.text((String)id)), is, chance);
            SuperMines.getInstance().getTreasureManager().addTreasure(treasure);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.treasures.create.success", MessageReplacement.replace("%treasure%", treasure.getRawDisplayName()));
        }), (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withPermission("supermines.treasures")).executes((sender, args) -> this.list(sender, SuperMines.getInstance().getTreasureManager().getAllTreasures().toArray(new Treasure[0])), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("remove").withPermission("supermines.treasures")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("id")})).executesPlayer((player, args) -> {
            String id = NullUtils.tryString((String)args.get("id"));
            Treasure treasure = SuperMines.getInstance().getTreasureManager().getTreasure(id);
            if (treasure == null) {
                SuperMines.getInstance().getLanguageManager().sendMessages((CommandSender)player, "command.treasures.remove.not-exists", new MessageReplacement[0]);
                return;
            }
            SuperMines.getInstance().getTreasureManager().removeTreasure(treasure.getId());
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.treasures.remove.success", MessageReplacement.replace("%treasure%", treasure.getRawDisplayName()));
        }), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setDisplayName").withPermission("supermines.treasures")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("id").includeSuggestions(ArgumentSuggestions.strings(this.getTreasuresList())), new DisplayNameArgument()})).executes((sender, args) -> {
            String id = NullUtils.tryString((String)args.get("id"));
            Component displayName = (Component)args.get("displayName");
            Treasure treasure = SuperMines.getInstance().getTreasureManager().getTreasure(id);
            if (treasure == null) {
                SuperMines.getInstance().getLanguageManager().sendMessages(sender, "command.treasure-not-exists", new MessageReplacement[0]);
                return;
            }
            treasure.setDisplayName(displayName);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.set-display-name", MessageReplacement.replace("%treasure%", treasure.getRawDisplayName()));
        }, new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setChance").withPermission("supermines.treasures")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("id").includeSuggestions(ArgumentSuggestions.strings(this.getTreasuresList())), new DoubleArgument("chance", 1.0, 100.0)})).executes((sender, args) -> {
            String id = NullUtils.tryString((String)args.get("id"));
            double chance = (Double)args.getByClassOrDefault("chance", Double.TYPE, (Object)0.0);
            Treasure treasure = SuperMines.getInstance().getTreasureManager().getTreasure(id);
            if (treasure == null) {
                SuperMines.getInstance().getLanguageManager().sendMessages(sender, "command.treasure-not-exists", new MessageReplacement[0]);
                return;
            }
            treasure.setChance(chance);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.set-chance", MessageReplacement.replace("%treasure%", treasure.getRawDisplayName()));
        }, new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setItem").withPermission("supermines.treasures")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("id").includeSuggestions(ArgumentSuggestions.strings(this.getTreasuresList()))})).executesPlayer((player, args) -> {
            String id = NullUtils.tryString((String)args.get("id"));
            Treasure treasure = SuperMines.getInstance().getTreasureManager().getTreasure(id);
            if (treasure == null) {
                SuperMines.getInstance().getLanguageManager().sendMessages((CommandSender)player, "command.treasure-not-exists", new MessageReplacement[0]);
                return;
            }
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (itemStack.getType().isAir()) {
                SuperMines.getInstance().getLanguageManager().sendMessages((CommandSender)player, "command.treasures.item-not-found", new MessageReplacement[0]);
                return;
            }
            treasure.setItemStack(itemStack);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.treasures.set-item", MessageReplacement.replace("%treasure%", treasure.getRawDisplayName()));
        }), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("addMatch").withPermission("supermines.treasures")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("id").includeSuggestions(ArgumentSuggestions.strings(this.getTreasuresList())), new BlockArgument("block")})).executes((sender, args) -> {
            String id = NullUtils.tryString((String)args.get("id"));
            AddonBlock block = (AddonBlock)args.get("block");
            Treasure treasure = SuperMines.getInstance().getTreasureManager().getTreasure(id);
            if (treasure == null) {
                SuperMines.getInstance().getLanguageManager().sendMessages(sender, "command.treasure-not-exists", new MessageReplacement[0]);
                return;
            }
            if (block == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.invalid-block", new MessageReplacement[0]);
                return;
            }
            if (treasure.getMatchedBlocks().contains(block)) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.matched_blocks.exists", new MessageReplacement[0]);
                return;
            }
            treasure.addMatchedBlock(block);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.matched_blocks.add_success", MessageReplacement.replace("%block%", block.toString()));
        }, new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("removeMatch").withPermission("supermines.treasures")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("id").includeSuggestions(ArgumentSuggestions.strings(this.getTreasuresList())), new BlockArgument("block")})).executes((sender, args) -> {
            String id = NullUtils.tryString((String)args.get("id"));
            AddonBlock block = (AddonBlock)args.get("block");
            Treasure treasure = SuperMines.getInstance().getTreasureManager().getTreasure(id);
            if (treasure == null) {
                SuperMines.getInstance().getLanguageManager().sendMessages(sender, "command.treasure-not-exists", new MessageReplacement[0]);
                return;
            }
            if (block == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.invalid-block", new MessageReplacement[0]);
                return;
            }
            if (!treasure.getMatchedBlocks().contains(block)) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.matched_blocks.not_exists", new MessageReplacement[0]);
                return;
            }
            treasure.removeMatchedBlock(block);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.matched_blocks.remove_success", MessageReplacement.replace("%block%", block.toString()));
        }, new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("addCommand").withPermission("supermines.treasures")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("id").includeSuggestions(ArgumentSuggestions.strings(this.getTreasuresList())), new GreedyStringArgument("command")})).executes((sender, args) -> {
            String id = NullUtils.tryString((String)args.get("id"));
            String command = NullUtils.tryString((String)args.get("command"));
            Treasure treasure = SuperMines.getInstance().getTreasureManager().getTreasure(id);
            if (treasure == null) {
                SuperMines.getInstance().getLanguageManager().sendMessages(sender, "command.treasure-not-exists", new MessageReplacement[0]);
                return;
            }
            if (command.isEmpty()) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.command-empty", new MessageReplacement[0]);
                return;
            }
            treasure.addConsoleCommand(command);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.add-command.success", MessageReplacement.replace("%treasure%", treasure.getRawDisplayName()));
        }, new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("removeCommand").withPermission("supermines.treasures")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("id").includeSuggestions(ArgumentSuggestions.strings(this.getTreasuresList())), new GreedyStringArgument("command")})).executes((sender, args) -> {
            String id = NullUtils.tryString((String)args.get("id"));
            String command = NullUtils.tryString((String)args.get("command"));
            Treasure treasure = SuperMines.getInstance().getTreasureManager().getTreasure(id);
            if (treasure == null) {
                SuperMines.getInstance().getLanguageManager().sendMessages(sender, "command.treasure-not-exists", new MessageReplacement[0]);
                return;
            }
            List<String> commands = treasure.getConsoleCommands();
            if (commands == null || !commands.remove(command)) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.remove-command.not-found", new MessageReplacement[0]);
                return;
            }
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.remove-command.success", MessageReplacement.replace("%treasure%", treasure.getRawDisplayName()));
        }, new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("listCommands").withPermission("supermines.treasures")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("id").includeSuggestions(ArgumentSuggestions.strings(this.getTreasuresList()))})).executes((sender, args) -> {
            String id = NullUtils.tryString((String)args.get("id"));
            Treasure treasure = SuperMines.getInstance().getTreasureManager().getTreasure(id);
            if (treasure == null) {
                SuperMines.getInstance().getLanguageManager().sendMessages(sender, "command.treasure-not-exists", new MessageReplacement[0]);
                return;
            }
            List<String> commands = treasure.getConsoleCommands();
            if (commands == null || commands.isEmpty()) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.list-commands.empty", MessageReplacement.replace("%treasure%", treasure.getRawDisplayName()));
                return;
            }
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.list-commands.head", MessageReplacement.replace("%treasure%", treasure.getRawDisplayName()));
            for (int i = 0; i < commands.size(); ++i) {
                int index = i + 1;
                String cmd = commands.get(i);
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasures.list-commands.line", MessageReplacement.replace("%index%", String.valueOf(index)), MessageReplacement.replace("%command%", cmd));
            }
        }, new ExecutorType[0])})))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("ranks").withPermission("supermines.ranks")).executes((sender, args) -> SuperMines.getInstance().getLanguageManager().sendMessages(sender, "command.help.ranks", new MessageReplacement[0]), new ExecutorType[0])).withSubcommands((AbstractCommandAPICommand[])new CommandAPICommand[]{(CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withPermission("supermines.ranks")).executes((sender, args) -> this.list(sender, SuperMines.getInstance().getRankManager().getAllRanks().toArray(new Rank[0])), new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withPermission("supermines.ranks")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("rankId"), new DisplayNameArgument(), new IntegerArgument("level", 1, Integer.MAX_VALUE)})).executesPlayer((player, args) -> {
            String id = NullUtils.tryString((String)args.get("rankId"));
            Component displayName = (Component)args.getByClassOrDefault("displayName", Component.class, (Object)Component.text((String)id));
            int level = (Integer)args.getByClassOrDefault("level", Integer.TYPE, (Object)0);
            if (!id.matches("^[a-zA-Z0-9_-]+$")) {
                SuperMines.getInstance().getLanguageManager().sendMessages((CommandSender)player, "command.invalid-id", new MessageReplacement[0]);
                return;
            }
            if (SuperMines.getInstance().getRankManager().getRank(id) != null) {
                SuperMines.getInstance().getLanguageManager().sendMessages((CommandSender)player, "command.ranks.create.exists", new MessageReplacement[0]);
                return;
            }
            Rank rank = new Rank(level, id, displayName);
            SuperMines.getInstance().getRankManager().addRank(rank);
            SuperMines.getInstance().getLanguageManager().sendMessages((CommandSender)player, "command.ranks.create.success", MessageReplacement.replace("%rank%", rank.getId()));
        }), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("remove").withPermission("supermines.ranks")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("rankId").includeSuggestions(ArgumentSuggestions.strings(this.getRankList()))})).executesPlayer((player, args) -> {
            String id = NullUtils.tryString((String)args.get("rankId"));
            if (SuperMines.getInstance().getRankManager().getRank(id) == null) {
                SuperMines.getInstance().getLanguageManager().sendMessages((CommandSender)player, "command.rank-not-exists", new MessageReplacement[0]);
                return;
            }
            SuperMines.getInstance().getRankManager().removeRank(id);
            SuperMines.getInstance().getLanguageManager().sendMessages((CommandSender)player, "command.ranks.remove.success", MessageReplacement.replace("%rank%", id));
        }), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setLevel").withPermission("supermines.ranks")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("id").includeSuggestions(ArgumentSuggestions.strings(this.getRankList())), new IntegerArgument("level", 1, Integer.MAX_VALUE)})).executes((sender, args) -> {
            String id = NullUtils.tryString((String)args.get("id"));
            int level = (Integer)args.getByClassOrDefault("level", Integer.TYPE, (Object)0);
            Rank rank = SuperMines.getInstance().getRankManager().getRank(id);
            if (rank == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.rank-not-exists", new MessageReplacement[0]);
                return;
            }
            if (level < 1) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.ranks.level-less-than-1", new MessageReplacement[0]);
                return;
            }
            rank.setLevel(level);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.ranks.set-level", MessageReplacement.replace("%rank%", rank.getRawDisplayName()), MessageReplacement.replace("%level%", String.valueOf(level)));
        }, new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setDisplayName").withPermission("supermines.ranks")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("id").includeSuggestions(ArgumentSuggestions.strings(this.getRankList())), new DisplayNameArgument()})).executes((sender, args) -> {
            String id = NullUtils.tryString((String)args.get("id"));
            Component displayName = (Component)args.get("displayName");
            Rank rank = SuperMines.getInstance().getRankManager().getRank(id);
            if (rank == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.rank-not-exists", new MessageReplacement[0]);
                return;
            }
            rank.setDisplayName(displayName);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.ranks.set-display-name", MessageReplacement.replace("%rank%", rank.getId()), MessageReplacement.replace("%displayName%", rank.getRawDisplayName()));
        }, new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("giveRank").withPermission("supermines.ranks")).withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.OnePlayer("player"), (Argument)new StringArgument("rankId").includeSuggestions(ArgumentSuggestions.strings(this.getRankList()))})).withOptionalArguments((AbstractArgument[])new Argument[]{new BooleanArgument("notify")})).executes((sender, args) -> {
            Player player = (Player)args.get("player");
            boolean notify = (Boolean)args.getOrDefault("notify", (Object)false);
            String id = (String)args.get("rankId");
            Rank rank = SuperMines.getInstance().getRankManager().getRank(id);
            if (rank == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.rank-not-exists", new MessageReplacement[0]);
                return;
            }
            PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(player.getUniqueId());
            data.addRank(rank);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.ranks.give-rank", MessageReplacement.replace("%player%", player.getName()), MessageReplacement.replace("%rank%", rank.getRawDisplayName()));
            if (notify) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.ranks.give-rank-notify", MessageReplacement.replace("%rank%", rank.getRawDisplayName()));
            }
        }, new ExecutorType[0]), (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("takeRank").withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.OnePlayer("player"), (Argument)new StringArgument("rankId").includeSuggestions(ArgumentSuggestions.strings(this.getRankList()))})).withOptionalArguments((AbstractArgument[])new Argument[]{new BooleanArgument("notify")})).executes((sender, args) -> {
            Player player = (Player)args.get("player");
            boolean notify = (Boolean)args.getOrDefault("notify", (Object)false);
            String id = (String)args.get("rankId");
            Rank rank = SuperMines.getInstance().getRankManager().getRank(id);
            if (rank == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.rank-not-exists", new MessageReplacement[0]);
                return;
            }
            PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(player.getUniqueId());
            data.removeRank(rank);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.ranks.take-rank", MessageReplacement.replace("%player%", player.getName()), MessageReplacement.replace("%rank%", rank.getRawDisplayName()));
            if (notify) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.ranks.take-rank-notify", MessageReplacement.replace("%rank%", rank.getRawDisplayName()));
            }
        }, new ExecutorType[0])})))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("pos1").withPermission("supermines.setpos")).executesPlayer((player, args) -> SuperMinesCommand.handlePos(player, true, null))).withOptionalArguments((AbstractArgument[])new Argument[]{new LocationArgument("loc")})).executesPlayer((player, args) -> {
            Location loc = (Location)args.get("loc");
            SuperMinesCommand.handlePos(player, true, loc);
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("pos2").withPermission("supermines.setpos")).executesPlayer((player, args) -> SuperMinesCommand.handlePos(player, false, null))).withOptionalArguments((AbstractArgument[])new Argument[]{new LocationArgument("loc")})).executesPlayer((player, args) -> {
            Location loc = (Location)args.get("loc");
            SuperMinesCommand.handlePos(player, false, loc);
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withPermission("supermines.create")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("id")})).withOptionalArguments((AbstractArgument[])new Argument[]{new DisplayNameArgument()})).executesPlayer((player, args) -> {
            String id = NullUtils.tryString((String)args.get("id"));
            Component displayName = (Component)args.getOptionalByClass("displayName", Component.class).orElse(Component.text((String)id));
            this.createMine(player, id, displayName);
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("redefine").withPermission("supermines.redefine")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("id").includeSuggestions(ArgumentSuggestions.strings(this.getMineList()))})).executesPlayer((player, args) -> this.redefineMine(player, (String)args.get("id")))))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("remove").withPermission("supermines.delete")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList()))})).executes((sender, args) -> this.removeMine(sender, (String)args.get("mineId")), new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("reset").withPermission("supermines.reset")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("id").includeSuggestions(ArgumentSuggestions.strings(this.getMineList()))})).executes((sender, args) -> this.resetMine(sender, (String)args.get("id")), new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withPermission("supermines.list")).executes((sender, args) -> this.list(sender, SuperMines.getInstance().getMineManager().getAllMines().toArray(new Mine[0])), new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("gui").withPermission("supermines.gui")).executesPlayer((player, args) -> GuiManager.openGeneral(player))))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("addTreasure").withPermission("supermines.treasures")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList())), (Argument)new StringArgument("treasureId").includeSuggestions(ArgumentSuggestions.strings(this.getTreasuresList()))})).executes((sender, args) -> {
            String mineId = (String)args.getByClassOrDefault("mineId", String.class, (Object)"");
            String treasureId = (String)args.get("treasureId");
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            Treasure treasure = SuperMines.getInstance().getTreasureManager().getTreasure(treasureId);
            if (treasure == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasure-not-exists", new MessageReplacement[0]);
                return;
            }
            mine.addTreasure(treasure);
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("removeTreasure").withPermission("supermines.treasures")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList())), (Argument)new StringArgument("treasureId").includeSuggestions(ArgumentSuggestions.strings(this.getTreasuresList()))})).executes((sender, args) -> {
            String mineId = (String)args.getByClassOrDefault("mineId", String.class, (Object)"");
            String treasureId = (String)args.getByClassOrDefault("treasureId", String.class, (Object)"");
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            Treasure treasure = SuperMines.getInstance().getTreasureManager().getTreasure(treasureId);
            if (treasure == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.treasure-not-exists", new MessageReplacement[0]);
                return;
            }
            mine.removeTreasure(treasure);
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setRequiredLevel").withPermission("supermines.set_required_level")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList())), new IntegerArgument("level", 1, Integer.MAX_VALUE)})).executes((sender, args) -> {
            String mineId = (String)args.get("mineId");
            int level = (Integer)args.get("level");
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            mine.setRequiredRankLevel(level);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.set-required-level", MessageReplacement.replace("%mine%", mine.getRawDisplayName()), MessageReplacement.replace("%level%", String.valueOf(level)));
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setBlockGenerate").withPermission("supermines.block_generates")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList())), new BlockArgument("block"), new DoubleArgument("chance", 1.0, 100.0)})).executes((sender, args) -> {
            String mineId = (String)args.get("mineId");
            double chance = (Double)args.get("chance");
            AddonBlock block = (AddonBlock)args.get("block");
            if (block == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.invalid-block", new MessageReplacement[0]);
                return;
            }
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            double rest = mine.calculateRestChance();
            double wasSet = mine.getBlockSpawnEntries().getOrDefault(block, 0.0);
            if (wasSet > 0.0) {
                if (chance > wasSet && chance - wasSet > rest) {
                    SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.block-generate.chance-too-high", new MessageReplacement[0]);
                    return;
                }
            } else if (chance > rest) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.block-generate.chance-too-high", new MessageReplacement[0]);
                return;
            }
            mine.addBlockSpawnEntry(block, chance);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.block-generate.success", MessageReplacement.replace("%mine%", mine.getRawDisplayName()), MessageReplacement.replace("%block%", block.toString()), MessageReplacement.replace("%chance%", String.valueOf(chance)));
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("removeBlockGenerate").withPermission("supermines.block_generates")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("mineId"), new BlockArgument("block")})).executes((sender, args) -> {
            String mineId = (String)args.get("mineId");
            AddonBlock block = (AddonBlock)args.get("block");
            if (block == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.invalid-block", new MessageReplacement[0]);
                return;
            }
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            mine.removeBlockSpawnEntry(block);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.block-generate.removed", MessageReplacement.replace("%mine%", mine.getRawDisplayName()));
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setDisplayName").withPermission("supermines.set_display_name")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList())), new DisplayNameArgument()})).executes((sender, args) -> {
            String mineId = (String)args.get("mineId");
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            mine.setDisplayName(Objects.requireNonNull((Component)args.getByClass("displayName", Component.class)));
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.set-display-name", MessageReplacement.replace("%mine%", mine.getId()), MessageReplacement.replace("%displayName%", mine.getRawDisplayName()));
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setDisplayIcon").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList())), new EnumArgument<Material>("icon", Material.class)})).withPermission("supermines.set_display_icon")).executes((executor, args) -> {
            String mineId = (String)args.get("mineId");
            Material icon = (Material)args.get("icon");
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(executor, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            if (icon == null || icon.isAir()) {
                SuperMines.getInstance().getLanguageManager().sendMessage(executor, "command.invalid-material", new MessageReplacement[0]);
                return;
            }
            mine.setDisplayIcon(icon);
            SuperMines.getInstance().getLanguageManager().sendMessage(executor, "command.set-display-icon", MessageReplacement.replace("%mine%", mine.getId()), MessageReplacement.replace("%icon%", icon.toString()));
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("addAllowedRank").withPermission("supermines.ranks")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList())), (Argument)new StringArgument("rankId").includeSuggestions(ArgumentSuggestions.strings(this.getRankList()))})).executes((sender, args) -> {
            String mineId = (String)args.get("mineId");
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            Rank rank = SuperMines.getInstance().getRankManager().getRank((String)args.get("rankId"));
            if (rank == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.rank-not-exists", new MessageReplacement[0]);
                return;
            }
            mine.addAllowedRankId(rank.getId());
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.ranks.allowed", MessageReplacement.replace("%mine%", mine.getRawDisplayName()), MessageReplacement.replace("%rank%", rank.getRawDisplayName()));
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("removeAllowedRank").withPermission("supermines.ranks")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList())), (Argument)new StringArgument("rankId").includeSuggestions(ArgumentSuggestions.strings(this.getRankList()))})).executes((sender, args) -> {
            String mineId = (String)args.get("mineId");
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            Rank rank = SuperMines.getInstance().getRankManager().getRank((String)args.get("rankId"));
            if (rank == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.rank-not-exists", new MessageReplacement[0]);
                return;
            }
            mine.removeAllowedRankId(rank.getId());
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.ranks.disallowed", MessageReplacement.replace("%mine%", mine.getRawDisplayName()), MessageReplacement.replace("%rank%", rank.getRawDisplayName()));
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("addResetWarning").withPermission("supermines.reset_warnings")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList())), new IntegerArgument("restSeconds", 1, Integer.MAX_VALUE)})).executes((sender, args) -> {
            String mineId = (String)args.get("mineId");
            int restSeconds = (Integer)args.get("restSeconds");
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            if (restSeconds >= mine.getRegenerateSeconds()) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.resetwarning.time-too-long", new MessageReplacement[0]);
                return;
            }
            mine.getWarningSeconds().add(restSeconds);
            SuperMines.getInstance().getTaskMaker().startMineWarningTask(mine, restSeconds);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.resetwarning.started", MessageReplacement.replace("%mine%", mine.getRawDisplayName()), MessageReplacement.replace("%seconds%", NumberUtils.formatSeconds(sender, restSeconds)));
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("removeResetWarning").withPermission("supermines.reset_warnings")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList())), new IntegerArgument("restSeconds", 1, Integer.MAX_VALUE)})).executes((sender, args) -> {
            String mineId = (String)args.get("mineId");
            int restSeconds = (Integer)args.get("restSeconds");
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            if (restSeconds >= mine.getRegenerateSeconds()) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.resetwarning.time-too-long", new MessageReplacement[0]);
                return;
            }
            mine.getWarningSeconds().remove(restSeconds);
            SuperMines.getInstance().getTaskMaker().cancelMineWarningTask(mine, restSeconds);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.resetwarning.removed", new MessageReplacement[0]);
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setResetTime").withPermission("supermines.set_reset_time")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList())), new IntegerArgument("resetTime", 1, Integer.MAX_VALUE)})).executes((sender, args) -> {
            String id = (String)args.get("mineId");
            int resetTime = (Integer)args.getByClassOrDefault("resetTime", Integer.TYPE, (Object)0);
            Mine mine = SuperMines.getInstance().getMineManager().getMine(id);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            mine.setRegenerateSeconds(resetTime);
            if (resetTime <= 0) {
                SuperMines.getInstance().getTaskMaker().cancelMineResetTask(mine);
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.reset.stop-reset", MessageReplacement.replace("%mine%", mine.getRawDisplayName()));
            } else {
                SuperMines.getInstance().getTaskMaker().restartMineResetTask(mine);
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.reset.time-set", MessageReplacement.replace("%mine%", mine.getRawDisplayName()), MessageReplacement.replace("%time%", NumberUtils.formatSeconds(sender, resetTime)));
            }
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("settp").withAliases(new String[]{"setteleport"})).withPermission("supermines.set_teleport")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList()))})).executesPlayer((p, args) -> {
            String id = (String)args.get("mineId");
            Mine mine = SuperMines.getInstance().getMineManager().getMine(id);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            Location loc = p.getLocation();
            mine.setTeleportLocation(loc);
            String parsed = StringUtils.parseLocation((CommandSender)p, loc);
            MessageReplacement pos = MessageReplacement.replace("%pos%", parsed);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "command.teleport.set", pos);
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("tp").withAliases(new String[]{"teleport"})).withPermission("supermines.teleport")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("mineId")})).withOptionalArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.OnePlayer("player")})).executes((sender, args) -> {
            Optional player = args.getOptionalByClass("player", Player.class);
            if (player.isEmpty()) {
                return;
            }
            String id = (String)args.get("mineId");
            Mine mine = SuperMines.getInstance().getMineManager().getMine(id);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            Location loc = mine.getTeleportLocation();
            if (loc == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.teleport.no-loc", new MessageReplacement[0]);
                return;
            }
            ((Player)player.get()).teleportAsync(loc);
        }, new ExecutorType[0])).executesPlayer((p, args) -> {
            String id = (String)args.get("mineId");
            Mine mine = SuperMines.getInstance().getMineManager().getMine(id);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            Location loc = mine.getTeleportLocation();
            if (loc == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "command.teleport.no-loc", new MessageReplacement[0]);
                return;
            }
            p.teleportAsync(loc);
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setOnlyFillAir").withPermission("supermines.set_only_fill_air")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("mineId").includeSuggestions(ArgumentSuggestions.strings(this.getMineList())), new BooleanArgument("onlyFillAir")})).executes((sender, args) -> {
            String id = (String)args.get("mineId");
            boolean b = (Boolean)args.getByClassOrDefault("onlyFillAir", Boolean.TYPE, (Object)false);
            Mine mine = SuperMines.getInstance().getMineManager().getMine(id);
            if (mine == null) {
                SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
                return;
            }
            mine.setOnlyFillAirWhenRegenerate(b);
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, b ? "command.fillair.enabled" : "command.fillair.disabled", MessageReplacement.replace("%mine%", mine.getRawDisplayName()));
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("wand").withPermission("supermines.setpos")).executesPlayer((player, args) -> {
            PlayerInventory inv = player.getInventory();
            if (inv.firstEmpty() != -1) {
                inv.addItem(new ItemStack[]{Constants.Items.WAND.apply(player)});
            } else {
                inv.setItemInMainHand(Constants.Items.WAND.apply(player));
            }
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("reload").withPermission("supermines.reload")).executes((sender, args) -> {
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.reload.safe-tip", new MessageReplacement[0]);
            SuperMines.getInstance().reloadConfig();
            SuperMines.getInstance().getLanguageManager().reload();
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.reload.success", new MessageReplacement[0]);
        }, new ExecutorType[0])))).register();
    }

    private void showHelp(CommandSender sender) {
        SuperMines.getInstance().getLanguageManager().sendMessages(sender, "command.help.general", new MessageReplacement[0]);
    }

    private CuboidArea getSelectedArea(Player player, String id, boolean checkExists) {
        if (checkExists && SuperMines.getInstance().getMineManager().getMine(id) != null) {
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.create.exists", new MessageReplacement[0]);
            return null;
        }
        if (!id.matches("^[a-zA-Z0-9_-]+$")) {
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.invalid-id", new MessageReplacement[0]);
            return null;
        }
        AreaSelection sel = selectionMap.get(player.getUniqueId());
        if (sel == null || sel.pos1() == null || sel.pos2() == null) {
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.create.selection-not-finished", new MessageReplacement[0]);
            return null;
        }
        if (sel.isAnyMineIn()) {
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.pos-in-mine", new MessageReplacement[0]);
            return null;
        }
        return sel.toCuboidArea();
    }

    private void createMine(Player player, String id, Component displayName) {
        CuboidArea ca = this.getSelectedArea(player, id, true);
        if (ca == null) {
            return;
        }
        Component name = displayName == null ? Component.text((String)id) : displayName;
        Mine mine = new Mine(id, name, player.getWorld(), ca, new HashMap<AddonBlock, Double>(), 0, false);
        SuperMines.getInstance().getMineManager().addMine(mine);
        SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.create.success", new MessageReplacement[0]);
    }

    private void redefineMine(Player player, String id) {
        Mine mine = SuperMines.getInstance().getMineManager().getMine(id);
        if (mine == null) {
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.mine-not-exists", new MessageReplacement[0]);
            return;
        }
        CuboidArea ca = this.getSelectedArea(player, id, false);
        if (ca == null) {
            return;
        }
        mine.setArea(ca);
        SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)player, "command.redefine.success", new MessageReplacement[0]);
    }

    private void removeMine(CommandSender sender, String id) {
        Mine mine = SuperMines.getInstance().getMineManager().getMine(id);
        if (mine == null) {
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
            return;
        }
        SuperMines.getInstance().getTaskMaker().cancelMineResetTask(mine);
        SuperMines.getInstance().getMineManager().removeMine(id);
        SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.remove.success", new MessageReplacement[0]);
    }

    private void resetMine(CommandSender sender, String id) {
        Mine mine = SuperMines.getInstance().getMineManager().getMine(id);
        if (mine == null) {
            SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.mine-not-exists", new MessageReplacement[0]);
            return;
        }
        SuperMines.getInstance().getTaskMaker().runMineResetTaskNow(mine);
        SuperMines.getInstance().getLanguageManager().sendMessage(sender, "command.reset.success", new MessageReplacement[0]);
    }

    private <T extends Identified> void list(CommandSender sender, T[] array) {
        Component head = SuperMines.getInstance().getLanguageManager().getMsgComponent(sender, "command.list.head.mine", new MessageReplacement[0]);
        String color = SuperMines.getInstance().getLanguageManager().getMsg(sender, "command.list.color", new MessageReplacement[0]);
        Component sep = SuperMines.getInstance().getLanguageManager().getMsgComponent(sender, "command.list.separator", new MessageReplacement[0]);
        Component msg = head;
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            msg = msg.append(ComponentUtils.deserialize(color + t.getRawDisplayName() + "(" + t.getId() + ")"));
            if (i >= array.length - 1) continue;
            msg = msg.append(sep);
        }
        sender.sendMessage(msg);
    }

    private Set<String> getMineList() {
        return SuperMines.getInstance().getMineManager().getAllMineIds();
    }

    private Set<String> getTreasuresList() {
        return SuperMines.getInstance().getTreasureManager().getAllTreasureIds();
    }

    private Set<String> getRankList() {
        return SuperMines.getInstance().getRankManager().getAllRankIds();
    }
}

