/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.executors.CommandArguments;
import java.util.ArrayList;
import java.util.Arrays;

public class EnumArgument<E extends Enum<E>>
extends Argument<E> {
    private final Class<E> enumClass;

    public EnumArgument(String argName, Class<E> enumClass) {
        super(argName, (ArgumentType)StringArgumentType.string());
        this.enumClass = enumClass;
        ArrayList<String> suggestions = new ArrayList<String>(Arrays.stream((Enum[])enumClass.getEnumConstants()).map(Enum::toString).toList());
        this.includeSuggestions(ArgumentSuggestions.strings(suggestions));
    }

    public Class<E> getPrimitiveType() {
        return this.enumClass;
    }

    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_STRING;
    }

    public <Source> E parseArgument(CommandContext<Source> commandContext, String s, CommandArguments commandArguments) {
        return Enum.valueOf(this.enumClass, s.toUpperCase());
    }
}

