/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.api.mine;

import com.google.common.base.Preconditions;
import io.github.lijinhong11.supermines.api.iface.Identified;
import io.github.lijinhong11.supermines.integrates.block.AddonBlock;
import io.github.lijinhong11.supermines.integrates.block.MinecraftBlockAddon;
import io.github.lijinhong11.supermines.utils.ComponentUtils;
import io.github.lijinhong11.supermines.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class Treasure
implements Identified {
    private final Set<AddonBlock> matchedMaterials;
    private final String id;
    private double chance;
    private Component displayName;
    @Nullable
    private ItemStack itemStack;
    @Nullable
    private List<String> consoleCommands;

    public Treasure(@NotNull String id, @Nullable Component displayName, @Nullable ItemStack itemStack, @Range(from=0L, to=100L) double chance) {
        this(id, displayName, itemStack, chance, Set.of(), List.of());
    }

    public Treasure(@NotNull String id, @Nullable Component displayName, @Nullable ItemStack itemStack, @Range(from=0L, to=100L) double chance, @Nullable List<String> consoleCommands) {
        this(id, displayName, itemStack, chance, Set.of(), consoleCommands);
    }

    public Treasure(@NotNull String id, @Nullable Component displayName, @Nullable ItemStack itemStack, @Range(from=0L, to=100L) double chance, @NotNull Set<AddonBlock> matchedMaterials, @Nullable List<String> consoleCommands) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkNotNull(matchedMaterials, (Object)"matchedMaterials");
        Preconditions.checkArgument((chance >= 0.0 && chance <= 100.0 ? 1 : 0) != 0, (Object)"the chane must beteen 0~100");
        this.id = id;
        this.displayName = displayName;
        this.itemStack = itemStack;
        this.chance = chance;
        this.matchedMaterials = matchedMaterials;
        this.consoleCommands = consoleCommands;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void giveToPlayer(@NotNull Player player, boolean dropItem) {
        if (this.itemStack != null) {
            if (player.getInventory().firstEmpty() == -1 || dropItem) {
                player.getWorld().dropItemNaturally(player.getLocation(), this.itemStack);
            } else {
                player.getInventory().addItem(new ItemStack[]{this.itemStack});
            }
        }
        if (this.consoleCommands != null) {
            for (String consoleCommand : this.consoleCommands) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)StringUtils.parsePlaceholders(consoleCommand));
            }
        }
    }

    @Override
    public String getRawDisplayName() {
        if (this.displayName == null) {
            return this.id;
        }
        return ComponentUtils.serialize(this.displayName);
    }

    @Override
    public Component getDisplayName() {
        return this.displayName == null ? ComponentUtils.text(this.id) : this.displayName;
    }

    @Override
    public void setDisplayName(@Nullable Component displayName) {
        Preconditions.checkNotNull((Object)displayName, (Object)"display name cannot be null");
        this.displayName = displayName;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(@Nullable ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public double getChance() {
        return this.chance;
    }

    public void setChance(@Range(from=0L, to=100L) double chance) {
        Preconditions.checkArgument((chance >= 0.0 && chance <= 100.0 ? 1 : 0) != 0, (Object)"the chane must beteen 0~100");
        this.chance = chance;
    }

    public void addMatchedMaterial(Material material) {
        this.addMatchedBlock(MinecraftBlockAddon.createForMaterial(material));
    }

    public void addMatchedBlock(AddonBlock block) {
        this.matchedMaterials.add(block);
    }

    public void removeMatchedMaterial(Material material) {
        this.matchedMaterials.remove(MinecraftBlockAddon.createForMaterial(material));
    }

    public void removeMatchedBlock(AddonBlock block) {
        this.matchedMaterials.remove(block);
    }

    public Set<AddonBlock> getMatchedBlocks() {
        return this.matchedMaterials;
    }

    public void addConsoleCommand(@NotNull String consoleCommand) {
        if (this.consoleCommands == null) {
            this.consoleCommands = new ArrayList<String>();
        }
        this.consoleCommands.add(consoleCommand);
    }

    public void removeConsoleCommand(@NotNull String consoleCommand) {
        if (this.consoleCommands == null) {
            return;
        }
        this.consoleCommands.remove(consoleCommand);
    }

    public void setConsoleCommands(@Nullable List<String> consoleCommands) {
        this.consoleCommands = consoleCommands;
    }

    @Nullable
    public List<String> getConsoleCommands() {
        return this.consoleCommands;
    }
}

