/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.api.mine;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.github.lijinhong11.supermines.api.SuperMinesAPI;
import io.github.lijinhong11.supermines.api.data.PlayerData;
import io.github.lijinhong11.supermines.api.data.Rank;
import io.github.lijinhong11.supermines.api.iface.Identified;
import io.github.lijinhong11.supermines.api.mine.Treasure;
import io.github.lijinhong11.supermines.api.pos.BlockPos;
import io.github.lijinhong11.supermines.api.pos.CuboidArea;
import io.github.lijinhong11.supermines.integrates.block.AddonBlock;
import io.github.lijinhong11.supermines.integrates.block.MinecraftBlockAddon;
import io.github.lijinhong11.supermines.managers.database.StringRankSet;
import io.github.lijinhong11.supermines.utils.ComponentUtils;
import io.github.lijinhong11.supermines.utils.Constants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.ParametersAreNonnullByDefault;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class Mine
implements Identified {
    private final String id;
    private final World world;
    private final Map<AddonBlock, Double> blockSpawnEntries;
    private final List<Treasure> treasures;
    private final Set<String> allowedRankIds;
    private final Set<Integer> warningSeconds;
    private final AtomicInteger blocksBroken = new AtomicInteger(0);
    private Material displayIcon;
    private Component displayName;
    private CuboidArea area;
    private int regenerateSeconds;
    private boolean onlyFillAirWhenRegenerate;
    private int requiredRankLevel;
    private Location tpLoc;

    @ParametersAreNonnullByDefault
    public Mine(String id, Component displayName, World world, CuboidArea area, Map<AddonBlock, Double> blockSpawnEntries, int regenerateSeconds, boolean onlyFillAirWhenRegenerate) {
        this(id, displayName, Constants.Items.DEFAULT_MINE_ICON, world, area, blockSpawnEntries, regenerateSeconds, onlyFillAirWhenRegenerate);
    }

    @ParametersAreNonnullByDefault
    public Mine(String id, Component displayName, Material displayIcon, World world, CuboidArea area, Map<AddonBlock, Double> blockSpawnEntries, int regenerateSeconds, boolean onlyFillAirWhenRegenerate) {
        this(id, displayName, displayIcon, world, area, blockSpawnEntries, regenerateSeconds, onlyFillAirWhenRegenerate, new ArrayList<Treasure>(), new HashSet<String>());
    }

    @ParametersAreNonnullByDefault
    public Mine(String id, Component displayName, Material displayIcon, World world, CuboidArea area, Map<AddonBlock, Double> blockSpawnEntries, int regenerateSeconds, boolean onlyFillAirWhenRegenerate, List<Treasure> treasures, Set<String> allowedRankIds) {
        this(id, displayName, displayIcon, world, area, blockSpawnEntries, regenerateSeconds, onlyFillAirWhenRegenerate, treasures, Rank.DEFAULT.getLevel(), allowedRankIds);
    }

    @ParametersAreNonnullByDefault
    public Mine(String id, Component displayName, Material displayIcon, World world, CuboidArea area, Map<AddonBlock, Double> blockSpawnEntries, int regenerateSeconds, boolean onlyFillAirWhenRegenerate, List<Treasure> treasures, int requiredRankLevel, Set<String> allowedRankIds) {
        this(id, displayName, displayIcon, world, area, blockSpawnEntries, regenerateSeconds, onlyFillAirWhenRegenerate, treasures, requiredRankLevel, allowedRankIds, null, new HashSet<Integer>());
    }

    @ParametersAreNonnullByDefault
    public Mine(String id, Component displayName, Material displayIcon, World world, CuboidArea area, Map<AddonBlock, Double> blockSpawnEntries, int regenerateSeconds, boolean onlyFillAirWhenRegenerate, List<Treasure> treasures, int requiredRankLevel, Set<String> allowedRankIds, @Nullable Location tpLoc, Set<Integer> warningSeconds) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"Mine ID cannot be null or empty");
        Preconditions.checkArgument((boolean)id.matches("^[a-zA-Z0-9_-]+$"), (Object)"Mine ID cannot contain special characters");
        this.id = id;
        this.displayName = displayName;
        this.displayIcon = displayIcon;
        this.world = world;
        this.area = area;
        this.onlyFillAirWhenRegenerate = onlyFillAirWhenRegenerate;
        this.blockSpawnEntries = blockSpawnEntries;
        this.regenerateSeconds = regenerateSeconds;
        this.treasures = treasures;
        this.requiredRankLevel = requiredRankLevel;
        this.allowedRankIds = allowedRankIds;
        this.warningSeconds = warningSeconds;
        this.tpLoc = tpLoc == null ? area.getCenterLocation(world) : tpLoc;
    }

    public boolean isPlayerInMine(@NotNull Player player) {
        return this.area.contains(BlockPos.fromLocation(player.getLocation()));
    }

    public void addTreasure(@NotNull String id) {
        this.treasures.add(SuperMinesAPI.getTreasure(id));
    }

    public void addTreasure(@NotNull Treasure treasure) {
        this.treasures.add(treasure);
    }

    public void removeTreasure(@NotNull String id) {
        this.treasures.removeIf(treasure -> treasure.getId().equals(id));
    }

    public void removeTreasure(@NotNull Treasure treasure) {
        this.treasures.remove(treasure);
    }

    public void addBlockSpawnEntry(@NotNull Material material, double chance) {
        if (chance < 1.0 || chance > 100.0) {
            throw new IllegalArgumentException("Chance must be between 1 and 100");
        }
        this.blockSpawnEntries.put(MinecraftBlockAddon.createForMaterial(material), chance);
    }

    public void addBlockSpawnEntry(@NotNull AddonBlock block, double chance) {
        if (chance < 1.0 || chance > 100.0) {
            throw new IllegalArgumentException("Chance must be between 1 and 100");
        }
        this.blockSpawnEntries.put(block, chance);
    }

    public void addBlockSpawnEntries(Map<AddonBlock, Double> blockSpawnEntries) {
        this.blockSpawnEntries.putAll(blockSpawnEntries);
    }

    public void removeBlockSpawnEntry(@NotNull Material material) {
        this.blockSpawnEntries.remove(MinecraftBlockAddon.createForMaterial(material));
    }

    public void removeBlockSpawnEntry(@NotNull AddonBlock block) {
        this.blockSpawnEntries.remove(block);
    }

    public void removeBlockSpawnEntries(List<AddonBlock> blocks) {
        blocks.forEach(this.blockSpawnEntries::remove);
    }

    public void addAllowedRankId(String rankId) {
        this.allowedRankIds.add(rankId);
    }

    public void removeAllowedRankId(String rankId) {
        this.allowedRankIds.remove(rankId);
    }

    public Set<String> getAllowedRankIds() {
        return this.allowedRankIds;
    }

    public void setAllowedRankIds(Collection<String> rankIds) {
        this.allowedRankIds.clear();
        this.allowedRankIds.addAll(rankIds);
    }

    @Nullable
    public Location getTeleportLocation() {
        return this.tpLoc;
    }

    public void setTeleportLocation(@NotNull Location tpLoc) {
        Preconditions.checkNotNull((Object)tpLoc, (Object)"teleport location cannot be null");
        this.tpLoc = tpLoc;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRawDisplayName() {
        if (this.displayName == null) {
            return this.id;
        }
        return ComponentUtils.serialize(this.displayName);
    }

    @Override
    public Component getDisplayName() {
        return this.displayName == null ? ComponentUtils.text(this.id) : this.displayName;
    }

    @Override
    public void setDisplayName(@Nullable Component displayName) {
        Preconditions.checkNotNull((Object)displayName, (Object)"display name cannot be null");
        this.displayName = displayName;
    }

    public Material getDisplayIcon() {
        return this.displayIcon;
    }

    public void setDisplayIcon(Material displayIcon) {
        Preconditions.checkNotNull((Object)displayIcon, (Object)"display icon cannot be null");
        this.displayIcon = displayIcon;
    }

    public World getWorld() {
        return this.world;
    }

    public CuboidArea getArea() {
        return this.area;
    }

    public void setArea(@NotNull CuboidArea area) {
        Preconditions.checkNotNull((Object)area, (Object)"area cannot be null");
        this.area = area;
    }

    public List<Treasure> getTreasures() {
        return this.treasures;
    }

    public void setTreasures(@NotNull List<Treasure> treasures) {
        this.treasures.clear();
        this.treasures.addAll(treasures);
    }

    public Map<AddonBlock, Double> getBlockSpawnEntries() {
        return this.blockSpawnEntries;
    }

    public int getRegenerateSeconds() {
        return this.regenerateSeconds;
    }

    public void setRegenerateSeconds(@Range(from=0L, to=0x7FFFFFFFL) int regenerateSeconds) {
        Preconditions.checkArgument((regenerateSeconds >= 0 ? 1 : 0) != 0, (Object)"regenerate seconds must equal to or greater than 0");
        this.regenerateSeconds = regenerateSeconds;
    }

    public boolean isOnlyFillAirWhenRegenerate() {
        return this.onlyFillAirWhenRegenerate;
    }

    public void setOnlyFillAirWhenRegenerate(boolean onlyFillAirWhenRegenerate) {
        this.onlyFillAirWhenRegenerate = onlyFillAirWhenRegenerate;
    }

    public int getRequiredRankLevel() {
        return this.requiredRankLevel;
    }

    public void setRequiredRankLevel(int requiredRankLevel) {
        this.requiredRankLevel = requiredRankLevel;
    }

    public void setRequiredRankLevel(Rank requiredRank) {
        this.requiredRankLevel = requiredRank.getLevel();
    }

    public int getBlocksBroken() {
        return this.blocksBroken.get();
    }

    public void setBlocksBroken(int blocksBroken) {
        this.blocksBroken.set(blocksBroken);
    }

    public void plusBlocksBroken() {
        this.blocksBroken.incrementAndGet();
    }

    public Set<Integer> getWarningSeconds() {
        return this.warningSeconds;
    }

    public void setWarningSeconds(Set<Integer> warningSeconds) {
        this.warningSeconds.clear();
        this.warningSeconds.addAll(warningSeconds);
    }

    public double calculateRestChance() {
        double max = 100.0;
        for (double chance : this.blockSpawnEntries.values()) {
            max -= chance;
        }
        return max;
    }

    public boolean canMine(Player p) {
        PlayerData data = SuperMinesAPI.getOrCreatePlayerData(p.getUniqueId());
        StringRankSet rank = data.getRank();
        if (p.isOp() || p.hasPermission("supermines.bypass.rank")) {
            return true;
        }
        if (this.allowedRankIds.isEmpty()) {
            return true;
        }
        if (rank.matchRank(this.allowedRankIds)) {
            return true;
        }
        return rank.matchRankLevel(this.requiredRankLevel);
    }
}

