/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.api.data;

import com.google.common.base.Preconditions;
import io.github.lijinhong11.supermines.api.iface.Identified;
import io.github.lijinhong11.supermines.utils.ComponentUtils;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Rank
implements Identified {
    public static final Rank DEFAULT = new Rank(1, "default", ComponentUtils.deserialize("Default"));
    private final String id;
    private int level;
    private Component displayName;

    @ParametersAreNonnullByDefault
    public Rank(int level, String id, Component displayName) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Rank level must be greater than 0");
        Preconditions.checkNotNull((Object)id, (Object)"Rank ID must not be null");
        this.level = level;
        this.id = id;
        this.displayName = displayName;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Rank level must be greater than 0");
        this.level = level;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getRawDisplayName() {
        return ComponentUtils.serialize(this.getDisplayName());
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return this.displayName == null ? ComponentUtils.text(this.id) : this.displayName;
    }

    @Override
    public void setDisplayName(@Nullable Component displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Rank)) {
            return false;
        }
        Rank r = (Rank)o;
        return this.level == r.level && Objects.equals(this.id, r.id) && Objects.equals(this.displayName, r.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.level, this.displayName);
    }
}

