/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.api.data;

import com.google.common.base.Preconditions;
import io.github.lijinhong11.supermines.api.data.Rank;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.Column;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.Converter;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.PrimaryKey;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.Table;
import io.github.lijinhong11.supermines.managers.database.RankConverter;
import io.github.lijinhong11.supermines.managers.database.StringRankSet;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

@Table(name="player_data")
public final class PlayerData {
    @Column(name="player_uuid")
    @PrimaryKey
    private UUID playerUUID;
    @Column(name="player_name")
    private String playerName;
    @Column(name="mined_blocks")
    private int minedBlocks;
    @Converter(value=RankConverter.class)
    @Column(name="rank")
    private StringRankSet rank = new StringRankSet();

    public PlayerData() {
    }

    public PlayerData(String playerName, UUID playerUUID, StringRankSet rank) {
        this.playerName = playerName;
        this.playerUUID = playerUUID;
        this.rank = rank;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @NotNull
    public StringRankSet getRank() {
        return this.rank;
    }

    public void setRank(@NotNull StringRankSet rank) {
        Preconditions.checkNotNull((Object)rank, (Object)"rank");
        this.rank = rank;
    }

    public void addRank(Rank rank) {
        this.rank.add(rank);
    }

    public void removeRank(Rank rank) {
        this.rank.remove(rank);
    }

    public int getMinedBlocks() {
        return this.minedBlocks;
    }

    public void addMinedBlocks(int amount) {
        this.minedBlocks += amount;
    }
}

