/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines;

import io.github.lijinhong11.supermines.command.SuperMinesCommand;
import io.github.lijinhong11.supermines.integrates.block.BlockAddon;
import io.github.lijinhong11.supermines.integrates.placeholders.MiniPlaceholderExtension;
import io.github.lijinhong11.supermines.integrates.placeholders.PlaceholderAPIExtension;
import io.github.lijinhong11.supermines.libraries.database.DatabaseConnection;
import io.github.lijinhong11.supermines.libraries.database.DatabaseParameters;
import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.impl.DatabaseConnections;
import io.github.lijinhong11.supermines.libraries.folialib.FoliaLib;
import io.github.lijinhong11.supermines.listeners.BlockListener;
import io.github.lijinhong11.supermines.listeners.PlayerListener;
import io.github.lijinhong11.supermines.listeners.WandListener;
import io.github.lijinhong11.supermines.listeners.WorldEditListener;
import io.github.lijinhong11.supermines.managers.MineManager;
import io.github.lijinhong11.supermines.managers.PlayerDataManager;
import io.github.lijinhong11.supermines.managers.RankManager;
import io.github.lijinhong11.supermines.managers.TreasureManager;
import io.github.lijinhong11.supermines.message.LanguageManager;
import io.github.lijinhong11.supermines.task.TaskMaker;
import io.github.lijinhong11.supermines.utils.ConfigFileUtil;
import io.github.lijinhong11.supermines.utils.Metrics;
import java.io.File;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SuperMines
extends JavaPlugin {
    private static SuperMines instance;
    private MineManager mineManager;
    private TreasureManager treasureManager;
    private RankManager rankManager;
    private PlayerDataManager playerDataManager;
    private LanguageManager languageManager;
    private FoliaLib foliaLibImpl;
    private TaskMaker taskMaker;

    public static SuperMines getInstance() {
        return instance;
    }

    public void onLoad() {
        instance = this;
        this.foliaLibImpl = new FoliaLib((Plugin)this);
        ConfigFileUtil.completeFile((Plugin)this, "config.yml");
    }

    public void onEnable() {
        this.getLogger().info("\n==============================\n       SuperMines v%s\n        Author: mmmjjkx\n           Enjoy :)\n==============================\n".formatted(this.getDescription().getVersion()));
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
        }
        catch (Exception e) {
            this.getLogger().info("\n==============================\nSuperMines detected that you are using Spigot server software.\nSome important features will not work!!!!\nYou may experience some errors, but I'm sorry.\nSuperMines suggest you to change to Paper.\n\nWhy?\nPaper has a lot of performance improvements and a lot benefits.\nSome developers are changed to use Paper to develop their plugins.\n\nDownload Paper and improve your server!\n\nYou can download Paper @ https://papermc.io/downloads/paper\n==============================\n");
        }
        this.languageManager = new LanguageManager((Plugin)this);
        BlockAddon.init();
        this.treasureManager = new TreasureManager();
        this.rankManager = new RankManager();
        this.mineManager = new MineManager();
        this.taskMaker = new TaskMaker(this.foliaLibImpl);
        this.setupDatabase();
        this.setupListeners();
        this.setupPlaceholders();
        new SuperMinesCommand().register();
        new Metrics((Plugin)this, 28631);
        this.taskMaker.startup();
    }

    public void onDisable() {
        this.taskMaker.close();
        this.mineManager.saveAndClose();
        this.treasureManager.saveAndClose();
        this.rankManager.saveAndClose();
        this.playerDataManager.saveAndClose();
    }

    private void setupDatabase() {
        ConfigurationSection storage = this.getConfig().createSection("storage");
        ConfigurationSection remote = storage.createSection("remote");
        DatabaseType type = DatabaseType.getByName(storage.getString("type", "SQLITE"));
        if (type == null) {
            this.getLogger().warning("Invalid storage type, using SQLite instead.");
            type = DatabaseType.SQLITE;
        }
        String ip = remote.getString("ip");
        int port = remote.getInt("port");
        String database = remote.getString("database");
        String username = remote.getString("username");
        String password = remote.getString("password");
        DatabaseConnection conn = DatabaseConnections.createByType(type, new File(this.getDataFolder(), "data/data.db"), ip, port, database, username, password, new DatabaseParameters());
        this.playerDataManager = new PlayerDataManager(conn);
    }

    private void setupListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WandListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        if (this.getServer().getPluginManager().isPluginEnabled("WorldEdit")) {
            new WorldEditListener();
        }
    }

    private void setupPlaceholders() {
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PlaceholderAPIExtension().register();
        }
        if (this.getServer().getPluginManager().isPluginEnabled("MiniPlaceholders")) {
            MiniPlaceholderExtension.register();
        }
    }

    public MineManager getMineManager() {
        return this.mineManager;
    }

    public TreasureManager getTreasureManager() {
        return this.treasureManager;
    }

    public RankManager getRankManager() {
        return this.rankManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public TaskMaker getTaskMaker() {
        return this.taskMaker;
    }
}

