/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.task;

import io.github.lijinhong11.supermines.SuperMines;
import io.github.lijinhong11.supermines.api.mine.Mine;
import io.github.lijinhong11.supermines.libraries.folialib.FoliaLib;
import io.github.lijinhong11.supermines.libraries.folialib.impl.PlatformScheduler;
import io.github.lijinhong11.supermines.task.AbstractTask;
import io.github.lijinhong11.supermines.task.MineResetTask;
import io.github.lijinhong11.supermines.task.MineResetWarningTask;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;

public class TaskMaker {
    private final PlatformScheduler scheduler;
    private final Map<String, MineResetTask> resetTasks;
    private final Map<String, Map<Integer, MineResetWarningTask>> resetWarningTasks;

    public TaskMaker(FoliaLib f) {
        this.scheduler = f.getScheduler();
        this.resetTasks = new HashMap<String, MineResetTask>();
        this.resetWarningTasks = new HashMap<String, Map<Integer, MineResetWarningTask>>();
    }

    public void startup() {
        for (Mine mine : SuperMines.getInstance().getMineManager().getAllMines()) {
            if (mine.getRegenerateSeconds() < 1) continue;
            this.startMineResetTask(mine);
            for (int second : mine.getWarningSeconds()) {
                this.startMineWarningTask(mine, second);
            }
        }
    }

    public void runSync(Location loc, Runnable runnable) {
        if (loc.getWorld() == null) {
            return;
        }
        this.scheduler.runAtLocation(loc, t -> runnable.run());
    }

    public void startMineWarningTask(Mine mine, int warningSeconds) {
        MineResetTask resetTask = this.resetTasks.get(mine.getId());
        if (resetTask == null) {
            return;
        }
        Map warningMap = this.resetWarningTasks.computeIfAbsent(mine.getId(), id -> new HashMap());
        if (warningMap.containsKey(warningSeconds)) {
            return;
        }
        MineResetWarningTask task = new MineResetWarningTask(mine, warningSeconds);
        long delayMillis = resetTask.getNextResetTime() - System.currentTimeMillis() - (long)warningSeconds * 1000L;
        if (delayMillis <= 0L) {
            this.scheduler.runNextTick(task);
            this.scheduler.runLaterAsync(t -> {
                this.scheduler.runTimerAsync(task, delayMillis / 50L, (long)mine.getRegenerateSeconds() * 20L);
                warningMap.put(warningSeconds, task);
            }, delayMillis / 50L);
            return;
        }
        warningMap.put(warningSeconds, task);
        this.scheduler.runTimerAsync(task, delayMillis / 50L, (long)mine.getRegenerateSeconds() * 20L);
    }

    public void startMineResetTask(Mine mine) {
        MineResetTask task = new MineResetTask(mine);
        this.scheduler.runTimerAsync(task, 1L, (long)mine.getRegenerateSeconds() * 20L);
        this.resetTasks.put(mine.getId(), task);
    }

    public void runMineResetTaskNow(Mine mine) {
        MineResetTask mrt = new MineResetTask(mine);
        this.scheduler.runLaterAsync(mrt, 1L);
    }

    public void cancelMineResetTask(Mine mine) {
        MineResetTask task = this.resetTasks.get(mine.getId());
        if (task != null) {
            task.cancel();
        }
        this.cancelMineResetWarningTasks(mine);
        this.resetTasks.remove(mine.getId());
    }

    public long getMineUntilResetTime(Mine mine) {
        MineResetTask task = this.resetTasks.get(mine.getId());
        if (task == null) {
            return -1L;
        }
        return Math.max(0L, task.getNextResetTime() - System.currentTimeMillis());
    }

    public void cancelMineWarningTask(Mine mine, int restSeconds) {
        MineResetWarningTask task = (MineResetWarningTask)((Map)this.resetWarningTasks.getOrDefault(mine.getId(), new HashMap())).get(restSeconds);
        if (task != null) {
            task.cancel();
        }
    }

    public void restartMineResetTask(Mine mine) {
        this.cancelMineResetTask(mine);
        this.startMineResetTask(mine);
        for (int second : mine.getWarningSeconds()) {
            this.startMineWarningTask(mine, second);
        }
    }

    private void cancelMineResetWarningTasks(Mine mine) {
        Map<Integer, MineResetWarningTask> tasks = this.resetWarningTasks.get(mine.getId());
        if (tasks != null) {
            tasks.values().forEach(AbstractTask::cancel);
        }
        this.resetWarningTasks.remove(mine.getId());
    }

    public void close() {
        for (Map<Integer, MineResetWarningTask> map : this.resetWarningTasks.values()) {
            map.values().forEach(AbstractTask::cancel);
        }
        for (MineResetTask mineResetTask : this.resetTasks.values()) {
            mineResetTask.cancel();
        }
        this.resetWarningTasks.clear();
        this.resetTasks.clear();
    }
}

