/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.managers.abstracts;

import com.google.common.base.Strings;
import io.github.lijinhong11.supermines.SuperMines;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFileObjectManager<T> {
    private final File configFile;
    private final YamlConfiguration config;

    protected AbstractFileObjectManager(@NotNull String configPath) {
        if (Strings.isNullOrEmpty((String)configPath)) {
            throw new IllegalArgumentException("configPath cannot be null or empty");
        }
        File file = new File(SuperMines.getInstance().getDataFolder(), configPath);
        if (!file.exists()) {
            SuperMines.getInstance().saveResource(configPath, false);
        }
        this.configFile = file;
        this.config = YamlConfiguration.loadConfiguration((File)file);
    }

    @NotNull
    protected final List<T> getAll() {
        Set keys = this.config.getKeys(false);
        if (keys.isEmpty()) {
            return new ArrayList();
        }
        return keys.stream().map(this::getObject).toList();
    }

    protected final void remove(@NotNull String key) {
        this.config.set(key, null);
        try {
            this.config.save(this.configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final T getObject(@NotNull String key) {
        ConfigurationSection section = this.config.getConfigurationSection(key);
        if (section == null) {
            return null;
        }
        return this.getObject(section);
    }

    protected abstract T getObject(@NotNull ConfigurationSection var1);

    protected final void putObject(String key, T object) {
        ConfigurationSection section = this.config.createSection(key);
        this.putObject(section, object);
        try {
            this.config.save(this.configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void putObject(@NotNull ConfigurationSection var1, T var2);

    public abstract void saveAndClose();
}

