/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.managers.abstracts;

import io.github.lijinhong11.supermines.SuperMines;
import io.github.lijinhong11.supermines.libraries.database.DatabaseConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDatabaseObjectManager<T> {
    private final DatabaseConnection connection;
    private final Class<T> clazz;

    public AbstractDatabaseObjectManager(DatabaseConnection connection, Class<T> clazz) {
        this.connection = connection;
        this.clazz = clazz;
        this.setup();
    }

    private void setup() {
        try {
            this.connection.createTableByClass(this.clazz);
        }
        catch (SQLException e) {
            SuperMines.getInstance().getLogger().log(Level.SEVERE, "Failed to create/load player data!\nThe plugin will disabled...\n", e);
            Bukkit.getPluginManager().disablePlugin((Plugin)SuperMines.getInstance());
        }
    }

    protected void saveObject(@NotNull T t) {
        try {
            this.connection.insertObject(this.clazz, t, true);
        }
        catch (SQLException e) {
            SuperMines.getInstance().getLogger().log(Level.SEVERE, "Failed to save player data!\nThe plugin will disabled...\n", e);
            Bukkit.getPluginManager().disablePlugin((Plugin)SuperMines.getInstance());
        }
    }

    protected final List<T> getAll() {
        try {
            return this.connection.selectMulti(this.clazz);
        }
        catch (SQLException e) {
            SuperMines.getInstance().getLogger().log(Level.SEVERE, "Failed to load player data table!\nThe plugin will disabled...\n", e);
            Bukkit.getPluginManager().disablePlugin((Plugin)SuperMines.getInstance());
            return new ArrayList();
        }
    }

    public abstract void saveAndClose();

    protected void close() {
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

