/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.managers;

import io.github.lijinhong11.supermines.api.data.Rank;
import io.github.lijinhong11.supermines.managers.abstracts.AbstractFileObjectManager;
import io.github.lijinhong11.supermines.utils.ComponentUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RankManager
extends AbstractFileObjectManager<Rank> {
    private final Map<String, Rank> ranks = new HashMap<String, Rank>();

    public RankManager() {
        super("data/ranks.yml");
        this.load();
    }

    private void load() {
        for (Rank object : super.getAll()) {
            this.ranks.put(object.getId(), object);
        }
    }

    @Override
    protected Rank getObject(@NotNull ConfigurationSection section) {
        String id = section.getCurrentPath();
        String displayName = section.getString("displayName", id);
        return new Rank(section.getInt("level", 1), id, ComponentUtils.deserialize(displayName));
    }

    @Override
    protected void putObject(@NotNull ConfigurationSection section, Rank object) {
        section.set("level", (Object)object.getLevel());
        section.set("displayName", (Object)ComponentUtils.serialize(object.getDisplayName()));
    }

    @Override
    public void saveAndClose() {
        for (Rank rank : this.ranks.values()) {
            super.putObject(rank.getId(), rank);
        }
    }

    public void addRank(@NotNull Rank rank) {
        if (this.ranks.containsKey(rank.getId())) {
            throw new IllegalArgumentException("Rank with ID " + rank.getId() + " already exists");
        }
        this.ranks.put(rank.getId(), rank);
        super.putObject(rank.getId(), rank);
    }

    @Nullable
    public Rank getRank(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return this.ranks.get(id);
    }

    public void removeRank(@NotNull String id) {
        if (!this.ranks.containsKey(id)) {
            throw new IllegalArgumentException("Rank with ID " + id + " does not exist");
        }
        this.ranks.remove(id);
        super.remove(id);
    }

    public Collection<Rank> getAllRanks() {
        return this.ranks.values();
    }

    public Set<String> getAllRankIds() {
        return this.ranks.keySet();
    }
}

